(function($) {
	"use strict";
	var buildplus_core_has_sidebar = false;
	if( $('#page-sidebar').length > 0 ){
		buildplus_core_has_sidebar = true;
	}
	
	// slider certifications
    $.buildplus_core_image_slider = function(){
		$(".list-certifications").slick({
            dots: true,
            arrows: false,
            slidesToShow: 1,
            slidesToScroll: 1
        });
	};
	// count down
	$.buildplus_core_count_down = function(){
		// set up time coming soon
		 $('.coming-soon').each(function(){
		 	var date = $(this).data('date');
			var target_date = new Date(date).getTime();
		 	if(target_date){
		 		// variables for time units
				var days, hours, minutes, seconds;
				 
				var $days = $("#days",$(this)),
					$hours = $("#hours",$(this)),
					$minutes = $("#minutes",$(this)),
					$seconds = $("#seconds",$(this));
				  
				var center = 0,
					canvas = document.getElementById('timer',$(this)),
					ctx = canvas.getContext("2d"),
					daySetup = {  
					},
					hourSetup = {
					},
					minSetup = {
					},
					secSetup = {
					},
					check = function(count, setup, ctx) {
						if (count < setup.old){
						  setup.counter++
						};
					};
				 
				// update the tag with id "countdown" every 1 second
				setInterval(function () {
					// find the amount of "seconds" between now and target
					var current_date = new Date().getTime();
					var seconds_left = (target_date - current_date) / 1000;
				 
					// do some time calculations
					days = parseInt(seconds_left / 86400);
					seconds_left = seconds_left % 86400;
					 
					hours = parseInt(seconds_left / 3600);
					seconds_left = seconds_left % 3600;
					 
					minutes = parseInt(seconds_left / 60);
					seconds = parseInt(seconds_left % 60);
					 
					$days.text(days);
					$hours.text(hours);
					$minutes.text(minutes);
					$seconds.text(seconds);
				}, 1000);
		 	}
		 })
	};
	// Partner
	$.buildplus_core_partner = function(){
		 // slider logo
		$('.sc-partner').each(function(){
			var number = $(this).data('number');
			var block = $(this).attr('data-item');
			var dot  = $(this).data('dot');
			$(block + " .list-logo").slick({
				dots: dot,
				arrows: false,
				infinite: true,
				autoplay: true,
				speed: 300,
				slidesToShow: number,
				slidesToScroll: 1
			});
		});	
	};
	// Testimonial
	$.buildplus_core_testimonial = function(){
		$('.sc-testimonial').each(function(){
			var block = $(this).attr('data-item');
			var style   = $(this).data('list');
			var dot   = false;
			var arrow = true;
			if(style == 1){
				dot = true;
				arrow = false; 
			}
			$(block + " .testimonial-detail").slick({
				dots: dot,
				arrows: arrow,
				infinite: true,
				autoplay: false,
				speed: 300,
				fade: true,
				slidesToShow: 1,
				slidesToScroll: 1,
				adaptiveHeight: true
			});
		});	
	};
	
	$.buildplus_core_gallery = function( is_destroy ) {
		var galleryContent = '';
		var item = '';
		var block = '';
		
		if ( $('.sc_gallery_masonry .gallery-content').length ) {	
			$('.sc_gallery_masonry .galleryIsotope').each(function(){
				if (is_destroy == true) {
					$(this).isotope('destroy');
				}
				var filterCat = '*';
				var filter_active = $(this).closest('.gallery-content').find('.tab-filter .tab.active').data('filter');
				if ( typeof filter_active !== 'undefined') {
					filterCat = filter_active;
				}
				var $grid = $(this).isotope({
					filter: filterCat,
					itemSelector: '.grid-item',
					layoutMode: 'masonry',
					percentPosition: true,
					masonry: {
						columnWidth: '.grid-item'
					}
				});
				$(this).closest('.gallery-content').find('.tab-filter .tab.active').trigger('click');

				var filterFns = {
					numberGreaterThan50: function () {
						var number = $(this).find('.number').text();
						return parseInt(number, 10) > 50;
					},
					ium: function () {
						var name = $(this).find('.name').text();
						return name.match(/ium$/);
					}
				};

				$(this).closest('.gallery-content').find('.tab-filter').on('click', '.tab', function () {
					var filterValue = $(this).attr('data-filter');
					filterValue = filterFns[filterValue] || filterValue;
					$grid.isotope({filter: filterValue});
				});

				$(this).closest('.gallery-content').find('.tab-filter').each(function (i, buttonGroup) {
					var $buttonGroup = $(buttonGroup);
					$buttonGroup.on('click', '.tab', function () {
						$buttonGroup.find('.active').removeClass('active');
						$(this).addClass('active');
						var filter = $(this).data('filter');
						var loadmore = $(this).closest('.gallery-content').find('.load-more');
						if ( filter == '*' ) {
							loadmore.show();
						} else {
							loadmore.hide();
						}
					});
				});
			});


			var galleryContent = $('.sc_gallery_masonry .gallery-content');
			$.buildplus_core_gallery_process_fancybox_group(galleryContent.find('.galleryContainer'), true);

			galleryContent.each(function() {
				item = $(this).attr('data-item');
				block = '.' + item + ' ';
				$(block + ".fancybox").fancybox({
					pixelRatio  : 1,
					autoSize	: true,
					helpers	 : {
						title   : {
							type: 'outside'
						},
						thumbs  : {
							width   : 96,
							height  : 60
						},
						overlay : {
							locked: false
						}
					}
				});
				
			});
		}

	};

	$.buildplus_core_ajax_gallery_load_more = function() {
		var galleryContent = '';
		var item = '';
		var block = '';
		if ( $('.sc_gallery_masonry .gallery-content') ) {
			var galleryContent = $('.sc_gallery_masonry .gallery-content');
			galleryContent.each(function() {
				item = $(this).attr('data-item');
				block = '.' + item + ' ';
				$(block + '.gallery_more').unbind("click");
				$(block + '.gallery_more').on('click', function(e){
					e.preventDefault();
					jQuery.buildplus_core_ajax_gallery(this);
				});
			});
		}
	};

	$.buildplus_core_ajax_gallery = function(a, clear_clone) {
		var gallery_cont = $(a).parents('.gallery-content');
		if( clear_clone != undefined ) {
			gallery_cont.find('.grid-clone').html('');
		}
		$(a).addClass("loading");
		var atts = jQuery.parseJSON($(a).attr('data-json'));
		$.fn.Form.ajax(['top.Top_Controller', 'ajax_get_more_gallery'], [atts], function(res) {
			gallery_cont.find('.grid-clone').append(res);
			gallery_cont.find('.grid-content').html("<div class='grid'>" + gallery_cont.find('.grid-clone').html() + "</div>");
			var gallery_atts_more = gallery_cont.find('.grid-clone .gallery_atts_more');
			gallery_cont.find('.grid').height(gallery_cont.find('.galleryContainer').height());/*fix nhảy lên top gallery*/
			var data_pages = gallery_atts_more.attr('data-pages');
			if( data_pages == '') {
				gallery_cont.find('.load-more').remove();
			}
			gallery_cont.find('.gallery_more').attr('data-json', gallery_atts_more.attr('data-json'));
			gallery_atts_more.remove();
			jQuery.buildplus_core_gallery();
			setTimeout(function() {
				gallery_cont.find('.galleryIsotope').isotope('destroy').isotope({
					itemSelector: '.grid-item',
					layoutMode: 'masonry',
					percentPosition: true,
					masonry: {
						columnWidth: '.grid-item'
					}
				});
				gallery_cont.find('.grid').height(gallery_cont.find('.galleryContainer').height());/*fix nhảy lên top gallery*/
			}, 100);
			$(a).removeClass("loading");
		});
	};

	$.buildplus_core_gallery_process_fancybox_group = function(block, is_add ) {
		if( is_add == undefined ) {
			is_add = false;
		}
		if ( typeof block !== 'undefined') {
			if ( is_add ) {
				$(block).find('.grid-content .fancybox').each(function() {
					var group = $(this).attr('data-fancybox-group-ori');
					$(this).attr('data-fancybox-group', group + '-use');
				});
			}			
		}
	};

	$.buildplus_core_gallery_slide_sc = function() {
		// gallery masonry slider
		if ( $('.gallery-images-nested').length ) {
			$(".gallery-images-nested").slick({
	            dots: false,
	            arrows: true,
	            slidesToShow: 1,
	            slidesToScroll: 1,
	            autoplay: false,
	            autoplaySpeed: 30000
        	});
		}
		if ( $('.sc_gallery_slide').length ) {
			var galleryContent = $('.sc_gallery_slide');
			galleryContent.each(function() {
				var item = $(this).attr('data-item');
				var block = '#' + item + ' ';
				var slick_block = $(block + ".gallery-slide-slick");
				var slick_json = $(slick_block).data('slick-json');
				if (typeof slick_json !== 'undefined') {
					slick_block.slick( slick_json );
				}

				$.buildplus_core_gallery_process_fancybox_group($(block), true);

				$(block + ".fancybox").fancybox({
					pixelRatio  : 1,
					autoSize	: true,
					helpers	 : {
						title   : {
							type: 'outside'
						},
						thumbs  : {
							width   : 80,
							height  : 60
						},
						overlay : {
							locked: false
						}
					}
				});				
			});
		}

	};
	// Video
	$.buildplus_core_video = function(){
		if ($(".video-embed").length) {
			var gurl = $(".video-embed")[0].src;
			
			$(".btn-play").on('click', function(event) {
				if( $(this).parent().find(".video-embed")[0] != undefined ){
					$(this).parent().find(".video-embed").addClass('show-video');
					$(this).parent().find(".btn-close").addClass('show-video');
					$(this).parent().find(".video-embed")[0].src += "&autoplay=1";
					event.preventDefault();
				}
			});

			$(".btn-close").on('click', function(event) {
				 $(this).parent().find(".video-embed")[0].src = gurl;
				 $(this).parent().find(".video-embed").removeClass('show-video');
				 $(this).parent().find(".btn-close").removeClass('show-video');
			});
		}
	};
	// Number Factor
	$.buildplus_core_number_factor = function(){
		if($(".count-number").length) {
			$('.count-number').appear(function(){
				setTimeout(function(){
					$('.count-number .number').countTo();
				},300);
			});
		}
	};
	$.buildplus_core_post_slide = function(){
		if( $(".post-list-slide").length == 0) return;
		var slide_show = 3,
			has_arrows = true;
		
		if( buildplus_core_has_sidebar ) {
			slide_show = 2;
			has_arrows = false;
		}
		$(".post-list-slide").slick({
			dots: true,
			arrows: has_arrows,
			infinite: true,
			speed: 600,
			slidesToShow: slide_show,
			slidesToScroll: slide_show,
			responsive: [
				{
					breakpoint: 769,
					settings: {
						slidesToShow: 2,
						slidesToScroll: 2,
					}
				},
				{
					breakpoint: 481,
					settings: {
						slidesToShow: 1,
						slidesToScroll: 1,
					}
				}
			]
		});
	};
	$.buildplus_core_block_slide = function(){
		if( $(".list-block-slick").length == 0) return;
		var has_arrows = true, show_dots = false;
	
		if( buildplus_core_has_sidebar ) {
			has_arrows = false;
			show_dots = true;
		}
		$(".list-block-slick").each(function() {
			var item_show = $(this).attr('data-col'),
				cont_block = $(this).attr('data-item');
			if( item_show == undefined || item_show == '' ) {
				item_show = 2;
			}
			
			$("." + cont_block).slick({
				dots: show_dots,
				arrows: has_arrows,
				infinite: true,
				slidesToShow: item_show,
				slidesToScroll: 1,
				responsive: [
					{
						breakpoint: 769,
						settings: {
							dots: true,
							arrows: false
						}
					},
					{
						breakpoint: 569,
						settings: {
							dots: true,
							arrows: false,
							slidesToShow: 1
						}
					}
				]
			});
		});
	};

	$.buildplus_core_project_list_sc = function() {
		if ( $('.sc_project_list').length ) {
			$('.sc_project_list').each(function() {
				var item = $(this).attr('data-item');
				var block = '.' + item + ' ';
				var slick_block = $(block + ".project_slide_slick");
				if ( slick_block.length ) {
					var slick_json = $(slick_block).data('slick-json');
					if (typeof slick_json !== 'undefined') {
						slick_block.slick( slick_json );
					}					
				}	
			});
		}
	};
	
	$.buildplus_core_project_carousel = function(){
		if ( $('.sc_project_carousel').length ) {
			$('.sc_project_carousel').each(function() {
				var item = $(this).attr('data-item');
				var block = '.' + item + ' ';

				$(block + ".list-project").slick({
					dots: false,
					arrows: true,
					infinite: false,
					draggable: false,
					slidesToShow: 1,
					slidesToScroll: 1,
					speed: 700,
				});

				$(block + ".slider-syncing-wrapper").each(function(){
					$(this).find('.slider-for').slick({
						slidesToShow: 1,
						slidesToScroll: 1,
						arrows: false,
						dots: false,
						fade: true,
						asNavFor: $(this).find('.slider-nav')
					});
					$(this).find('.slider-nav').slick({
						slidesToShow: 5,
						slidesToScroll: 1,
						arrows: false,
						dots: false,
						asNavFor: $(this).find('.slider-for'),
						focusOnSelect: true
					});
				});

			});
		}

	};

	$.buildplus_core_service_list_sc = function() {
		if ( $('.sc_service_list').length ) {
			$('.sc_service_list').each(function() {
				var item = $(this).attr('data-item');
				var block = '.' + item + ' ';
				var slick_block = $(block + ".service_slide_slick");
				if ( slick_block.length ) {
					var slick_json = $(slick_block).data('slick-json');
					if (typeof slick_json !== 'undefined') {
						slick_block.slick( slick_json );
					}					
				}	
			});
		}
	};

	$.buildplus_core_service_carousel = function(){
		if ( $('.sc_service_carousel').length ) {
			$('.sc_service_carousel').each(function() {
				var item = $(this).attr('data-item');
				var block = '.' + item + ' ';
				$(block + '.slider-vertical-wrapper').each(function(){
					$(this).find('.slider-for').slick({
						slidesToShow: 1,
						slidesToScroll: 1,
						arrows: false,
						dots: true,
						vertical: true,
						verticalSwiping: true,
						responsive: [{
						    breakpoint: 1025,
						    settings: {
						        dots: false,
						        verticalSwiping: false,
						    }
						}],
						asNavFor: $(this).find('.slider-nav')
					});
					$(this).find('.slider-nav').slick({
						slidesToShow: 4,
						slidesToScroll: 1,
						vertical: true,
						asNavFor: $(this).find('.slider-for'),
						focusOnSelect: true,
						responsive: [
							{
							    breakpoint: 1025,
							    settings: {
							        vertical: false,
							        slidesToShow: 2,
							        autoplay: true,
							        autoplaySpeed: 4000,
							    }
							},
							{
							    breakpoint: 415,
							    settings: {
							        vertical: false,
							        slidesToShow: 1,
							        autoplay: true,
							        autoplaySpeed: 4000,
							    }
							}
						]
					});
				});
			});
		}
	};

	$.buildplus_core_team_list_sc = function() {
		if ( $('.sc_team_list').length ) {
			$('.sc_team_list').each(function() {
				var item = $(this).attr('data-item');
				var block = '.' + item + ' ';
				var slick_block = $(block + ".team_slide_slick");
				if ( slick_block.length ) {
					var slick_json = $(slick_block).data('slick-json');
					if (typeof slick_json !== 'undefined') {
						slick_block.slick( slick_json );
					}					
				}	
			});
		}
	};

	$.buildplus_core_slider_syncing = function(){
		if( $(".slz-image-slider.slider-syncing-wrapper").length > 0 ){
			$(".slz-image-slider.slider-syncing-wrapper").each(function(){
				$(this).find('.slider-for').slick({
					slidesToShow: 1,
					slidesToScroll: 1,
					arrows: false,
					dots: false,
					fade: true,
					asNavFor: $(this).find('.slider-nav'),
					responsive: [
						{
							breakpoint: 770,
							settings: {
								draggable: false
							}
						}
					]
				});
				$(this).find('.slider-nav').slick({
					slidesToShow: 5,
					slidesToScroll: 1,
					arrows: false,
					dots: false,
					asNavFor: $(this).find('.slider-for'),
					focusOnSelect: true,
					responsive: [
						{
							breakpoint: 770,
							settings: {
								draggable: false
							}
						},
						{
							breakpoint: 570,
							settings: {
								raggable: false,
								slidesToShow: 3,
							}
						},
						{
							breakpoint: 380,
							settings: {
								raggable: false,
								slidesToShow: 2,
							}
						}
					]
				});
			});
		}
	};
	/* pagination with ajax */
	$.buildplus_core_project_pagination = function() {
		if ($('.sc_project_list .pagination-wrapper.paging-ajax ul li a').length > 0){
			$('.sc_project_list .pagination-wrapper.paging-ajax ul li a').unbind("click");
			$('.sc_project_list .pagination-wrapper.paging-ajax ul li a').on('click', function(e){
				e.preventDefault();
				var container  = $(this).closest('.sc_project_list');
				$('.slz-loader-wrapper', container).show().fadeIn();
				var page = parseInt( $(this).data('page') );
				var base = $(this).closest('.paging-ajax').parent().find('.slz-pagination-base').attr('data-base');
				var atts = $(this).closest('.paging-ajax').parent().find('.slz-pagination-json').attr('data-json');
				var data = {"page":page, "base":base, "atts":jQuery.parseJSON(atts) };
				$.fn.Form.ajax(['top.Top_Controller', 'ajax_project_pagination'], data, function(res) {
					$('.content-our-project', container).html(res);
					$('.slz-loader-wrapper', container).show().fadeOut();
					$('.progress-bar-wrapper .progress-bar', container).each(function() {
						if( $(this).attr('aria-valuenow') ){
							$(this).css( 'width', $(this).attr('aria-valuenow') + '%' );
						}
					});
					$.buildplus_core_project_pagination();
				});
			});
		}
	};
	$.buildplus_core_service_pagination = function() {
		if ($('.sc_service_list .pagination-wrapper.paging-ajax ul li a').length > 0){
			$('.sc_service_list .pagination-wrapper.paging-ajax ul li a').unbind("click");
			$('.sc_service_list .pagination-wrapper.paging-ajax ul li a').on('click', function(e){
				e.preventDefault();
				var container  = $(this).closest('.sc_service_list');
				$('.slz-loader-wrapper', container).show().fadeIn();
				var page = parseInt( $(this).data('page') );
				var base = $(this).closest('.paging-ajax').parent().find('.slz-pagination-base').attr('data-base');
				var atts = $(this).closest('.paging-ajax').parent().find('.slz-pagination-json').attr('data-json');
				var data = {"page":page, "base":base, "atts":jQuery.parseJSON(atts) };
				$.fn.Form.ajax(['top.Top_Controller', 'ajax_service_pagination'], data, function(res) {
					$('.list-block-services', container).html(res);
					$('.slz-loader-wrapper', container).show().fadeOut();
					$.buildplus_core_service_pagination();
				});
			});
		}
	};
	$.buildplus_core_team_pagination = function() {
		if ($('.sc_team_list .pagination-wrapper.paging-ajax ul li a').length > 0){
			$('.sc_team_list .pagination-wrapper.paging-ajax ul li a').unbind("click");
			$('.sc_team_list .pagination-wrapper.paging-ajax ul li a').on('click', function(e){
				e.preventDefault();
				var container  = $(this).closest('.sc_team_list');
				$('.slz-loader-wrapper', container).show().fadeIn();
				var page = parseInt( $(this).data('page') );
				var base = $(this).closest('.paging-ajax').parent().find('.slz-pagination-base').attr('data-base');
				var atts = $(this).closest('.paging-ajax').parent().find('.slz-pagination-json').attr('data-json');
				var data = {"page":page, "base":base, "atts":jQuery.parseJSON(atts) };
				$.fn.Form.ajax(['top.Top_Controller', 'ajax_team_pagination'], data, function(res) {
					$('.team-content', container).html(res);
					$('.slz-loader-wrapper', container).show().fadeOut();
					$.buildplus_core_team_pagination();
				});
			});
		}
	};

	$.buildplus_slick_fancy = function () {
		$('.slz-image-slider .slider-for .slick-current.slick-active').fancybox({
            helpers: {
                overlay: {
                    locked: false,
                }
            }
		});
	}

})(jQuery);

jQuery( document ).ready( function() {
	new WOW().init();
	jQuery.buildplus_core_gallery();
	setTimeout(function() { 
		jQuery.buildplus_core_gallery(true); 
	}, 2000);
	jQuery.buildplus_core_ajax_gallery_load_more();
	jQuery.buildplus_core_gallery_slide_sc();
	jQuery.buildplus_core_testimonial();
	jQuery.buildplus_core_video();
	jQuery.buildplus_core_number_factor();
	jQuery.buildplus_core_count_down();
	jQuery.buildplus_core_post_slide();
	jQuery.buildplus_core_block_slide();
	jQuery.buildplus_core_image_slider();
	jQuery.buildplus_core_partner();
	jQuery.buildplus_core_project_carousel();
	jQuery.buildplus_core_project_list_sc();
	jQuery.buildplus_core_service_carousel();
	jQuery.buildplus_core_service_list_sc();
	jQuery.buildplus_core_team_list_sc();
	jQuery.buildplus_core_slider_syncing();
	jQuery.buildplus_core_project_pagination();
	jQuery.buildplus_core_service_pagination();
	jQuery.buildplus_core_team_pagination();
	jQuery.buildplus_slick_fancy();
});
jQuery( window ).load( function() {
});
jQuery( window ).resize( function() {
	
});