<?php
$align = Buildplus_Core_Params::get('align');
$yesno = array(
			esc_html__( 'Yes', 'slz-core' ) => 'yes',
			esc_html__( 'No', 'slz-core' )  => 'no'
		);
$params = array(
	array(
		'type'            => 'textfield',
		'heading'         => esc_html__( 'Subtitle', 'slz-core' ),
		'param_name'      => 'subtitle',
		'value'           => '',
		'description'     => esc_html__( 'Enter subtitle.', 'slz-core' )
	),
	array(
		'type'            => 'textfield',
		'holder'          => 'div',
		'heading'         => esc_html__( 'Title', 'slz-core' ),
		'param_name'      => 'title',
		'value'           => '',
		'description'     => esc_html__( 'Enter title.', 'slz-core' )
	),
	array(
		'type'            => 'textfield',
		'heading'         => esc_html__( 'Title 02', 'slz-core' ),
		'param_name'      => 'title_02',
		'value'           => '',
		'description'     => esc_html__( 'Enter another title.', 'slz-core' )
	),
	array(
		'type'        	=> 'dropdown',
		'heading'     	=> esc_html__( 'Alignment', 'slz-core' ),
		'param_name'  	=> 'align',
		'value'       	=> $align,
		'description' 	=> esc_html__( 'Choose YES to show line on the left of title.', 'slz-core' )
	),
	array(
		'type'        	=> 'dropdown',
		'heading'     	=> esc_html__( 'Show Line', 'slz-core' ),
		'param_name'  	=> 'show_line',
		'value'       	=> $yesno,
		'std'      		=> 'yes',
		'description' 	=> esc_html__( 'Choose YES to show line on the left of title.', 'slz-core' )
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Subtitle Color', 'slz-core' ),
		'param_name'      => 'subtitle_color',
		'value'           => '',
		'description'     => esc_html__( 'Select color for subtitle.', 'slz-core' ),
		'group'           => esc_html__('Custom', 'slz-core')
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Title Color', 'slz-core' ),
		'param_name'      => 'title_color',
		'value'           => '',
		'description'     => esc_html__( 'Select color for title.', 'slz-core' ),
		'group'           => esc_html__('Custom', 'slz-core')
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Title 02 Color', 'slz-core' ),
		'param_name'      => 'title_02_color',
		'value'           => '',
		'description'     => esc_html__( 'Select color for title 02.', 'slz-core' ),
		'group'           => esc_html__('Custom', 'slz-core')
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Line Color', 'slz-core' ),
		'param_name'      => 'line_color',
		'value'           => '',
		'description'     => esc_html__( 'Select color for line.', 'slz-core' ),
		'group'           => esc_html__('Custom', 'slz-core')
	),
	array(
		'type'            => 'textfield',
		'heading'         => esc_html__( 'Margin Bottom', 'slz-core' ),
		'param_name'      => 'mrg_bottom',
		'value'           => '',
		'description'     => esc_html__( 'Enter margin bottom for block. Example: 35px.', 'slz-core' )
	),
	array(
		'type'            => 'textfield',
		'heading'         => esc_html__( 'Extra Class', 'slz-core' ),
		'param_name'      => 'extra_class',
		'value'           => '',
		'description'     => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'slz-core' )
	)
);

vc_map(
	array(
		"name"            => esc_html__( 'SLZ Block Title', 'slz-core' ),
		"base"            => "slzcore_block_title_sc",
		"class"           => "slzcore-sc",
		"category"        => BUILDPLUS_CORE_SC_CATEGORY,
		'icon'            => 'icon-slzcore_block_title_sc',
		"description"     => esc_html__( 'Create title block.', 'slz-core' ),
		"params"          => $params
	)
);
