<?php
class Buildplus_Core_Image_Box {
	public $attributes;
	public $uniq;
	public function __construct() {
		$this->meta_attributes();
		$this->uniq = Buildplus_Core::make_id();
	}
	
	public function meta_attributes() {
		$default = array(
			'style'              => '',
			'array_list'         => '',
			'title_color'        => '',
			'line_color'         => '',
			'number_color'       => '',
			'title_hover_color'  => '',
			'description_color'  => '',
			'extra_class'        => '',
			'group_values'       => '',
		);
		$this->attributes = $default;
	}
	public function init( $atts, $content = null ) {
		$this->attributes = Buildplus_Core::set_shortcode_defaults( $this->attributes, $atts);
		if( function_exists( 'wpb_js_remove_wpautop' ) ) {
			$content = wpb_js_remove_wpautop( $content, true );
		}
		$this->attributes['content'] = $content;
		if( !empty( $this->attributes['array_list'] ) ){
			$item_content = vc_param_group_parse_atts( $this->attributes['array_list'] );
			$this->attributes['group_values'] = $item_content;
		}
	}
	/*-------------------- >> General Functions << --------------------*/
	public function parse_param_group( $param ){
		$param_def = array(
			'image' => '',
			'url'   => '',
			'title' => '',
			'description' => '',
		);
		$param = array_merge($param_def, $param);
		return $param;
	}
	/*-------------------- >> Render Html << -------------------------*/
	public function render_style_1() {
		$output = $output_row ='';
		$count = 1;
		$responsive_cls = '';
		if( $group_vals = $this->attributes['group_values'] ) {
			foreach ($group_vals as $item) {
				$output_row ='';
				if( $item ) {
					$item = $this->parse_param_group($item);
					$vc_link = Buildplus_Core_Util::get_link($item['url']);
					$att_images = '';
					if( $item['image'] ) {
						$att_images = wp_get_attachment_image_src($item['image'], 'full');
					}
					// image
					$image = '';
					if( $att_images ) {
						$img_src = $att_images[0];
						if( !empty( $vc_link['link'] ) ) {
							$image = '<a href="'.esc_url($vc_link['link']).'" class="img-how">
									<img src="'.esc_url($img_src).'" alt="" class="img img-responsive">
								</a>';
						} else {
							$image = '<span class="img-how"><img src="'.esc_url($img_src).'" alt="" class="img img-responsive"></span>';
						}
						if( $image ) {
							$output_row .= '<div class="main-img">'.$image.'</div>';
						}
					}
					//title
					if( !empty($item['title'])) {
						if( !empty( $vc_link['link'] ) ) {
							$title = '<a href="'.esc_url($vc_link['link']).'" class="timeline-title">'.esc_html($item['title']).'</a>';
						} else {
							$title = '<span class="timeline-title">'.esc_html($item['title']).'</span>';
						}
					}
					//description
					$description = '';
					if(!empty($item['description'])){
						$description = '<div class="timeline-text">'.wp_kses_post($item['description']).'</div>';
					}
					if( $title || $description ) {
						$output_row .= '<div class="main-section-how"><div class="wrapper-how">'. $title . $description .'</div></div>';
					}
					if($output_row) {
						$output .= '<div class="%1$s wp-6"><div class="content-section-how">'.$output_row.'</div></div>';
						$count ++;
						if( $count > 2){
							$responsive_cls = $this->parse_responsive_class($count-1);
							//new row
							$output .= '</div><div class="row">';
							$count = 1;
						}
					}
				}
			}
		}
		if( $output ){
			if( empty($responsive_cls)) {
				$responsive_cls = $this->parse_responsive_class($count-1);
			}
			printf($output, $responsive_cls );
		}
	}
	
}