<?php
$content_class = 'col-md-12';
$model = new Buildplus_Core_Team();
$model->get_single_post(get_the_ID());
$social_list = $model->get_meta_social();
$mail = $model->get_meta_email();
$phone = $model->get_meta_phone();
?>
<div class="row team-about paragraph">
	<?php if($model->has_thumbnail ): $content_class = 'col-md-8';?>
	<div class="col-md-4 col-xs-12">
		<?php the_post_thumbnail( 'large', array( 'class' => 'img-responsive portrait-img' ) ); ?>
	</div>
	<?php endif;?>
	<div class="<?php echo esc_attr($content_class)?> col-xs-12">
		<div class="heading-main">
			<div class="main-title">
				<?php the_title( '<h2 class="title">', '</h2>' );?>
			</div>
		</div>
		<div class="detail-contact-info">
			<?php echo $model->get_meta_position();?>
			<div class="lists">
				<?php if( $mail || $phone ):?>
				<div class="contact-list">
					<?php echo wp_kses_post( $mail );?>
					<?php echo wp_kses_post( $phone );?>
				</div>
				<?php endif;?>
				<?php if( $social_list ):?>
				<div class="social-list list-social"><?php echo wp_kses_post( $social_list );?></div>
				<?php endif;?>
			</div>
		</div>
		<div class="detail-content">
			<?php echo $model->get_meta_information();?>
		</div>
	</div>
</div>