<?php
$model = new BuildPlus_Core_Team();
$model->init( $atts );
$block_cls = $model->attributes['uniq_id'];

// 1$ - image, 2$ - title, 3$ - position, 4$ - social, 5$ - permalink, 6$ - post_id, 7$ - responsive
$html_format = '
	<div class="item team_%6$s inline_block">
		<div class="block-team">
			%1$s
			<div class="block-content">
				%2$s
				%3$s
				<div class="social-list list-social">
					%4$s
				</div>
			</div>
		</div>
	</div>
';
$html_render = array(
	'html_format' 		=> $html_format,
);
if ( $model->query->have_posts() ):
?>
<div class="<?php echo esc_attr( $block_cls ); ?>">
	<div class="list-team">
		<div class="list-block-team list-block column-<?php echo esc_attr($model->attributes['column']); ?>">
			<?php $model->render_team_list_sc( $html_render );?>
		</div>
		<div class="clearfix"></div>
		<?php
			if( !empty($model->attributes['pagination']) && $model->attributes['pagination'] == 'ajax' ) {
				echo '<div class="hide slz-pagination-json" data-json="'.esc_attr(json_encode($model->attributes)).'"></div>';
				echo BuildPlus_Core_Pagination::paging_ajax( $model->query->max_num_pages, 2, $model->query, $base );
			}
		?>
	</div>
</div>
<?php
else:
	get_template_part( 'inc/content', 'none' );
endif;
?>