<?php
/**
 * The template for displaying 404 pages (not found).
 *
 * @author Swlabs
 * @package BuildPlus
 * @since 1.0
 */
$buildplus_the_image          = Buildplus::get_option('slz-404-illustration-image');
$buildplus_title              = Buildplus::get_option('slz-404-title');
$buildplus_description        = Buildplus::get_option('slz-404-desc');
$buildplus_home_link_text     = Buildplus::get_option('slz-404-backhome');
$buildplus_button_link_text   = Buildplus::get_option('slz-404-button-02');
$buildplus_button_link        = Buildplus::get_option('slz-404-button-02-link');
$buildplus_button_link_custom = Buildplus::get_option('slz-404-button-02-link-custom');

if(!empty($buildplus_button_link_custom)){
	$buildplus_button_link = $buildplus_button_link_custom;
}
else{
	if ( !empty($buildplus_button_link) ) {
		$buildplus_button_link = get_page_link($buildplus_button_link);
	}
}
?>
<?php get_header(); ?>
<div class="main-content">
	<div class="page-wrapper">
		
		<div class="container">
			<div class="content-wrapper content-wrapper-404">
				<h1 class="title"><?php echo esc_html($buildplus_title); ?></h1>
				<div class="subtitle"><?php echo wp_kses_post($buildplus_description); ?>
				</div>
				<div class="group-btn">
					<?php if(!empty($buildplus_home_link_text)){?>
						<a href="<?php echo esc_url(site_url()); ?>" class="btn main-color"><?php echo esc_html($buildplus_home_link_text); ?></a>
					<?php }
					if (!empty($buildplus_button_link_text)){?>
						<a href="<?php echo esc_url($buildplus_button_link); ?>" class="btn transparent"><?php echo esc_html($buildplus_button_link_text); ?></a>
					<?php }?>
				</div>
			</div>
		</div>
	</div>
</div>
<?php
if(!empty($buildplus_the_image['url'])){
	$buildplus_custom_css = '.page-wrapper{background-image:url('.esc_url($buildplus_the_image['url']).')}';
	do_action( 'buildplus_add_inline_style', $buildplus_custom_css  );

}
get_footer('none'); 
