<?php
/**
 * Buildplus config class.
 * 
 * @author Swlabs
 * @package BuildPlus
 * @since 1.0
 */
class Buildplus_Config {
	private static $setting = array(
		'save_post' => array(
			'page'             => array( 'theme.Theme_Init', 'save_page' ),
			'post'             => array( 'theme.Theme_Init', 'save_post' ),
			'product'          => array( 'theme.Theme_Init', 'save_product' ),
		),
		'page_options' => array(
			'post_types' => array( 'post', 'page', 'buildplus_project', 'buildplus_service', 'buildplus_team', 'product' ),
		),
		'mapping' => array(
			'special_options' => array(
				'header_layout', 'header_top_show', 'header_logo_show', 'header_sticky_enable',
				'footer_show', 'footer_main_show', 'footer_bottom_show', 'footer_top_show', 'footer_contact_map_show',
				'page_title_show', 'breadcrumb_show', 'title_show', 'header-subcribe', 'footer-subcribe'
			),
			'no-default-options' => array( 'no_default' ),
			'options' => array(
				'header' => array(
					'header_layout'                => 'slz-header-layout',
					'header_sticky_enable'         => 'slz-sticky',
					'header-subcribe'              => 'slz-header-subcribe'
				),
				'general' => array(
					'background_transparent'   => array( 'slz-layout-boxed-bg', 'background-color' ),
					'background_color'         => array( 'slz-layout-boxed-bg', 'background-color' ),
					'background_repeat'        => array( 'slz-layout-boxed-bg', 'background-repeat' ),
					'background_attachment'    => array( 'slz-layout-boxed-bg', 'background-attachment' ),
					'background_position'      => array( 'slz-layout-boxed-bg', 'background-position' ),
					'background_size'          => array( 'slz-layout-boxed-bg', 'background-size' ),
					'background_image'         => array( 'slz-layout-boxed-bg', 'background-image' ),
					'background_image_id'      => array( 'slz-layout-boxed-bg', 'media', 'id' ),
					'page-color'			   => 'slz-theme-color',
				),
				'page_title' => array(
					'page_title_show'          => 'slz-page-title-show',
					'page_title_type_display'  => '',
					'pt_background_color'      => array( 'slz-page-title-bg', 'background-color' ),
					'pt_background_repeat'     => array( 'slz-page-title-bg', 'background-repeat' ),
					'pt_background_attachment' => array( 'slz-page-title-bg', 'background-attachment' ),
					'pt_background_position'   => array( 'slz-page-title-bg', 'background-position' ),
					'pt_background_size'       => array( 'slz-page-title-bg', 'background-size' ),
					'pt_background_image'      => array( 'slz-page-title-bg', 'background-image' ),
					'pt_background_image_id'   => array( 'slz-page-title-bg', 'media', 'id' ),
					'title_show'               => 'slz-show-title',
					'title_custom_content'     => '',
					'title_color'              => array( 'slz-pagetitle-title', 'color' ),
					'breadcrumb_show'          => 'slz-show-breadcrumb',
					'breadcrumb_text_color'    => array( 'slz-breadcrumb-path2', 'color' ),
					'breadcrumb_color'         => array( 'slz-breadcrumb-path', 'color' ),
				),
				'footer' => array(
					'footer_show'              => 'slz-footer',
					'footer_top_show'          => 'slz-footertop-show',
					'footer_main_show'         => 'slz-footer-main-info',
					'footer_bottom_show'       => 'slz-footerbt-show',
					'footer-subcribe'          => 'slz-footer-subcribe',
					'footer_top_show'          => 'slz-footer-top-show'
				),
				'sidebar' => array(
					'sidebar_layout'             => 'slz-sidebar-layout',
					'sidebar_id'                 => 'slz-sidebar',
					'sidebar_post_layout'        => 'slz-blog-sidebar-layout',
					'sidebar_post_id'            => 'slz-blog-sidebar',
					'sidebar_project_layout'     => 'slz-project-sidebar-layout',
					'sidebar_project_id'         => 'slz-project-sidebar',
					'sidebar_service_layout'     => 'slz-service-sidebar-layout',
					'sidebar_service_id'         => 'slz-service-sidebar',
					'sidebar_team_layout'        => 'slz-team-sidebar-layout',
					'sidebar_team_id'            => 'slz-team-sidebar',
					'sidebar_shop_layout'        => 'slz-shop-sidebar-layout',
					'sidebar_shop_id'            => 'slz-shop-sidebar',
				),
				'no_default' => array(
					'body_extra_class'         => 'slz-body-extra-class',
					'ct_padding_top'           => 'slz-content-padding-top',
					'ct_padding_bottom'        => 'slz-content-padding-bottom',
					'slider-header-fixed'      => 'slz-header-hide',
					'comming_soon_title'       => 'slz-cms-title',
					'comming_soon_title_color' => 'slz-cms-title-color',
					'comming_soon_border_color'=> 'slz-cms-bd-color',
					'comming_soon_logo'        => 'slz-cms-logo',
					'comming_soon_description' => 'slz-cms-des',
					'comming_soon_newsletter'  => 'slz-cms-newsletter',
					'comming_soon_newsletter'  => 'slz-cms-newsletter',
					'comming_soon_bg'          => 'slz-cms-bg',
					'comming_soon_mask_color'  => 'slz-cms-mask-color',
					'comming_soon_date'        => 'slz-cms-date',
					'pt_other_content'         => 'slz-pagetitle-other-content',
				),
			),
		),
		'image_sizes' => array(
			'buildplus-thumb-1200x800' => array( 'width' => 1200, 'height' => 800 ),
			'buildplus-thumb-800x1215' => array( 'width' => 800, 'height' => 1215 ), //team large
			'buildplus-thumb-800x600'  => array( 'width' => 800, 'height' => 600 ),
			'buildplus-thumb-800x430'  => array( 'width' => 800, 'height' => 430 ),
			'buildplus-thumb-400x300'  => array( 'width' => 400, 'height' => 300 ),
			'buildplus-thumb-270x410'  => array( 'width' => 270,  'height' => 410 ), //team small
			'buildplus-thumb-100x100'  => array( 'width' => 100,  'height' => 100 ), //testimonial small
			'buildplus-thumb-240x350'  => array( 'width' => 240,  'height' => 350 ), //testimonial large
			
		),
		'blog_info' => array(
			'show_category' => 'slz-blog-cat',
			'show_tag'      => 'slz-blog-tag',
			'show_date'     => 'slz-blog-showdate',
			'show_comments' => array('slz-bloginfo', 'enabled', 'comment'),
			'show_views'    => array('slz-bloginfo', 'enabled', 'view'),
			'show_author'   => array('slz-bloginfo', 'enabled', 'author'),
		),
	);
	public static function get_theme_options_init() {
		$params = array(
			// default theme options
			'slz-header-layout'        => 'three',
			'slz-topbar-right-content' => array('enabled' => array('social' => '')),
			'slz-topbar-right-social'  => array('enabled' => array('facebook' => '', 'twitter' => '', 'pinterest' => '')),
			'slz-social-facebook'      => '1',
			'slz-social-twitter'       => '1',
			'slz-social-pinterest'     => '1',
			'slz-page-title-show'      => '1',
			'slz-show-title'           => '1',
			'slz-show-breadcrumb'      => '1',
			'slz-footer'               => '1',
			'slz-footerbt-show'        => '1',
			'slz-footerbt-col2'        => array( 'enabled' => array('text' => '') ),
			'slz-footerbt2-text'       => esc_html__('&copy; 2016 BY SWLABS. ALL RIGHT RESERVE.', 'buildplus'),
			'slz-sidebar-layout'       => 'left',
			'slz-blog-sidebar-layout'  => 'left',
			'slz-404-title'            => esc_html__('Page not found', 'buildplus'),
			'slz-404-desc'             => esc_html__('Please go back to home and try to find out once again.', 'buildplus'),
			'slz-404-backhome'         => esc_html__('Go Home', 'buildplus'),
			'slz-404-button-02'        => esc_html__('Get Help', 'buildplus'),
			//blog
			'slz-bloginfo'             => array('enabled' => array('author' => '', 'view' => '', 'comment' => '')),
			'slz-blog-showdate'        => 'ribbon',
			'slz-blog-author'          => '1',
			'slz-blog-tag'             => '1',
			'slz-blog-cat'             => '1',
			'slz-blog-related-post'    => '1',
		);
		return $params;
	}
	/**
	 * Retrieve value from the config variable.
	 *
	 * @param string $name The key name of first level.
	 * @param string $field optional The key name of second level.
	 * @return mixed.
	 */
	public static function get( $name, $field = NULL ) {
		if( isset( self::$setting[ $name ] ) ) {
			if( $field ) {
				return ( isset( self::$setting[ $name ][ $field ] ) ) ? self::$setting[ $name ][ $field ] : null;
			} else {
				return self::$setting[ $name ];
			}
		}
		
		return array();
	}
}