<?php
$bloginfo = Buildplus::get_option('slz-bloginfo', 'enabled');
edit_post_link( esc_html__( 'Edit', 'buildplus' ), '<div class="block item edit-link"><i class="fa fa-pencil"></i>', '</div>' );
if ( !empty($bloginfo) ) :
	foreach ($bloginfo as $key => $value) {
		switch ( $key ) {
			case 'author':
				$author_url = get_author_posts_url( get_the_author_meta( 'ID' ) );
				if( $author_url ) {
					$author_string = '<div class="block"><a href="%1$s" class="link">%2$s</a></div>';
				} else {
					$author_string = '<div class="block"><p class="link">%2$s</p></div>';
				}
				echo sprintf( 
					$author_string,
					esc_url( $author_url ),
					esc_html( get_the_author_meta( 'display_name' ) )
				);
				break;
			case 'comment':
				if ( ! post_password_required() && ( comments_open() || get_comments_number() ) ) : ?>
					<div class="block">
						<a  href="<?php echo esc_url( get_comments_link() )?>" class="link">
							<?php echo wp_kses_post( get_comments_number_text() );?>
						</a>
					</div>
				<?php endif;
				break;
			case 'view':
				$view_count = buildplus_postview_get( get_the_ID() );?>
				<div class="block">
					<a class="link">
						<?php printf( _n('%s View', '%s Views', $view_count, 'buildplus'), $view_count ); ?>
					</a>
				</div><?php
				break;
			case 'date':
				if(Buildplus::get_option('slz-blog-showdate') == 'normal'){
					echo buildplus_post_date();
				}
				break;
			default:
				break;
		}
	}
endif;