<?php
$show_page_title = Buildplus::get_option('slz-page-title-show');
$show_title = Buildplus::get_option('slz-show-title');
$show_breadcrumb = Buildplus::get_option('slz-show-breadcrumb');

if ( $show_page_title != '1' ) {
	return;
}
$title = '';
$opt_title_type = Buildplus::get_option('slz-page-title-type-display');
$breadcrumb = buildplus_get_breadcrumb();

$count_breadcrumb = count($breadcrumb);
list($post_id, $shop_page) = buildplus_get_post_id();

//title
$page_options = get_post_meta( $post_id, 'buildplus_page_options', true);
$page_title_default = Buildplus::get_value($page_options, 'page_title_default');
if( empty($page_title_default) && !empty($page_options['title_custom_content']) ) {
	$title = $page_options['title_custom_content'];
}
elseif ( empty($page_title_default) && !empty($page_options['page_title_type_display']) ) {
	if ( $page_options['page_title_type_display'] == 'level' && $count_breadcrumb > 2 ) {
		$title = $breadcrumb[$count_breadcrumb-2][0];
	} elseif ( $page_options['page_title_type_display'] == 'post' ) {
		$title = get_the_title();
	}
}
elseif ( ( $opt_title_type == 'level' ) && $count_breadcrumb > 2 ) {
	$title = $breadcrumb[$count_breadcrumb-2][0];
}
elseif( is_single() ) {
	$post_type = get_post_type( $post_id );
	if ( $post_type && 'post' != $post_type ) {
		$post_type_obj = get_post_type_object( $post_type );
		$title = $post_type_obj->labels->singular_name;
	} else {
		$cat = current( get_the_category( $post_id ) );
		if( $cat ) {
			$title = $cat->name;
		}
	}
} else {
	$title = get_the_title();
}
?>
<!-- Page Title -->
<?php if ( $show_page_title  == '1' ):?>
<div class="banner-pages">
	<div class="container container-wrapper">
		<div class="banner-wrapper">
			<div class="title-wrapper">
				<?php if ( $show_title == '1' ): ?>
				<h1 class="title">
					<?php
						$output_title = '';
						if ( is_search() ) {
							$output_title = esc_html__( 'Search results', 'buildplus' );
						} elseif ( !is_tax() && $opt_title_type == 'level' && $count_breadcrumb > 2 ) {
							$output_title = $title;
						} 
						else if( is_tax()) {
							$output_title = single_cat_title();
						}
						else if( is_single()) {
							$output_title = the_title();
						}
						elseif( !is_tax() && is_archive() ) {
							if ( is_month() ) {
								$output_title = sprintf( '%s' , get_the_date( esc_html_x( 'F Y', 'monthly archives date format', 'buildplus' ) ) );
							} elseif ( is_day() ) {
								$output_title = sprintf( '%s' , get_the_date( esc_html_x( 'F j, Y', 'daily archives date format', 'buildplus' ) ) );
							} else{
								$output_title = get_the_archive_title();
							}
							if( BUILDPLUS_WOOCOMMERCE_ACTIVE ) {
								if( is_shop() ) {
									if( empty($page_title_default) && !empty($page_options['title_custom_content']) ) {
										$output_title = $page_options['title_custom_content'];
									} else {
										$output_title = wc_get_page_id( 'shop' ) ? get_the_title( wc_get_page_id( 'shop' ) ) : '';
										if ( ! $output_title ) {
											$product_post_type = get_post_type_object( 'product' );
											$output_title = $product_post_type->labels->singular_name;
										}
									}
								}
							}
						}
                        else if( is_404() ) {
							$output_title = esc_html__( 'Error 404', 'buildplus' );
						}             
						else {
							$output_title = esc_html($title);
						}
						echo wp_kses_post( $output_title );?>
					
				</h1>
				<?php endif; // show_title ?>
				<?php if ( $show_breadcrumb  == '1' ):
						$breadcrumb_html = '';
//                    echo '<pre>';
//                    print_r($breadcrumb);
//                    echo '</pre>';
						if ( $breadcrumb && !is_tax() && !is_single() == 'buildplus_service' && !is_single() == 'buildplus_project' ) {
							foreach ( $breadcrumb as $key => $crumb ) {
								if ( ! empty( $crumb[1] ) && sizeof( $breadcrumb ) !== $key + 1 ) {
									$breadcrumb_html .= '<li class="breadcrumb-item"><a class="breadcrumb-link" href="' . esc_url( $crumb[1] ) . '">' . esc_html( $crumb[0] ) . '</a></li>';
								} else {
									if( ! empty( $crumb[0] ) ) {
										$breadcrumb_html .= '<li class="breadcrumb-item"><a class="breadcrumb-active">' . esc_html( $crumb[0] ) . '</a></li>';
									}
								}
							}
						}
                        elseif( $breadcrumb && is_tax()) {
                            $currentTaxonomy = get_queried_object();
                            if($currentTaxonomy->taxonomy == "buildplus_service_cat"){
                                $breadcrumb_html .= '<li class="breadcrumb-item"><a class="breadcrumb-link" href="/">Home</a></li>';
                                $breadcrumb_html .= '<li class="breadcrumb-item"><a class="breadcrumb-link" href="'. get_permalink(1766) .'">'. get_the_title(1766) .'</a></li>';
                                $breadcrumb_html .= '<li class="breadcrumb-item"><a class="breadcrumb-active">' . esc_html( $breadcrumb[2][0]) . '</a></li>';
                            }
                            if($currentTaxonomy->taxonomy == "buildplus_project_cat"){
                                $breadcrumb_html .= '<li class="breadcrumb-item"><a class="breadcrumb-link" href="/">Home</a></li>';
                                $breadcrumb_html .= '<li class="breadcrumb-item"><a class="breadcrumb-link" href="'. get_permalink(1768) .'">'. get_the_title(1768) .'</a></li>';
                                $breadcrumb_html .= '<li class="breadcrumb-item"><a class="breadcrumb-active">' . esc_html( $breadcrumb[2][0]) . '</a></li>';
                            }
                        }
						elseif( $breadcrumb && is_single()) {
                            $post_type = get_post_type( $post_id );
                            if($post_type == "buildplus_service"){
                                $breadcrumb_html .= '<li class="breadcrumb-item"><a class="breadcrumb-link" href="/">Home '.is_single().'</a></li>';
                                $breadcrumb_html .= '<li class="breadcrumb-item"><a class="breadcrumb-link" href="'. get_permalink(1766) .'">'. get_the_title(1766) .'</a></li>';
                                $breadcrumb_html .= '<li class="breadcrumb-item"><a class="breadcrumb-active">' . esc_html( $breadcrumb[2][0]) . '</a></li>';
                            }
                            elseif( $post_type == 'buildplus_project' ) {
                                $breadcrumb_html .= '<li class="breadcrumb-item"><a class="breadcrumb-link" href="/">Home</a></li>';
                                $breadcrumb_html .= '<li class="breadcrumb-item"><a class="breadcrumb-link" href="' . get_permalink(1768) . '">' . get_the_title(1768) . '</a></li>';
                                $breadcrumb_html .= '<li class="breadcrumb-item"><a class="breadcrumb-active">' . esc_html($breadcrumb[2][0]) . '</a></li>';
                            }
                        }
						?>
						<div class="breadcrumb-wrapper">
							<?php printf('<ol class="breadcrumb">%s</ol>', $breadcrumb_html );?>
						</div>
				<?php endif;//show_breadcrumb?>
			</div>
			<?php if( Buildplus::get_option('slz-pagetitle-other-content')):?>
			<div class="banner-btn">
				<?php echo do_shortcode(Buildplus::get_option('slz-pagetitle-other-content'));?>
			</div>
			<?php endif;?>
			<div class="clearfix"></div>
		</div>
	</div>
</div>
<?php endif; // show_title ?>