<?php
/**
 * Theme class.
 * 
 * @author Swlabs
 * @package BuildPlus
 * @since 1.0
 */
Buildplus::load_class( 'Abstract' );
class Buildplus_Theme_Init extends Buildplus_Abstract {
	/**
	 * Register style/script in admin
	 * 
	 */
	public function admin_enqueue(){
		$uri = get_template_directory_uri() . '/assets/admin';
		// css
		wp_enqueue_style( 'buildplus-admin-style',   $uri . '/css/buildplus-admin-style.css', false, BUILDPLUS_THEME_VER, 'all' );
		wp_enqueue_style( 'font-awesome.min',        BUILDPLUS_PUBLIC_URI . '/font/font-icon/font-awesome/css/font-awesome.min.css', array(), false );
		wp_enqueue_style( 'buildplus-font-flaticon', BUILDPLUS_PUBLIC_URI . '/font/font-icon/font-construction/flaticon.css', array(), BUILDPLUS_THEME_VER );
		// js
		wp_enqueue_media();
		wp_enqueue_script( 'buildplus-widget',      $uri . '/js/buildplus-widget.js', array('jquery'), BUILDPLUS_THEME_VER, true );
		//menu
		wp_enqueue_script( 'buildplus-menu',        $uri . '/js/buildplus-menu.js', array('jquery'), BUILDPLUS_THEME_VER, true );
			//menu
		wp_enqueue_script( 'datetimepicker',        $uri . '/js/datetimepicker.js', array('jquery'), BUILDPLUS_THEME_VER, true );
	}

	/**
	 * Register style/script in public
	 */
	public function public_enqueue() {
		$dir_uri = get_template_directory_uri();
		$uri = BUILDPLUS_PUBLIC_URI;
		$site_skin = Buildplus::get_option( 'slz-theme-color' );

		$site_skin_array = array('color-default','color-01','color-02');

		wp_enqueue_style( 'buildplus-style', get_stylesheet_uri(), array(), BUILDPLUS_THEME_VER );
		//font
		wp_enqueue_style( 'buildplus-fonts',         $this->add_fonts_url(), array(), null );
		wp_enqueue_style( 'font-awesome.min',        $uri . '/font/font-icon/font-awesome/css/font-awesome.min.css', array(), false );
		wp_enqueue_style( 'buildplus-font-flaticon', $uri . '/font/font-icon/font-construction/flaticon.css', array(), BUILDPLUS_THEME_VER );

		//libs
		wp_enqueue_style( 'bootstrap.min',             $uri . '/libs/bootstrap/css/bootstrap.min.css', array(), false );
		wp_enqueue_style( 'animate',                   $uri . '/libs/animate/animate.css', array(), false );
		wp_enqueue_style( 'bootstrap-datepicker.min',  $uri . '/libs/bootstrap-datepicker/css/bootstrap-datepicker.min.css', array(), false );

		wp_enqueue_style( 'buildplus-layout',          $uri . '/css/buildplus-layout.css', array(), BUILDPLUS_THEME_VER );
		wp_enqueue_style( 'buildplus-components',      $uri . '/css/buildplus-components.css', array(), BUILDPLUS_THEME_VER );
		wp_enqueue_style( 'buildplus-responsive',      $uri . '/css/buildplus-responsive.css', array(), BUILDPLUS_THEME_VER );

		wp_enqueue_style( 'buildplus-custom-theme',    $uri . '/css/buildplus-custom-theme.css', array(), BUILDPLUS_THEME_VER );
		
		wp_enqueue_style( 'buildplus-custom-editor',   $uri . '/css/buildplus-custom-editor.css', array(), BUILDPLUS_THEME_VER );

		// Woocommerce plugin
		if ( BUILDPLUS_WOOCOMMERCE_ACTIVE ) {
			wp_enqueue_style( 'buildplus-woocommerce',       $uri . '/css/buildplus-woocommerce.css', array(), BUILDPLUS_THEME_VER );
			wp_enqueue_script( 'buildplus-woocommerce',      $uri . '/js/buildplus-woocommerce.js', array('jquery'), BUILDPLUS_THEME_VER, true );
		}

		//load by skin
		if ( in_array( $site_skin,$site_skin_array ) ){
			wp_enqueue_style( 'buildplus-color',            $uri . '/css/color-theme/'.$site_skin.'.css', array(), BUILDPLUS_THEME_VER );
		} else {
			wp_enqueue_style( 'buildplus-color',            $uri . '/css/color-theme/color-default.css', array(), BUILDPLUS_THEME_VER );
		}

		// js
		wp_enqueue_script( 'buildplus-skip-link-focus-fix', $dir_uri . '/js/skip-link-focus-fix.js', array(), '20130115', true );

		// comment
		if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
			wp_enqueue_script( 'comment-reply' );
		}
		wp_enqueue_script( 'bootstrap.min',               $uri . '/libs/bootstrap/js/bootstrap.min.js', array('jquery'), false, true );
		wp_enqueue_script( 'bootstrap-datepicker.min',    $uri . '/libs/bootstrap-datepicker/js/bootstrap-datepicker.min.js', array('jquery'), false, true );
		wp_enqueue_script( 'browser',                     $uri . '/libs/detect-browser/browser.js', array('jquery'), false, true );

		// theme js
		wp_enqueue_script( 'buildplus-main',          $uri . '/js/buildplus-main.js', array(), BUILDPLUS_THEME_VER, true );
		wp_enqueue_script( 'buildplus-custom',        $uri . '/js/buildplus-custom.js', array(), BUILDPLUS_THEME_VER, true );
		

	}
	/**
	 * Google fonts
	 */
	function add_fonts_url() {
		$fonts_url    = '';
		$family_fonts = array();
		$subsets      = 'latin,latin-ext';

		/* Translators: If there are characters in your language that are not supported
			by chosen font(s), translate this to 'off'. Do not translate into your own language.
		*/
		if ( 'off' !== _x( 'on', 'Roboto font: on or off', 'buildplus' ) ) {
			$family_fonts[] = 'Roboto:300,400,500,700,900';
		}
		if ( 'off' !== _x( 'on', 'Montserrat font: on or off', 'buildplus' ) ) {
			$family_fonts[] = 'Montserrat:400,700';
		}
	
		if ( $family_fonts ) {
			$fonts_url = add_query_arg( array(
				'family' => urlencode( implode( '|', $family_fonts ) ),
				'subset' => urlencode( $subsets ),
			), 'https://fonts.googleapis.com/css' );
		}
	
		return $fonts_url;
	}
	/**
	 * General setting
	 * 
	 */
	public function theme_setup() {
		// Editor
		$this->add_theme_supports();
		$this->add_image_sizes();
	}
	/**
	 * Add theme_supports
	 * 
	 */
	public function add_theme_supports() {
	
		// Add RSS feed links to <head> for posts and comments.
		add_theme_support( 'automatic-feed-links' );
		// Default custom header
		add_theme_support( 'custom-header' );
		// Default custom backgrounds
		add_theme_support( 'custom-background' );
		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support( 'html5', array(
			'search-form', 'comment-form', 'comment-list', 'gallery', 'caption'
		) );

		/*
		* Enable support for Post Formats.
		*/
		// Post Formats
		add_theme_support( 'post-formats', array( 'gallery', 'link', 'image', 'quote', 'video', 'audio', 'chat' ) );
		// Add post thumbnail functionality
		add_theme_support('post-thumbnails');
		set_post_thumbnail_size(1200, 650, true);
		//
		add_theme_support( 'title-tag' );
		// woocommerce support
		add_theme_support( 'woocommerce' );
	}
	
	/**
	 * Add image sizes
	 * 
	 */
	public function add_image_sizes() {
		$image_sizes = Buildplus_Config::get('image_sizes');
		foreach($image_sizes as $key => $sizes ) {
			$crop = true;
			if( isset( $sizes['crop'] ) ) {
				$crop = $sizes['crop'];
			}
			add_image_size( $key, $sizes['width'], $sizes['height'], $crop );
		}
	}
	/**
	 * action using generate inline css
	 * @param string $custom_css
	 */
	public function add_inline_style( $custom_css ) {
		wp_enqueue_style('buildplus-custom-inline', BUILDPLUS_PUBLIC_URI . '/css/buildplus-custom-inline.css');
		wp_add_inline_style( 'buildplus-custom-inline', $custom_css );
	}

	//************************* Front Page << ***********************
	/**
	 * Get page options, apply to theme options.(front page)
	 *
	 */
	public function get_page_options() {
		global $buildplus_options;
		global $buildplus_page_options;
	
		if( get_post_type() != 'product' && (is_search() || is_archive() || is_category() || is_tag() ) ){
			return;
		}
		list($post_id, $shop_page) = buildplus_get_post_id();
		if( ! $post_id ) {
			return;
		}
		$post_type = get_post_type($post_id);
		//
		$buildplus_page_options = get_post_meta( $post_id, 'buildplus_page_options', true );
		if( empty( $buildplus_page_options ) ) {
			return;
		}
		$image_id_keys = array('background_image_id', 'pt_background_image_id');
		$maps = Buildplus_Config::get( 'mapping', 'options' );
	
		$no_default = Buildplus_Config::get( 'mapping', 'no-default-options' );
		foreach($maps as $option_type => $page_options ) {
			$is_theme_default = $option_type .'_default';
			if( ( ! in_array($option_type, $no_default) ) &&
					(!isset( $buildplus_page_options[$is_theme_default] ) || isset( $buildplus_page_options[$is_theme_default] ) && ! empty( $buildplus_page_options[$is_theme_default] ) ) )
			{
				// no get page options
				continue;
			} else {
				foreach( $page_options as $key => $option) {
					$default = '';
					$bg_img = '';
					$bg_array = array(
						'background_transparent'       => 'background_color',
						'pt_background_transparent'    => 'pt_background_color'
					);
					foreach($bg_array as $bg_key=>$bg_val ) {
						if( isset($buildplus_page_options[$bg_key]) && !empty($buildplus_page_options[$bg_key])) {
							$buildplus_page_options[$bg_val] = $buildplus_page_options[$bg_key];
							unset($page_options[$bg_key]);
						}
					}
					if( isset( $buildplus_page_options[$key] ) ) {
						$option_val = $buildplus_page_options[$key];
						if( in_array( $key, $image_id_keys ) && ! empty( $option_val ) ) {
							$attachment_image = wp_get_attachment_image_src($option_val, 'full');
							$bg_img = $attachment_image[0];
							$default = $option_val;
						} else {
							$default = $option_val;
						}
					}
					if( $option ) {
						if( is_array( $option ) ) {
							if( count( $option ) == 3 ) {
								if( $default ) {
									$buildplus_options[$option[0]][$option[1]][$option[2]] = $default;
									if( !empty( $bg_img ) ) {
										$buildplus_options[$option[0]]['background-image'] = $bg_img;
									}
								}
							}
							else {
								$buildplus_options[$option[0]][$option[1]] = $default;
							}
						} else {
							$buildplus_options[$option] = $default;
						}
					}
				}
			}
		}
		
	}
	//************************* Front Page >> ***********************
	//************************* Admin Page << ***********************
	/**
	 * Get theme options to init page options. (admin page)
	 */
	public function init_page_setting() {
		global $buildplus_default_options;
		global $buildplus_options;

		$maps = Buildplus_Config::get( 'mapping', 'options' );
		$special_keys = array( 'pt_padding_top', 'pt_padding_bottom', 'header_padding_top', 'header_padding_bottom' );
		$transparent_keys = array( 'background_transparent', 'pt_background_transparent' );
		
		foreach( $maps as $option_type => $options ) {
			foreach( $options as $key => $option) {
				$default = '';
				if( $option ) {
					if( is_array( $option ) ) {
						if(count($option) == 3) {
							if( isset( $buildplus_options[$option[0]][$option[1]][$option[2]] ) ) {
								$default = $buildplus_options[$option[0]][$option[1]][$option[2]];
							}
						}
						else if( isset( $buildplus_options[$option[0]][$option[1]] ) ) {
							$default = $buildplus_options[$option[0]][$option[1]];
						}
					} else if( isset( $buildplus_options[$option] ) ) {
						$default = $buildplus_options[$option];
					}
					if( in_array( $key, $special_keys ) ) {
						$default = str_replace( 'px', '', $default );
					} else if( in_array( $key, $transparent_keys ) ) {
						if( $default =='transparent' ) {
							$default = 1;
						} else {
							$default = '';
						}
					}
					$buildplus_default_options[$key] = $default;
				}
			}
		}
	}
	/**
	 * Add meta box page setting to page or post type.
	 */
	public function add_page_options() {
		if( BUILDPLUS_CORE_IS_ACTIVE && function_exists('buildplus_core_add_page_options')) {
			$post_types = Buildplus_Config::get( 'page_options', 'post_types');
			foreach( $post_types as $post_type ) {
				buildplus_core_add_page_options( 'buildplus_mbox_page_setting', esc_html__('Page Setting', 'buildplus'), array( 'Buildplus', '[theme.Page_Controller, meta_box_setting]' ), $post_type, 'normal', 'low' );
			}
		}
	}
	/**
	 * Save page
	 */
	public function save_page( $post_id = '' ) {
		if( empty( $post_id ) ) {
			global $post;
			$post_id = $post->ID;
			parent::save();
		}
		// save page options start
		$maps = Buildplus_Config::get( 'mapping', 'options' );
		$no_default = Buildplus_Config::get( 'mapping', 'no-default-options' );
		foreach($maps as $k=>$v) {
			$is_default = $k .'_default';
			if( ( !isset($_POST['buildplus_page_options'][$is_default]) ) ){
				$_POST['buildplus_page_options'][$is_default] = '';
			}
		}
		update_post_meta( $post_id, 'buildplus_page_options', isset( $_POST['buildplus_page_options'] ) ? $_POST['buildplus_page_options'] : '' );
	}
	/**
	 * Save post
	 */
	public function save_post() {
		global $post;
		$post_id = $post->ID;
		parent::save();
		// save page options
		$this->save_page( $post_id );
		if( BUILDPLUS_CORE_IS_ACTIVE ) {
			do_action( 'buildplus_core_save_feature_video', $post_id );
		}
	}
	/**
	 * Save product
	 */
	public function save_product() {
		global $post;
		$post_id = $post->ID;
		parent::save();
		// save page options
		$this->save_page( $post_id );
	}
}