<?php
/**
 * Widget Gallery class.
*
* @since 1.0
*/
class Buildplus_Widget_Gallery extends WP_Widget {

	public function __construct() {
		$widget_ops = array( 'classname' => 'widget_slz_gallery', 'description' => esc_html__( "A list image of gallery or project post type.", 'buildplus') );
		parent::__construct( 'buildplus_gallery', esc_html_x( 'SLZ: Gallery', 'Gallery widget', 'buildplus' ), $widget_ops );
	}

	function form( $instance ) {
		$widget_default = array(
			'style'           => 'gallery-padding',
			'title'           => esc_html__( "Gallery", 'buildplus') ,
			'limit_post'      => '6',
			'cat_id'          => '',
			'posttype'        => '',
			'column'          => 'column-3',
			'show_meta'       => '',
		);
		$instance         = wp_parse_args( (array) $instance, $widget_default );
		$title            = $instance ['title'];
		$style            = $instance ['style'];
		$limit_post       = $instance ['limit_post'];
		$cat_id           = $instance ['cat_id'];
		$posttype         = $instance ['posttype'];
		$column           = isset( $instance['column'] ) ? $instance['column']:'';
		$show_meta        = $instance ['show_meta'];
		?>
		<!-- title -->
		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'title' )); ?>"><?php esc_html_e( 'Title', 'buildplus' ) ?>
			<input type="text" name="<?php echo esc_attr($this->get_field_name ( 'title' )); ?>" id="<?php echo esc_attr($this->get_field_id ( 'title' )); ?>" value="<?php echo esc_attr( $title ); ?>" class="widefat"/></label>
		</p>
		<!--style-->
		<p>
			<label for="<?php echo  esc_attr( $this->get_field_id('style') ); ?>"><?php esc_html_e('Choose Style', 'buildplus');?></label>
			<select class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'style' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name('style') ); ?>" >
				<option value="gallery-padding"<?php if( $style == 'gallery-padding' ) { echo " selected"; } ?>><?php esc_html_e('Padding', 'buildplus');?></option>
				<option value="gallery-no-padding"<?php if( $style == 'gallery-no-padding' ) { echo " selected"; } ?>><?php esc_html_e('No Padding', 'buildplus');?></option>
			</select>
		</p>
		<!-- limit post -->
		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'limit_post' )); ?>"><?php esc_html_e( 'Number Item', 'buildplus' ) ?>
			<input type="text" name="<?php echo esc_attr($this->get_field_name ( 'limit_post' )); ?>" id="<?php echo esc_attr($this->get_field_id ( 'limit_post' )); ?>" value="<?php echo esc_attr( $limit_post ); ?>" class="widefat"/></label>
		</p>
		<!-- category id -->
		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'cat_id' )); ?>"><?php esc_html_e( 'Category ID', 'buildplus' ) ?>
			<input type="text" name="<?php echo esc_attr($this->get_field_name ( 'cat_id' )); ?>" id="<?php echo esc_attr($this->get_field_id ( 'cat_id' )); ?>" value="<?php echo esc_attr( $cat_id ); ?>" class="widefat"/></label>
			<i><?php esc_html_e( 'Example : 1, 2, 3', 'buildplus'); ?></i>
		</p>
		<!-- column -->
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id('column') ); ?>"><?php esc_html_e( 'Choose Column', 'buildplus' );?></label>
			<select class="widefat" id="<?php echo esc_attr( $this->get_field_id('column') ); ?>" name="<?php echo esc_attr( $this->get_field_name('column') ); ?>" >
				<option value="column-1"<?php if( $column == 'column-1' ) echo " selected"; ?>><?php esc_html_e( 'One', 'buildplus' );?></option>
				<option value="column-2"<?php if( $column == 'column-2' ) echo " selected"; ?>><?php esc_html_e( 'Two', 'buildplus' );?></option>
				<option value="column-3"<?php if( $column == 'column-3' ) echo " selected"; ?>><?php esc_html_e( 'Three', 'buildplus' );?></option>
				<option value="column-4"<?php if( $column == 'column-4' ) echo " selected"; ?>><?php esc_html_e( 'Four', 'buildplus' );?></option>
			</select>
		</p>
		<!-- post type -->
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id('posttype') ); ?>"><?php esc_html_e( 'Choose Post Type', 'buildplus' );?></label>
			<select class="widefat" id="<?php echo esc_attr( $this->get_field_id('posttype') ); ?>" name="<?php echo esc_attr( $this->get_field_name('posttype') ); ?>" >
			<?php
				$arr_post_type = array(
					'gallery' => esc_html__( 'Gallery', 'buildplus' ),
					'project' => esc_html__( 'Project', 'buildplus' ),
				);
				foreach( $arr_post_type as $key=>$value ){
					$selected = '';
					if( $posttype == $key ){
						$selected = 'selected';
					}
					printf('<option value="%1$s" %2$s>%3$s</option>', $key, $selected, $value);
				}
			?>
			</select>
		</p>
		<!-- show meta -->
		<p>
			<input class="checkbox" type="checkbox" <?php echo checked($show_meta, 'on', false )?> id="<?php echo esc_attr( $this->get_field_id('show_meta') )?>" name="<?php echo esc_attr( $this->get_field_name('show_meta') )?>" />
			<label for="<?php echo esc_attr( $this->get_field_id('show_meta') )?>"><?php esc_html_e( 'Show Information?', 'buildplus' );?></label>
		</p>
		<?php
	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$params = array(
			'title',
			'limit_post',
			'cat_id',
			'posttype',
			'column',
			'show_meta',
			'style'
		);
		foreach( $params as $item ) {
			$instance[$item] = strip_tags( $new_instance[$item] );
		}
		return $instance;
	}
	function widget( $args, $instance ) {
		extract( $args );
		$default = array(
			'title'           => '',
			'limit_post'      => '',
			'cat_id'          => '',
			'posttype' 		  => '',
			'column' 		  => 'column-3',
			'show_meta' 	  => '',
		);
		$title    = apply_filters ( 'widget_title', $instance ['title'] );
		$instance = wp_parse_args( (array) $instance, $default );
		extract( $instance);
		$info = '';
		$id =  buildplus::make_id();
		$atts = $instance;

		$atts = array(
			'limit_post' => $instance['limit_post'],
			'posttype'   => $posttype
		);

		if( !empty( $cat_id ) ){
			$arr_cat_id = explode( ',', rtrim( $cat_id, ',' ) );
			$category_slug = array();
			foreach( $arr_cat_id as $value ){
				if( !empty( $value ) ){
					$term = Buildplus_Core_Com::get_tax_options_by_id( $value, 'buildplus_'.$posttype . '_cat' );
					if( $term ){
						$category_slug[] = $term->slug;
					}
				}
			}
		}

		$model = new buildplus_Core_Gallery();
		if( !empty( $category_slug ) ){
			$atts['category_slug'] = $category_slug;
		}
		
		$model->init($atts);
		$uniq_id = $atts['posttype'] . '-' .$id;

		echo wp_kses_post( $before_widget );
			if(!empty($show_meta)){
				$info =
				'<div class="link">%2$s</div>%3$s';
			}else{

			}
			$html_format = '
				<div class="item">
	                <div class="block-image-gallery">
	                    %1$s
	                    <div class="bg-hover"></div>
	                    <div class="content">
		              	'.wp_kses_post($info).'
			            </div>
			            <a href="%4$s" class="readmore-icons fancybox" data-fancybox-group-ori="'.$uniq_id.'-%5$s">
							<i class="icons flaticon-bleed"></i>
						</a>
	                </div>
	            </div>';
	         $html_options = array(
            		'html_format'  => $html_format,
            		'thumb_class'  => 'img-full',);
	         ?>
				
			<div class="sc_gallery_masonry wp-gallery widget widget-gallery <?php echo esc_attr($column).' '.esc_attr($uniq_id).' '.esc_attr($style);?>">
				<?php 
					if( !empty( $title ) ) {
						echo wp_kses_post( $before_title );
						echo esc_html( $title );
						echo wp_kses_post( $after_title );
					}
				?>
				 <div class="list-image-gallery gallery-content" data-item="<?php echo esc_attr($uniq_id);?>">
					<?php 
						echo $model->render_widget($html_options); 
					?>
				</div>
			</div><?php
		echo wp_kses_post( $after_widget );
	}
}
