<?php
/**
 * The default template for displaying content
 *
 * Used for both single and index/archive.
 *
 * @author Swlabs
 * @package BuildPlus
 * @since 1.0
 */
if ( has_post_thumbnail() && ! post_password_required() && ! is_attachment() ) {
	$style_class = '';
}else{
	$style_class = 'style-2 no-image';
}?>
<div class="item">
	<div class="block-1 <?php echo esc_attr($style_class);?>">
		<?php 
		if(Buildplus::get_option('slz-blog-showdate') == 'ribbon'){
			echo buildplus_ribbon_post_date();
		}
		if ( is_sticky() && is_home() && ! is_paged() ) {
			echo '<div class="sticky-block"><i class="icons fa fa-bookmark"></i></div>';
		}
		do_action( 'buildplus_entry_thumbnail');?>
		<div class="block-info">
		 	<?php do_action('buildplus_entry_meta');?>
		</div>
		<div class="block-content">
			<?php
				if ( is_single() ) :
					the_title( '<h1><a class="title">', '</a></h1>' );
				else :
					the_title( sprintf( '<h1><a href="%s" class="title">', esc_url( buildplus_get_link_url() ) ), '</a></h1>' );
				endif;
			?>
		    <div class="description">
		    	<?php
					the_content( sprintf( '<a href="%s" class="read-more">%s<i class="fa fa-angle-right"></i></a>',
							esc_url( get_permalink() ),
							esc_html__( 'Read more', 'buildplus' )
					) );
					wp_link_pages( array( 'before' => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'buildplus' ) . '</span>', 'after' => '</div>', 'link_before' => '<span>', 'link_after' => '</span>' ) );
				?>
	   		</div>
	   		<div class="clearfix"> </div>
	   		<!-- categories and tag session -->
			<div class="meta-archive"><?php
				do_action('buildplus_tags_meta');
				do_action('buildplus_categories_meta');
				?>
			</div>
			<!--end -->
	    </div>
	</div>
</div>