<?php
/**
 * The default template for displaying content
 *
 * Used for single.
 *
 * @author Swlabs
 * @package BuildPlus
 * @since 1.0
 */
?>
<div <?php post_class(); ?>>
	<div class="<?php echo esc_attr(buildplus_get_image_class());?>">
		<?php 
			if(Buildplus::get_option('slz-blog-showdate') == 'ribbon'){
				echo buildplus_ribbon_post_date();
			}
		?>
		<?php do_action( 'buildplus_entry_video'); ?>
		<div class="block-info">
			<?php do_action( 'buildplus_entry_meta');?>
			<?php
			if(BUILDPLUS_CORE_IS_ACTIVE){
				do_action('buildplus_core_social_share');
			}?>
		</div>
		<div class="blog-detail-content">
			<?php the_title( '<h1 class="title">', '</h1>' );?>
			<div class="description">
				<?php
					the_content( sprintf( '<a href="%s" class="read-more">%s<i class="fa fa-angle-right"></i></a>',
							esc_url( get_permalink() ),
							esc_html__( 'Read more', 'buildplus' )
					) );
					wp_link_pages( array( 'before' => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'buildplus' ) . '</span>', 'after' => '</div>', 'link_before' => '<span>', 'link_after' => '</span>' ) );
				?>		
			</div>
		</div>
	</div>
	<!-- tag-->
	<?php 
	if (Buildplus::get_option('slz-blog-tag') == '1'){
		do_action('buildplus_tags_meta');
	}
	if (Buildplus::get_option('slz-blog-cat') == '1'){
		do_action('buildplus_categories_meta');
	}
	// post navigation
	if(Buildplus::get_option('slz-blog-related-post') == '1'){
		do_action('buildplus_show_post_nav');
	}
	if (Buildplus::get_option('slz-blog-author') == '1'){
		do_action( 'buildplus_post_author' );
	}
	?>
</div>