<?php 
$prefix='buildplus_project_'; 

$data_attributes = $this->get_field( $data_meta, 'attribute' );
$section_count = 0;
$section_format = '
	<div class="slz-section section-%1$s">
		<a href="javascript:void(0);" class="slz-section-remove slz-row-remove">&#10005' . esc_html__( 'Delete Attribute', 'slz-core' ) .'</a>
		<br/>
		<div class="slz-custom-meta">
			<div class="slz-meta-row" >
				<div class="slz-desc">
					<span>'. esc_html__( 'Name', 'slz-core' ) .'</span>
				</div>
				<div class="slz-field">
					%2$s
				</div>
			</div>
			<div class="slz-meta-row" >
				<div class="slz-desc">
					<span>'. esc_html__( 'Value', 'slz-core' ) .'</span>
				</div>
				<div class="slz-field">
					%3$s
				</div>
			</div>
		</div>
	</div>
';
$section_output = '';
if( $data_attributes ) {
	foreach( $data_attributes as $key => $row ) {
		$section_count = $key+1;
		$field_name = $this->text_field( $prefix . 'meta['. $prefix .'attribute]['.$key.'][name]',
												$row['name'],
												array( 'class' => 'slz-block' ) );
		$field_value = $this->text_area( $prefix . 'meta['. $prefix .'attribute]['.$key.'][value]',
												$row['value'],
												array( 'class' => 'slz-block','rows' => '6' ) );
		$section_output .= sprintf( $section_format, $key, $field_name, $field_value );
	}
}
$html_options = array(
	'separator' => '&nbsp;&nbsp;',
	'class' => 'slz-w190'
);
$display_params = array( '1' => esc_html__( 'Show', 'slz-core' ), '' => esc_html__( 'None', 'slz-core' ) );
$display_feature_params = array( '1' => esc_html__( 'Featured ', 'slz-core' ), '' => esc_html__( 'None', 'slz-core' ) );
$display_stretch_params = array( '1' => esc_html__( 'Yes', 'slz-core' ), '' => esc_html__( 'No', 'slz-core' ) );
?>
<div class="tab-panel">
	<ul class="tab-list">
		<li class="active">
			<a href="slz-tab-project-general"><?php esc_html_e( 'General', 'slz-core' );?></a>
		</li>
		<li class="">
			<a href="slz-tab-project-gallery"><?php esc_html_e( 'Gallery', 'slz-core' );?></a>
		</li>
		<li class="">
			<a href="slz-tab-project-other"><?php esc_html_e( 'Others', 'slz-core' );?></a>
		</li>
	</ul>
	<div class="tab-container">
		<div class="tab-wrapper slz-page-meta">
			<!-- General -->
			<div id="slz-tab-project-general" class="tab-content active">
				<table class="form-table">
					<tr class="last">
						<th scope="row">
							<label><?php esc_html_e( 'Short Description', 'slz-core' );?></label>
							<p class="description"><?php esc_html_e( 'This is the content that will be shown on project blocks. Html tag allowed using.', 'slz-core' );?></p>
						</th>
					</tr>
					<tr>
						<td>
							<?php echo ( $this->text_area( $prefix .'meta['.$prefix.'description]',
														$this->get_field( $data_meta, 'description' ),
														array('class'=>'slz-block','rows' => '6') ) );?>
						</td>
					</tr>

					<tr class="last">
						<th scope="row">
							<label><?php esc_html_e( 'Project Description', 'slz-core' );?></label>
							<p class="description"><?php esc_html_e( 'This is the content that will be shown on project detail page. Html tag allowed using.', 'slz-core' );?></p>
						</th>
					</tr>
					<tr>
						<td>
							<?php echo ( $this->text_area( $prefix .'meta['.$prefix.'pro_description]',
														$this->get_field( $data_meta, 'pro_description' ),
														array('class'=>'slz-block','rows' => '6') ) );?>
						</td>
					</tr>

					<tr class="last">
						<th scope="row">
							<label><?php esc_html_e( 'Start Date', 'slz-core' );?></label>
						</th>
					</tr>
					<tr>
						<td>
							<?php echo ( $this->date_picker( $prefix .'meta['. $prefix .'day_begin]',
																$this->get_field( $data_meta, 'day_begin' ),
																array( 'class' => 'slz-block-half' ) ) );?>
						</td>
					</tr>

					<tr class="last">
						<th scope="row">
							<label><?php esc_html_e( 'End Date', 'slz-core' );?></label>
						</th>
					</tr>
					<tr>
						<td>
							<?php echo ( $this->date_picker( $prefix .'meta['. $prefix .'day_end]',
																$this->get_field( $data_meta, 'day_end' ),
																array( 'class' => 'slz-block-half' ) ) );?>							
						</td>
					</tr>
					
					<!-- Process -->
					<tr class="last">
						<th scope="row">
							<label><?php esc_html_e( 'Process', 'slz-core' );?></label>
						</th>
					</tr>
					<tr>
						<td>
							<div class="slz-dragdealer-wrapper" data-id="slz-process">
								<div id="slz-process" class="dragdealer" data-input=".slz-input-process">
									<div class="handle red-bar">
										<span class="value"></span>%
									</div>
									<?php echo ( $this->hidden_field( $prefix .'meta['. $prefix .'process]',
																		$this->get_field( $data_meta, 'process' ),
																		array( 'class' => 'slz-process-input' ) ) );?>
								</div>
							</div>
						</td>
					</tr>
				</table>
				<table class="form-table">
					<tr class="last">
						<th scope="row">
							<label><?php esc_html_e( 'Project Attributes', 'slz-core' );?></label>
						</th>
					</tr>
					<tr class="last">
						<td scope="row" colspan="2" >
							<div class="slz-section-container postbox-container">
									<?php
										printf( '<div class="inside content">%s</div>', $section_output );
									?>
							</div>
						</td>
					</tr>
					<tr class="last">
						<td align="right">
							<input type="button" class="button button-primary slz-add-section-project" data-item="<?php echo esc_attr($section_count)?>" data-metabox="<?php echo esc_attr( $prefix .'meta['. $prefix .'attribute]' )?>" data-name="<?php echo esc_attr( 'name' )?>" data-value="<?php echo esc_attr( 'value' )?>" data-container=".slz-section-container" value="<?php esc_html_e( 'Add Attribute', 'slz-core' );?>" />
						</td>
					</tr>
				</table>
			</div>
			
			<!-- Gallery -->
			<div id="slz-tab-project-gallery" class="tab-content">
				<table class="form-table">
					<tr class="last">
						<th scope="row" colspan="2">
							<label><?php esc_html_e( 'Show Gallery?', 'slz-core' );?></label>
							<p class="description"><?php esc_html_e( 'Show/ Hide gallery in project detail.', 'slz-core' );?></p>
						</th>
					</tr>
					<tr>
						<td colspan="2">
							<?php echo ( $this->radio_button_list( $prefix .'meta['. $prefix .'show_gallery]',
																		$this->get_field( $data_meta, 'show_gallery'),
																		$display_params,
																		$html_options ) );?>
						</td>
					</tr>

					<tr class="last">
						<th scope="row">
							<label><?php esc_html_e( 'Gallery Images', 'slz-core' );?></label>
							<p class="description"><?php esc_html_e( 'Images should have minimum size: 800x430. Bigger size images will be cropped automatically.', 'slz-core' );?></p>
						</th>
					</tr>
					<tr>
						<td>
							<?php $this->gallery( $prefix . 'meta['. $prefix .'gallery_images]', $data_meta['gallery_images'] ); ?>
						</td>
					</tr>
				</table>
			</div>
			<!-- Others -->
			<div id="slz-tab-project-other" class="tab-content">
				<table class="form-table">
					<tr class="last">
						<th scope="row" colspan="2">
							<label><?php esc_html_e( 'Mark The Project As Featured ?', 'slz-core' );?></label>
						</th>
					</tr>
					<tr>
						<td colspan="2">
							<?php echo ( $this->radio_button_list( $prefix . 'meta['. $prefix .'is_featured]',
																		$this->get_field( $data_meta, 'is_featured', 1 ),
																		$display_feature_params,
																		$html_options ) );?>
						</td>
					</tr>

					<tr class="last">
						<th scope="row" colspan="2">
							<label><?php esc_html_e( 'Attachments', 'slz-core' );?></label>
							<p class="description"><?php esc_html_e( 'Attach PDF files, Map images OR other documents related to the project.', 'slz-core' );?></p>
						</th>
						
					</tr>
					<tr class="last">
						<td colspan="2">
							<?php $this->upload_attachment( $prefix . 'meta['. $prefix .'attachment_ids]', $attachment_ids );?>
						</td>
					</tr>
				</table>
			</div>
		</div>
	</div>
</div>


<div class="slz-section-clone hide">
	<div class="slz-section">
		<a href="javascript:void(0);" class="slz-section-remove slz-row-remove"><?php echo '&#10005 ' . esc_html__( 'Delete Attribute', 'slz-core' );?></a>
		<br/>
		<div class="slz-custom-meta" >
			<div class="slz-meta-row" >
				<div class="slz-desc">
					<span><?php esc_html_e( 'Name', 'slz-core' );?></span>
				</div>
				<div class="slz-field">
					<?php echo ( $this->text_field( 'section_name',
													'',
													array( 'class' => 'slz-block' ) ) );?>
				</div>
			</div>
			<div class="slz-meta-row" >
				<div class="slz-desc">
					<span><?php esc_html_e( 'Value', 'slz-core' );?></span>
				</div>
				<div class="slz-field">
					<?php echo ( $this->text_area( 'section_value',
														'',
														array('class'=>'slz-block','rows' => '6') ) );?>
				</div>
			</div>
		</div>
	</div>
</div>