<?php
class Buildplus_Core_Service extends Buildplus_Core_Custom_Post_Model {

	private $post_type = 'buildplus_service';
	private $post_taxonomy = 'buildplus_service_cat';
	private $html_format;

	public function __construct() {
		$this->meta_attributes();
		$this->set_meta_attributes();
		$this->post_meta_prefix = $this->post_type . '_';
		$this->taxonomy_cat = $this->post_taxonomy;
		$this->html_format = $this->set_default_options();
	}
	public function meta_attributes() {
		$meta_atts = array( 
			'icon'            => esc_html__( 'Icon', 'slz-core' ),
			'description'     => esc_html__( 'Short Description', 'slz-core' ),
			'gallery_images'  => '',
			'attachment_ids'  => ''
		);
		$this->post_meta_atts = $meta_atts;
	}
	public function set_meta_attributes() {
		$meta_arr = array();
		$meta_label_arr = array();
		foreach( $this->post_meta_atts as $att => $name ){
			$key = $att;
			$meta_arr[$key] = '';
			$meta_label_arr[$key] = $name;
		}
		$this->post_meta_def = $meta_arr;
		$this->post_meta = $meta_arr;
		$this->post_meta_label = $meta_label_arr;
	}
	public function init( $atts = array(), $query_args = array() ) {
		// set attributes
		$default_atts = array(
			'layout'			=> 'service',
			'style'				=> 'icon_1',
			'column'			=> '3',
			'limit_post'		=> '-1',
			'offset_post'		=> '0',
			'sort_by'			=> '',
			'post_id'			=> '',
			'method'			=> '',
			'category'			=> '',
			'list_post'			=> '',
		);
		$atts = array_merge( $default_atts, $atts );

		if( empty( $atts['post_id'] ) ){
			if( $atts['method'] == 'cat' ) {
				$atts['post_id'] = $this->parse_cat_slug_to_post_id( 
											$this->taxonomy_cat,
											$atts['category'],
											$this->post_type
										);
			} else {
				$atts['post_id'] = $this->parse_list_to_array( 'service', $atts['list_post'] );
			}
		}

		$this->attributes = $atts;

		// query
		$default_args = array(
			'post_type' => $this->post_type,
		);
		$query_args = array_merge( $default_args, $query_args );
		// setting
		$this->setting( $query_args);
	}
	public function setting( $query_args ){
		if( !isset( $this->attributes['uniq_id'] ) ) {
			$this->attributes['uniq_id'] = $this->post_type . '-' .Buildplus_Core::make_id();
		}
		// query
		$this->query = $this->get_query( $query_args, $this->attributes );
		$this->post_count = 0;
		if( $this->query->have_posts() ) {
			$this->post_count = $this->query->post_count;
		}

		$this->get_thumb_size();
		$this->set_responsive_class();

		$custom_css = $this->add_custom_css();
		if( $custom_css ) {
			do_action( BUILDPLUS_CORE_ADD_INLINE_CSS, $custom_css );
		}
	}

	public function reset(){
		wp_reset_postdata();
	}

	public function set_responsive_class( $atts = array() ) {
		$class = '';
		$column = $this->attributes['column'];
		$def = array(
			'1' => 'service-col-1 col-md-12',
			'2' => 'service-col-2 col-lg-6 col-md-6 col-xs-12',
			'3' => 'service-col-3 col-lg-4 col-md-4 col-sm-6 col-xs-12',
			'4' => 'service-col-4 col-lg-3 col-md-4 col-sm-6 col-xs-12',
		);;
		
		if( $column && isset($def[$column])) {
			$this->attributes['responsive-class'] = $def[$column];
		} else {
			$this->attributes['responsive-class'] = $def['3'];
		}
	}

	public function add_custom_css() {
		$custom_css = '';
		if( !empty($this->attributes['color_title']) ) {
			$custom_css .= sprintf('.%1$s .block-content .title { color: %2$s;}',
								$this->attributes['uniq_id'], $this->attributes['color_title']
							);
		}
		if( !empty($this->attributes['color_title_hv']) ) {
			$custom_css .= sprintf('.%1$s .block-content .title:hover { color: %2$s;}',
								$this->attributes['uniq_id'], $this->attributes['color_title_hv']
							);
		}
		if( !empty($this->attributes['color_description']) ) {
			$custom_css .= sprintf('.%1$s .block-content .description { color: %2$s;}',
								$this->attributes['uniq_id'], $this->attributes['color_description']
							);
		}
		if( !empty($this->attributes['color_item_img_bg_hv']) ) {
			$custom_css .= sprintf('.%1$s .block-image:after { background-color: %2$s;}',
								$this->attributes['uniq_id'], $this->attributes['color_item_img_bg_hv']
							);
		}
		if( !empty($this->attributes['color_item_bg']) ) {
			$custom_css .= sprintf('.%1$s .list-block .item.item-layout-1 .block-content { background-color: %2$s;}',
								$this->attributes['uniq_id'], $this->attributes['color_item_bg']
							);
			$custom_css .= sprintf('.%1$s .list-block .item .block-service { background-color: %2$s;}',
								$this->attributes['uniq_id'], $this->attributes['color_item_bg']
							);
		}
		if( !empty($this->attributes['color_item_bg_hv']) ) {
			$custom_css .= sprintf('.%1$s .block-service .waveShape { fill: %2$s;}',
								$this->attributes['uniq_id'], $this->attributes['color_item_bg_hv']
							);
		}
		
		if( !empty($this->attributes['color_item_border']) ) {
			$custom_css .= sprintf('.%1$s .block-1 .block-content:before { background-color: %2$s;}',
								$this->attributes['uniq_id'], $this->attributes['color_item_border']
							);
		}
		if( !empty($this->attributes['color_button']) ) {
			$custom_css .= sprintf('.%1$s .block-content .readmore, .%1$s .block-content .readmore .icons { color: %2$s;}',
								$this->attributes['uniq_id'], $this->attributes['color_button']
							);
		}
		if( !empty($this->attributes['color_button_hv']) ) {
			$custom_css .= sprintf('.%1$s .block-content .readmore:hover, .%1$s .block-content .readmore:hover .icons { color: %2$s;}',
								$this->attributes['uniq_id'], $this->attributes['color_button_hv']
							);
		}

		/* carousel sc */
		if( !empty($this->attributes['color_nav_title']) ) {
			$custom_css .= sprintf('.%1$s .block-icon-3 .wrapper-info .title { color: %2$s;}',
								$this->attributes['uniq_id'], $this->attributes['color_nav_title']
							);
		}
		if( !empty($this->attributes['color_nav_title_hv']) ) {
			$custom_css .= sprintf('.%1$s .block-icon-3:hover .wrapper-info .title, .%1$s .block-icon-3.slick-current .wrapper-info .title { color: %2$s;}',
								$this->attributes['uniq_id'], $this->attributes['color_nav_title_hv']
							);
		}
		if( !empty($this->attributes['color_nav_bg']) ) {
			$custom_css .= sprintf('.%1$s .block-icon-3 { background-color: %2$s;}',
								$this->attributes['uniq_id'], $this->attributes['color_nav_bg']
							);
		}
		if( !empty($this->attributes['color_nav_bg_hv']) ) {
			$custom_css .= sprintf('.%1$s .block-icon-3:hover, .%1$s .block-icon-3.slick-current { background-color: %2$s;}',
								$this->attributes['uniq_id'], $this->attributes['color_nav_bg_hv']
							);
		}
		if( !empty($this->attributes['color_nav_border_hv']) ) {
			$custom_css .= sprintf('.%1$s .block-icon-3:after { background-color: %2$s;}',
								$this->attributes['uniq_id'], $this->attributes['color_nav_border_hv']
							);
		}
		if( !empty($this->attributes['color_nav_icon']) ) {
			$custom_css .= sprintf('.%1$s .block-icon-3 .wrapper-icons .icons { color: %2$s;}',
								$this->attributes['uniq_id'], $this->attributes['color_nav_icon']
							);
		}
		if( !empty($this->attributes['color_nav_icon_hv']) ) {
			$custom_css .= sprintf('.%1$s .block-icon-3:hover .wrapper-icons .icons, .%1$s .block-icon-3.slick-current .wrapper-icons .icons { color: %2$s;}',
								$this->attributes['uniq_id'], $this->attributes['color_nav_icon_hv']
							);
		}
		if( !empty($this->attributes['color_nav_icon_bg_hv']) ) {
			$custom_css .= sprintf('.%1$s .block-icon-3 .wrapper-icons:before, .%1$s .block-icon-3.slick-current .wrapper-icons:before { background-color: %2$s;}',
								$this->attributes['uniq_id'], $this->attributes['color_nav_icon_bg_hv']
							);
		}
		if( !empty($this->attributes['color_description']) ) {
			$custom_css .= sprintf('.%1$s .slider-vertical-wrapper .slider-for-wrapper .item-wrapper .content-wrapper .description { color: %2$s;}',
								$this->attributes['uniq_id'], $this->attributes['color_description']
							);
		}
		if( !empty($this->attributes['color_button']) ) {
			$custom_css .= sprintf('.%1$s .slider-vertical-wrapper .slider-for-wrapper .item-wrapper .content-wrapper .readmore { color: %2$s;}',
								$this->attributes['uniq_id'], $this->attributes['color_button']
							);
		}
		if( !empty($this->attributes['color_button_hv']) ) {
			$custom_css .= sprintf('.%1$s .slider-vertical-wrapper .slider-for-wrapper .item-wrapper .content-wrapper .readmore:hover { color: %2$s;}',
								$this->attributes['uniq_id'], $this->attributes['color_button_hv']
							);
		}
		if( !empty($this->attributes['color_slide_arrow']) ) {
			$custom_css .= sprintf('.%1$s .slick-arrow:before { color: %2$s !important;}',
								$this->attributes['uniq_id'], $this->attributes['color_slide_arrow']
							);
		}
		if( !empty($this->attributes['color_slide_arrow_hv']) ) {
			$custom_css .= sprintf('.%1$s .slick-arrow:hover:before { color: %2$s !important;}',
								$this->attributes['uniq_id'], $this->attributes['color_slide_arrow_hv']
							);
		}
		if( !empty($this->attributes['color_slide_arrow_bg']) ) {
			$custom_css .= sprintf('.%1$s .slick-arrow { background-color: %2$s !important;}',
								$this->attributes['uniq_id'], $this->attributes['color_slide_arrow_bg']
							);
		}
		if( !empty($this->attributes['color_slide_arrow_bg_hv']) ) {
			$custom_css .= sprintf('.%1$s .slick-arrow:hover { background-color: %2$s !important;}',
								$this->attributes['uniq_id'], $this->attributes['color_slide_arrow_bg_hv']
							);
		}
		if( !empty($this->attributes['color_slide_dots']) ) {
			$custom_css .= sprintf('.%1$s .slick-dots button:before { color: %2$s !important;}',
								$this->attributes['uniq_id'], $this->attributes['color_slide_dots']
							);
		}
		return $custom_css;		
	}
	//------------------- Post Infomations >> -------------------
	public function set_default_options( $html_options = array() ) {
		$defaults = array(
		);
		$html_options = array_merge( $defaults, $html_options );
		return $html_options;
	}
	private function get_thumb_size() {
		$params = Buildplus_Core_Params::get( 'block_image_size', $this->attributes['layout'] );
		if( !empty($this->attributes['column']) && $this->attributes['column'] == 1 ) {
			$this->attributes['thumb-size'] = array(
				'large'          => 'post-thumbnail',
				'no-image-large' => 'thumb-800x430.gif',
			);
		}
		else {
			$this->attributes['thumb-size'] = Buildplus_Core_Util::get_thumb_size( $params, $this->attributes );
		}
	}

	/*-------------------- >> Render Html << -------------------------*/
	/**
	 * Render html by shortcode.
	 *
	 * @param array $html_options
	 * Format: 1$ - image, 2$ - title, 3$ - description, 4$ - permalink, 5$ - post_id, 6$ - responsive class, 7$ - read more
	 */
	public function render_service_list_sc( $html_options = array() ) {
		$this->html_format = $this->set_default_options( $html_options );
		$row_count = 0;
		if( $this->query->have_posts() ) {
			while ( $this->query->have_posts() ) {
				$this->query->the_post();
				$this->loop_index();

				$html_options = $this->html_format;
				printf( $html_options['html_format'],
					$this->get_featured_image( $html_options, 'large' ),
					$this->get_title( $html_options ),
					$this->get_meta_sort_description(),
					$this->permalink,
					$this->post_id,
					$this->attributes['responsive-class'],
					$this->get_button_readmore(),
					$this->get_meta_icon()
				);
				$row_count++;
			}
			$this->reset();
			if( !empty($this->attributes['pagination']) && $this->attributes['pagination'] == 'yes' ) {
				echo BuildPlus_Core_Pagination::paging_nav( $this->query->max_num_pages, 2, $this->query);
			}
		}
	}

	/**
	 * Shortcode : service_carousel
	 * Format: 1$ - image, 2$ - description, 3$ - permalink, 4$ - read more, 5$ - post id
	 */
	public function render_service_carousel_sc( $html_options = array() ) {
		$this->html_format = $this->set_default_options( $html_options );
		if( $this->query->have_posts() ) {
			while ( $this->query->have_posts() ) {
				$this->query->the_post();
				$this->loop_index();
				$html_options = $this->html_format;
				printf( $html_options['html_format'],
					$this->get_featured_image( $html_options, 'large' ),
					$this->get_meta_sort_description(),
					$this->permalink,
					$this->get_button_readmore(),
					$this->post_id
				);
			}
			$this->reset();
		}
	}
	/**
	 * Shortcode : service_carousel
	 * Format: 1$ - title, 2$ - icon, 3$ - post id
	 */
	public function render_service_carousel_nav_sc( $html_options = array() ) {
		$this->html_format = $this->set_default_options( $html_options );
		if( $this->query->have_posts() ) {
			while ( $this->query->have_posts() ) {
				$this->query->the_post();
				$this->loop_index();
				$html_options = $this->html_format;
				printf( $html_options['nav_html_format'],
					$this->get_title( $html_options ),
					$this->get_meta_icon(),
					$this->post_id
				);
			}
			$this->reset();
		}
	}

	public function render_widget( $html_options = array() ) {
		$this->set_default_options( $html_options );
		while ( $this->query->have_posts() ) {
			$this->query->the_post();
			$this->loop_index();
			printf( $html_options['html_format'],
					$this->get_title(),
					$this->permalink
			);
		}
		$this->reset();
	}

	/*-------------------- >> General Functions << --------------------*/
	public function get_meta_icon() {
		$format = '<i class="icons %s"></i>';
		$icon = $this->post_meta['icon'];
		if( empty( $icon ) ) {
			return '';
		}
		if ( isset($this->html_format['icon_format']) ) {
			$format = $this->html_format['icon_format'];
		}
 		$out = sprintf($format, $icon );
 		return $out;
	}

	public function get_meta_sort_description() {
		$format = '%s';
		$description = '';
		$show_desc = $this->attributes['show_desc'];
		if ( !empty($show_desc) && $show_desc == 'yes' ) {
			$description = $this->post_meta['description'];
			if ( empty($description) ) {
				$description = $this->get_excerpt( $this->html_format );
			}
		}
		if ( empty($description) ) {
			return '';
		}
		$desc_lenght = (int) $this->attributes['desc_lenght'];
		if ( !empty($desc_lenght) ) {
			$description = wp_trim_words( $description, $desc_lenght, '...' );
		}
		if ( isset($this->html_format['excerpt_format']) ) {
			$format = $this->html_format['excerpt_format'];
		}
		$out = sprintf($format, wp_kses_post(nl2br($description)) );
		return $out;
	}

	public function get_button_readmore() {
		$out = '';
		$format = '<a href="%2$s" class="readmore"><span class="text">%1$s</span><i class="icons fa fa-angle-double-right"></i></a>';
		if ( isset($this->html_format['readmore_format']) ) {
			$format = $this->html_format['readmore_format'];
		}
		$button_text = esc_html__( 'Read more', 'slz-core' );
		if ( !empty($this->attributes['button_text']) ) {
			$button_text = $this->attributes['button_text'];
			$out = sprintf($format, $button_text, $this->permalink );
		}
		return $out;
	}
	
	public function get_attachment_ids() {
		$attachment_ids = array();
		if( $this->query->have_posts() ) {
			while ( $this->query->have_posts() ) {
				$this->query->the_post();
				$this->loop_index();
				$ids = $this->post_meta['attachment_ids'];
				if( !empty( $ids ) ){
					$attachment_ids = array_merge( $attachment_ids, explode( ',', trim( $ids, ',' ) ) );
				}
			}
			$this->reset();
		}
		return $attachment_ids;
	}

}