<?php
$model = new Buildplus_Core_Gallery();
$model->init( $atts );
$uniq_id = $model->attributes['uniq_id'];
$block_cls = $model->attributes['extra_class'] . ' ' . $uniq_id;
$attrSlickArr = array();
$classNoPaddingItem = '';
$slick_json = '';

if ( !empty($model->attributes['item_padding']) && $model->attributes['item_padding'] != 'yes' ) {
	$classNoPaddingItem = 'no_padding_item';
}

$slick_json = $model->get_atts_option_slick_slide();

// 1 - term name, 2 - title, 3 - feature_image, 4 - feature_image_url fancybox, 5 - post_id, 6 - images metabox fancybox
$html_format = '
	<div class="item">
		<div class="block-image-gallery">
			%3$s
			<div class="bg-hover"></div>
			<div class="content">
				<div class="link">%1$s</div>
				%2$s
			</div>
			<a href="%4$s" class="readmore-icons fancybox" data-fancybox-group-ori="'.$uniq_id.'-%5$s">
				<i class="icons flaticon-bleed"></i>
			</a>
		</div>
		%6$s
	</div>
';
$html_options = array(
	'html_format' => $html_format,
	'thumb_class' => 'img-full',
);

?>
<div id="<?php echo esc_attr($uniq_id)?>" class="slz-shortcode sc_gallery_slide <?php echo esc_attr( $block_cls ); ?>" data-item="<?php echo esc_attr($uniq_id); ?>">
	<div class="grid-content">
		<div class="slide-block gallery-slide-slick <?php echo esc_attr($classNoPaddingItem); ?>" data-slick-json="<?php echo esc_attr($slick_json); ?>">
			<?php $model->render_gallery_slide_sc($html_options);?>
		</div>
	</div>
</div>