<?php
$model = new BuildPlus_Core_Project();
$atts['layout'] = 'project-gallery';
$model->init( $atts );
$uniq_id = $model->attributes['uniq_id'];
$block_cls = $model->attributes['extra_class'] . ' ' . $uniq_id;

// 1$ - image gallery, 2$ - title, 3$ - description, 4$ - permalink, 5$ - button, 6$ - post_id
?>
<div class="slz-shortcode sc_project_carousel <?php echo esc_attr( $block_cls ); ?>" data-item="<?php echo esc_attr($uniq_id)?>">
	<div class="list-project">
		<?php
		$html_format = '
			<div class="item project_%6$s">
				<div class="project-wrapper">
					<div class="project-info">
						%2$s
						%3$s
						%5$s
					</div>
					<div class="project-images">
						<div class="slider-syncing-wrapper">
							<div class="slider-for">
								%1$s
							</div>
							<div class="slider-nav-wrapper">
								<div class="slider-nav">
									%1$s
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		';
		$html_render = array(
			'html_format' 		=> $html_format,
			'title_format' 		=> '<a href="%2$s"><h4 class="title-project margin-bottom-30">%1$s</h4></a>',
			'excerpt_format' 	=> '<div class="description">%1$s</div>',
			'thumb_class' 		=> 'img-responsive img-full',
		);
		$model->render_project_carousel_sc( $html_render ); ?>
	</div>
</div>