@extends('layouts.admin')

@section('content')
    <div class="max-w-7xl mx-auto py-10 sm:px-6 lg:px-8">
        <div class="row">
            <div class="col-sm-8 offset-sm-2">

                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                    <br />
                @endif
                <div class="card shadow col-md-12 p-3">
                    <form method="post" action="{{ route('users-update', $user->id) }}" enctype="multipart/form-data">
                        @method('PATCH')
                        @csrf
                        {{-- <div class=" form-group">
                            <div class="row">
                                <div class="col-md-6 form-group">
                                    <label for="image"> Profile Photo:</label>
                                    <input type="file" name="profile_photo_path" class="file" accept="image/*">
                                    <div class="input-group my-3">
                                        <input type="text" class="form-control" disabled placeholder="Upload File"
                                            id="file">
                                        <div class="input-group-append">
                                            <button type="button" class="browse btn btn-primary">Browse</button>
                                        </div>
                                    </div>
                                </div>
                                @if ($user->profile_photo_path != '')
                                    <div class="col-md-6 form-group">
                                        <img src="{{ asset('storage/uploads/profile/' . $user->profile_photo_path) }}"
                                            id="preview" class="img-thumbnail">
                                    </div>
                                @else
                                    <div class="col-md-6 form-group">
                                        <img src="https://placehold.it/80x80" id="preview" class="img-thumbnail">
                                    </div>
                                @endif
                            </div>
                        </div> --}}
                       
                        <div class="form-group">
                            <label for="name"> Name:</label>
                            <input type="text" class="form-control"  value="{{ $user->name }}" name="name" />
                        </div>
                        <div class="form-group">
                            <label for="name"> Business Name:</label>
                            <input type="text" class="form-control"  value="{{ $user->business_name }}" name="business_name" />
                        </div>
                        <div class="form-group">
                            <label for="email"> Email:</label>
                            <input type="email" class="form-control"  value="{{ $user->email }}" name="email" />
                        </div>
                        <div class="form-group">
                            <label for="passsword"> Password:</label>
                            <input type="password" class="form-control" name="password" />
                            <small>Leave empty if not changed.</small>
                        </div>
                        <div class="form-group">
                            <label for="passsword"> Valid Upto:</label>
                            <input type="date" class="form-control"  value="{{date('Y-m-d',strtotime($user->valid_upto))}}" name="valid_upto" />
                        </div>
                        
                        {{-- <p><a class="small updatePassword">Update Password</a></p> --}}
                        {{-- <div class="passwordSection d-none">
                            <div class="form-group">
                                <x-jet-label for="password" value="{{ __('Password') }}" />
                                <x-jet-input id="password" class="form-control" type="password" name="password"
                                    autocomplete="new-password" />
                            </div>

                            <div class="form-group">
                                <x-jet-label for="password_confirmation" value="{{ __('Confirm Password') }}" />
                                <x-jet-input id="password_confirmation" class="form-control" type="password"
                                    name="password_confirmation" autocomplete="new-password" />
                            </div>
                        </div> --}}

                        <button type="submit" class="btn btn-primary">Update</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
