<!DOCTYPE html>
<!-- Change the value of lang="en" attribute if your website's language is not English.
You can find the code of your language here - https://www.w3schools.com/tags/ref_language_codes.asp -->
<html lang="en">
    <head>
        <title>LionHeart International Services Group</title>
        <meta name="description" content="LionHeart International Services Group">  
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0" />
        
        <!-- Favicon -->
        <link rel="icon" href="images/favicon.png" type="image/png" sizes="any">
        <link rel="icon" href="images/favicon.svg" type="image/svg+xml">        

        <!-- CSS -->
        <link rel="stylesheet" href="css/bootstrap.min.css">
        <link rel="stylesheet" href="css/style.css">
        <link rel="stylesheet" href="css/style-responsive.css">
        <link rel="stylesheet" href="css/vertical-rhythm.min.css">
        <link rel="stylesheet" href="css/magnific-popup.css">
        <link rel="stylesheet" href="css/owl.carousel.css">
        <link rel="stylesheet" href="css/splitting.css">
        <link rel="stylesheet" href="css/YTPlayer.css">
        <link rel="stylesheet" href="css/demo-main/demo-main.css">
        
        <!-- Google Fonts -->
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link href="https://fonts.googleapis.com/css2?family=DM+Sans:wght@400;500;700&display=swap" rel="stylesheet"> 
        <link href="https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,100..900;1,100..900&display=swap" rel="stylesheet">
    </head>
    <body class="appear-animate dark-mode">
        <!-- Page Loader -->        
        <div class="page-loader dark">
            <div class="loader">Loading...</div>
        </div>
        <!-- End Page Loader -->

        <!-- Skip to Content -->
        <a href="#main" class="btn skip-to-content">Skip to Content</a>
        <!-- End Skip to Content -->
        
        <!-- Page Wrap -->
        <div class="page bg-dark-1" id="top">
            
            <!-- Navigation Panel -->
            <nav class="main-nav dark dark-mode transparent stick-fixed">
                <div class="main-nav-sub full-wrapper">
                    

                    <div class="nav-logo-wrap local-scroll">
                        <a href="index" class="logo">
                            <img src="images/logo-white.png" alt="Your Company Logo" width="105" height="34" />
                        </a>
                    </div>
                    

                    <div class="mobile-nav" role="button" tabindex="0">
                        <i class="mobile-nav-icon"></i>
                        <span class="visually-hidden">Menu</span>
                    </div>
                    

                    <div class="inner-nav desktop-nav">
                        <ul class="clearlist local-scroll">
                            <li>
                                <a href="index" class="<?= basename($_SERVER['PHP_SELF']) == 'index.php' ? 'active' : '' ?>">Home</a>                                
                            </li>
                            <li>
                                <a class="mn-has-sub <?= in_array(basename($_SERVER['PHP_SELF']), ['about.php', 'key-staff.php']) ? 'active' : '' ?>">About <i class="mi-chevron-down"></i></a>
                                <ul class="mn-sub mn-has-multi">
                                    <li>
                                        <a href="about" class="<?= basename($_SERVER['PHP_SELF']) == 'about.php' ? 'active' : '' ?>">About Us</a>
                                    </li>
                                    <li>
                                        <a href="key-staff" class="<?= basename($_SERVER['PHP_SELF']) == 'key-staff.php' ? 'active' : '' ?>">Key Staff</a>
                                    </li>
                                </ul>
                            </li>
                            <li>
                                <a href="services" class="mn-has-sub <?= in_array(basename($_SERVER['PHP_SELF']), ['services.php', 'corporate-security.php', 'safe-schools.php']) ? 'active' : '' ?>">Services <i class="mi-chevron-down"></i></a>
                                <ul class="mn-sub mn-has-multi">
                                    <li>
                                        <a href="corporate-security" class="<?= basename($_SERVER['PHP_SELF']) == 'corporate-security.php' ? 'active' : '' ?>">Corporate Security Services</a>
                                    </li>
                                    <li>
                                        <a href="https://www.securechurch.com/" target="_blank">Safe Churches</a>
                                    </li>
                                    <li>
                                        <a href="safe-schools" class="<?= basename($_SERVER['PHP_SELF']) == 'safe-schools.php' ? 'active' : '' ?>">Safe Schools</a>
                                    </li>
                                </ul>
                            </li>
                            <li>
                                <a href="latest-news" class="<?= basename($_SERVER['PHP_SELF']) == 'latest-news.php' ? 'active' : '' ?>">News</a>
                            </li>
                            <li>
                                <a href="podcast" class="<?= basename($_SERVER['PHP_SELF']) == 'podcast.php' ? 'active' : '' ?>">Podcast</a>
                            </li>
                            <li>
                                <a href="contact" class="<?= basename($_SERVER['PHP_SELF']) == 'contact.php' ? 'active' : '' ?>">Contact</a>
                            </li>                      
                        </ul>


                        <ul class="items-end clearlist">
                            
                            <!-- Languages -->
                            <li>
                                <a href="#" class="mn-has-sub opacity-1">(561)-316-3553 </a>
                            </li>
                            <!-- End Languages -->  
                                                      
                            <li><a href="contact" class="opacity-1 no-hover"><span class="link-hover-anim underline" data-link-animate="y">Send a message</span></a></li>
                            
                        </ul>                        
                        
                    </div>
                    <!-- End Main Menu -->
                    
                </div>
            </nav>
            <!-- End Navigation Panel -->