;(function($) {
	"use strict";
	$.fn.slzImpoter = function(){};
	var $this = $.fn.slzImpoter;

	/* Demo Importer */
	$.fn.slzImpoter.slzProgressStep = function( step_to_percent ) {
		if (step_to_percent >= 100) {
			jQuery('#title_loading').hide();
			jQuery('#progress_loading').hide();
			jQuery('#content_loading').hide();

			jQuery('#title_success').show();
			jQuery('#content_success').show();
			jQuery('.td-progress-show-details').show();
			jQuery('.td-return-dashboard').show();
		} else {
			jQuery('.td_progress_bar div').css('width', step_to_percent + '%');
		}
	}
	$.fn.slzImpoter.slzProgressError = function( ) {
		jQuery('#title_loading').hide();
		jQuery('#progress_bar').hide();
		jQuery('#title_error').show();
		jQuery('div.td-demo-msg').show();
	}
	$.fn.slzImpoter.slzProgress_show_details = function( ) {
		jQuery('.td-progress-show-details').click(function(){
			var textShow = jQuery(this).data('text-show');
			var textHide = jQuery(this).data('text-hide');
			if ( jQuery(this).hasClass('opened') == true ) {
				jQuery('div.td-demo-msg').hide();
				jQuery(this).removeClass('opened').text(textShow);
			} else {
				jQuery('div.td-demo-msg').show();
				jQuery(this).addClass('opened').text(textHide);
			}
		});
	}
	$.fn.slzImpoter.slzProgressImportAjax = function() {
		$('.btn-import-data').on('click', function() {
			if ($(this).hasClass('processing') == true) {
				return false;
			}
			var text_confirm = "Are you sure to install this content ?";
			if ( $(this).data('text-confirm') != '' ) {
				text_confirm = $(this).data('text-confirm');
			}
			var cf = confirm(text_confirm);
			if (cf == false) {
				return false;
			}

			var name = $(this).data('name');
			var text_importing = $(this).data('text-importing');
			var text_imported = $(this).data('text-imported');
			var text_importer = $(this).data('text-importer');		

			var box_loader = $(this).parent('.theme-actions').parent('.theme').find('.slz-box-loader');
			box_loader.removeClass('hide');
			$('.slz-fixed-bg').removeClass('hide');
			$('.btn-import-data').addClass('processing');
			if (typeof text_importing !== 'undefined') {
				$(this).text(text_importing);
			}

			var url = ['importer.DemoImporterPlugin', 'ajaxImporting'];
			var data = {"name":name };
			$.fn.Form.ajax(url, data, function(res) {
				$('.slz-content-importer').html(res);

				$('.slz-fixed-bg').addClass('hide');
				$.fn.slzImpoter.slzProgress_show_details();

	            $('html, body').animate({
	                scrollTop: $('.slz-tab-style .nav-tab-wrapper').offset().top
	            }, 1000);
			});

		});
	}
})(jQuery);

jQuery( document ).ready( function() {
	jQuery.fn.slzImpoter.slzProgressImportAjax();
	jQuery.fn.slzImpoter.slzProgress_show_details();
});