<?php
class Buildplus_Core_Pricing_Model {
	public $pricing_posts;
	public $cur_post_id;
	public $cur_post;
	public $pricing_table;
	public $max_feature_item;
	public $pricing_atts;
	public $html_options;
	public $post_type;

	/**
	 * Get pricing posts.
	 * 
	 * @param array $args - query args
	 */
	public function get_pricing_posts( $args ) {
		$defaults = array(
			'post_type'        => $this->post_type,
			'post_status'      =>'publish',
			'suppress_filters' => false,
			'posts_per_page'   => -1,
		);
		$args = array_merge( $defaults, $args );
		$this->pricing_posts = get_posts( $args );
	}

	/**
	 * Get meta of pricing column.
	 * 
	 * @param array $meta - current meta.
	 * @return array
	 */
	public function get_meta_column( $meta ) {
		$defaults = array(
			'icon'            => '',
			'title'           => '',
			'subtitle'        => '',
			'price'           => '',
			'subfix_price'    => '',
			'header_color'    => '',
			'active_column'   => '',
			'display_content' => '',
			'feature'         => array(),
			'column_link'     => '',
		);
		$meta = array_merge( $defaults, $meta );
		return $meta;
	}

	/**
	 * Get title of pricing column.
	 * 
	 * @param array $meta
	 * @param array $html_options
	 * @return string
	 */
	public function get_title( $meta ) {
		$before = Buildplus_Core::get_value( $this->html_options, 'title_before', '<h3 class="pricing-title">' );
		$after  = Buildplus_Core::get_value( $this->html_options, 'title_after', '</h3>' );
		$output = $before . esc_attr( Buildplus_Core::get_value( $meta, 'title' ) ) . $after;
		return $output;
	}

	/**
	 * Get subtitle of pricing column.
	 * 
	 * @param array $meta
	 * @param array $html_options
	 * @return string
	 */
	public function get_subtitle( $meta ) {
		$before = Buildplus_Core::get_value( $this->html_options, 'subtitle_before', '<p class="pricing-subtitle">' );
		$after  = Buildplus_Core::get_value( $this->html_options, 'subtitle_after', '</p>' );
		$subtitle = Buildplus_Core::get_value( $meta, 'subtitle' );
		if( $subtitle ){
			return $before . esc_attr( $subtitle ) . $after;
		}
		return null;
	}
	/**
	 * Get icon of pricing column.
	 *
	 * @param array $meta
	 * @param array $html_options
	 * @return string
	 */
	public function get_icon( $meta ) {
		$default = '<i class="pricing-icon %1$s"></i>';
		$format = Buildplus_Core::get_value( $this->html_options, 'icon_format', $default );
		$icon = Buildplus_Core::get_value( $meta, 'icon' );
		if( !empty($icon) ) {
			return sprintf( $format, $icon );
		}
		return null;
	}

	/**
	 * Get price of pricing column.
	 * 
	 * @param array $meta
	 * @param array $html_options
	 * @return string
	 */
	public function get_price( $meta ) {
		$default = '<div class="price-cost">
						<div class="inner">
							<p data-from="0" data-to="%1$s" data-speed="1000" class="inner-number">0</p>
						</div>
					</div>';
		$sign_format = '%1$s';
		$format = Buildplus_Core::get_value( $this->html_options, 'price_format', $default );
		$price = Buildplus_Core::get_value( $meta, 'price', 0 );
		if( absint($price) > 0 ) {
			$price = number_format_i18n(absint( $price ));
		}
		$subfix_price = Buildplus_Core::get_value( $meta, 'subfix_price', '' );
		$sign = $this->pricing_atts['currency_sign'];
		if( !empty($sign) && absint($price) > 0 ){
			$sign_format = Buildplus_Core::get_value( $this->html_options, 'sign_format', $sign_format );
			$sign = sprintf( $sign_format, $sign);
			$sign_pos = $this->pricing_atts['currency_sign_pos'];
			if( $sign_pos == 'after' ){
				$price = $price . $sign;
			} else {
				$price = $sign . $price;
			}
		}
		return sprintf( $format, $price, $subfix_price );
	}

	/**
	 * Get button of pricing column.
	 * 
	 * @param array $meta
	 * @param array $html_options
	 * @return string
	 */
	public function get_button( $meta ) {
		$class_form = 'pricing-form';
		$default = '<div class="pricing-button %3$s"><a href="%1$s" %4$s>%2$s</a></div>';
		$action = Buildplus_Core::get_value($this->pricing_atts, 'action_link');
		$href = $opts = '';
		if( $action == 'custom_link' ) {
			$class_form = '';
			$links = Buildplus_Core::get_value($this->pricing_atts, 'custom_link');
			if( $links ) {
				$link_val = Buildplus_Core_Util::get_link( $links );
				if( $link_val ){
					$href = esc_url($link_val['link']);
					$opts = esc_attr($link_val['url_title']) . ' ' .esc_attr($link_val['target']);
				}
			}
		} else if( $action == 'column_link') { 
			$class_form = '';
			$href = esc_url( Buildplus_Core::get_value( $meta, 'column_link' ) );
		}
		$format = Buildplus_Core::get_value( $this->html_options, 'button_format', $default );
		return sprintf( $format, $href, $this->pricing_atts['btn_content'], $class_form, $opts );
	}

	/**
	 * Get feature list of pricing column.
	 * 
	 * @param array $meta
	 * @param array $html_options
	 * @return string
	 */
	public function get_feature_list( $meta ) {
		$join_sep = '';
		if( isset( $this->html_options['feature_sep'] ) ) {
			$join_sep = $this->html_options['feature_sep'];
		}
		$format = Buildplus_Core::get_value( $this->html_options, 'feature_format', '<p><strong>%1$s</strong> %2$s</p>' );
		$feature = Buildplus_Core::get_value( $meta, 'feature' );

		$display_content = Buildplus_Core::get_value( $meta, 'display_content' );
		$defaults = array(
			'first_content' => '',
			'last_content' => '',
			'available' => '',
		);
		$links = array();
		$output = '';
		$count = 0;
		if( $feature ) {
			foreach( $feature as $item ) {
				$item = array_merge( $defaults, $item );
				extract($item);
				$first = $item['first_content'];
				$last = $item['last_content'];
				if( $display_content == 'last_first') {
					$first = $item['last_content'];
					$last = $item['first_content'];
				}
				$links[] = sprintf( $format, $first, $last );
				$count ++;
			}
			if( $count < $this->max_feature_item ) {
				for( $i = $count; $i < $this->max_feature_item; $i++ ) {
					$links[] = sprintf( $format, '&nbsp;', '&nbsp;' );
				}
			}
			if( $links ) {
				$output = join( $join_sep, $links );
			}
			if( isset( $this->html_options['container'] ) ) {
				$container = $this->html_options['container'];
			} else {
				$container = '<ul class="pricing-list">%1$s</ul>';
			}
			$output = sprintf( $container, $output );
		}
		return $output;
	}
	public function get_post_class( $class = '', $post_id = '' ) {
		$classes = array();
		if( empty( $post_id ) ) {
			$post_id = $this->cur_post_id;
		}
		if ( $class ) {
			if ( ! is_array( $class ) ) {
				$class = preg_split( '#\s+#', $class );
			}
			$classes = array_map( 'esc_attr', $class );
		}
		if( $post_id ) {
			$classes[] = 'post-' . $post_id;
			$classes[] = get_post_type( $post_id );
		}
		return join( ' ', $classes );
	}
}