<?php $prefix='buildplus_team_'; ?>
<div class="tab-panel">
	<ul class="tab-list">
		<li class="active">
			<a href="slz-tab-team-general"><?php esc_html_e( 'General', 'slz-core' );?></a>
		</li>
		<li class="">
			<a href="slz-tab-team-social"><?php esc_html_e( 'Social', 'slz-core' );?></a>
		</li>
	</ul>
	<div class="tab-container">
		<div class="tab-wrapper slz-page-meta">
			<!-- General -->
			<div id="slz-tab-team-general" class="tab-content active">
				<table class="form-table">
					<tr>
						<th scope="row">
							<label><?php esc_html_e( 'Thumbnail', 'slz-core' );?></label>
							<span class="f-right"><?php $this->tooltip_html( esc_html__( 'Upload Thumbnail Image. Images should have minimum size: 200x200', 'slz-core' ) );?></span>
						</th>
						<td>
							<?php echo ( $this->single_image( $prefix .'meta['. $prefix .'thumbnail]',
																$this->get_field( $data_meta, 'thumbnail' ),
																array( 'id'=> $prefix .'thumbnail_id',
																	'data-rel' => $prefix .'thumbnail' ) ) );?>
						</td>
					</tr>
					<tr>
						<th scope="row">
							<label><?php esc_html_e( 'Information', 'slz-core' );?></label>
							<span class="f-right"><?php $this->tooltip_html( esc_html__( 'Enter Team Information.', 'slz-core' ) );?></span>
						</th>
						<td>
							<?php echo ( $this->text_area( $prefix .'meta['.$prefix.'information]',
														$this->get_field( $data_meta, 'information' ),
														array('class'=>'slz-block','rows' => '6') ) );?>
						</td>
					</tr>
					<tr>
						<th scope="row">
							<label><?php esc_html_e( 'Position', 'slz-core' );?></label>
							<span class="f-right"><?php $this->tooltip_html( esc_html__( 'Enter Position of Him (or Her).', 'slz-core' ) );?></span>
						</th>
						<td>
							<?php echo ( $this->text_field( $prefix .'meta['.$prefix.'position]',
														$this->get_field( $data_meta, 'position' ),
														array('class'=>'slz-block') ) );?>
						</td>
					</tr>
					<tr>
						<th scope="row">
							<label><?php esc_html_e( 'Phone', 'slz-core' );?></label>
							<span class="f-right"><?php $this->tooltip_html( esc_html__( 'Enter Phone Number to Contact.', 'slz-core' ) );?></span>

						</th>
						<td>
							<?php echo ( $this->text_field( $prefix .'meta['.$prefix.'phone]',
														$this->get_field( $data_meta, 'phone' ),
														array('class'=>'slz-block') ) );?>
						</td>
					</tr>
					<tr>
						<th scope="row">
							<label><?php esc_html_e( 'Email', 'slz-core' );?></label>
							<span class="f-right"><?php $this->tooltip_html( esc_html__( 'Enter Email to Contact.', 'slz-core' ) );?></span>
						</th>
						<td>
							<?php echo ( $this->text_field( $prefix .'meta['.$prefix.'email]',
														$this->get_field( $data_meta, 'email' ),
														array('class'=>'slz-block') ) );?>
						</td>
					</tr>
					<tr>
						<th scope="row">
							<label><?php esc_html_e( 'Skype', 'slz-core' );?></label>
							<span class="f-right"><?php $this->tooltip_html( esc_html__( 'Enter Skype Name being used.', 'slz-core' ) );?></span>
						</th>
						<td>
							<?php echo ( $this->text_field( $prefix .'meta['.$prefix.'skype]',
														$this->get_field( $data_meta, 'skype' ),
														array('class'=>'slz-block') ) );?>
						</td>
					</tr>
					<tr>
						<th scope="row">
							<label><?php esc_html_e( 'Url', 'slz-core' );?></label>
							<span class="f-right"><?php $this->tooltip_html( esc_html__( 'Enter url being used.', 'slz-core' ) );?></span>
						</th>
						<td>
							<?php echo ( $this->text_field( $prefix .'meta['.$prefix.'url]',
														$this->get_field( $data_meta, 'url' ),
														array('class'=>'slz-block') ) );?>
						</td>
					</tr>
				</table>
			</div>

			<!-- Social-->
			<div id="slz-tab-team-social" class="tab-content">
				<table class="form-table">
					<?php $social_group = Buildplus_Core_Params::get( 'teammbox_social');
						foreach( $social_group as $social => $social_text ):
							$fieldname = $prefix .'meta['.$prefix.$social.']';
						?>
						<tr>
							<th scope="row">
								<label><?php echo esc_attr( $social_text );?></label>
							</th>
							<td>
								<?php echo ( $this->text_field( $fieldname,
																$this->get_field( $data_meta, $social ),
																array( 'class' => 'slz-block' ) ) );?>
							</td>
						</tr>
					<?php endforeach;?>
				</table>
			</div>
		</div>
	</div>
</div>