<?php
$icon_type      = Buildplus_Core_Params::get('icon_type');
$icon_flat      = Buildplus_Core_Params::get('font_flaticon');
$admin_icon_url = '<a href="'.esc_url(admin_url( 'admin.php?page='.BUILDPLUS_CORE_THEME_PREFIX.'_icon' )).'" target="_blank">'.esc_html__('Buildplus Icons','slz-core').'</a>';
$icon_link      = sprintf(esc_html__( 'Please go on %1$s to reference about icons of our theme.', 'slz-core' ), $admin_icon_url);
$params = array(
	array(
		'type'            => 'textfield',
		'holder'          => 'div',
		'heading'         => esc_html__( 'Number', 'slz-core' ),
		'param_name'      => 'number',
		'value'           => '',
		'description'     => esc_html__( 'Enter number.', 'slz-core' )
	),
	array(
		'type'            => 'textfield',
		'holder'          => 'div',
		'heading'         => esc_html__( 'Title', 'slz-core' ),
		'param_name'      => 'title',
		'value'           => '',
		'description'     => esc_html__( 'Enter title.', 'slz-core' )
	),
	array(
		'type'            => 'dropdown',
		'heading'         => esc_html__( 'Choose Type of Icon', 'slz-core' ),
		'param_name'      => 'icon_type',
		'value'           => $icon_type,
		'description'     => esc_html__( 'Choose kind of icon to display.', 'slz-core' )
	),
	array(
		'type'            => 'iconpicker',
		'heading'         => esc_html__( 'Choose Icon', 'slz-core' ),
		'param_name'      => 'icon_fw',
		'dependency'      => array(
			'element'     => 'icon_type',
			'value'       => array('02')),
		'description'     => esc_html__( 'Choose icon to display in box.', 'slz-core' )
	),
	array(
		'type'            => 'dropdown',
		'heading'         => esc_html__( 'Choose Icon', 'slz-core' ),
		'param_name'      => 'icon_flat',
		'value'           => $icon_flat,
		'dependency'      => array(
			'element'     => 'icon_type',
			'value'       => array('')),
		'description'     => $icon_link
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Number Color', 'slz-core' ),
		'param_name'      => 'number_color',
		'value'           => '',
		'description'     => esc_html__( 'Select color for number.', 'slz-core' ),
		'group'           => esc_html__('Custom', 'slz-core')
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Title Color', 'slz-core' ),
		'param_name'      => 'title_color',
		'value'           => '',
		'description'     => esc_html__( 'Select color for title.', 'slz-core' ),
		'group'           => esc_html__('Custom', 'slz-core')
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Icon Color', 'slz-core' ),
		'param_name'      => 'icon_color',
		'value'           => '',
		'description'     => esc_html__( 'Select color for icon.', 'slz-core' ),
		'group'           => esc_html__('Custom', 'slz-core')
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Line Color', 'slz-core' ),
		'param_name'      => 'line_color',
		'value'           => '',
		'description'     => esc_html__( 'Select color for line of block.', 'slz-core' ),
		'group'           => esc_html__('Custom', 'slz-core')
	),
	array(
		'type'            => 'textfield',
		'heading'         => esc_html__( 'Extra Class', 'slz-core' ),
		'param_name'      => 'extra_class',
		'value'           => '',
		'description'     => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'slz-core' )
	)
);

vc_map(
	array(
		"name"            => esc_html__( 'SLZ Number Factor', 'slz-core' ),
		"base"            => "slzcore_number_factor_sc",
		"class"           => "slzcore-sc",
		"category"        => BUILDPLUS_CORE_SC_CATEGORY,
		'icon'            => 'icon-slzcore_number_factor_sc',
		"description"     => esc_html__( 'Create number factor block.', 'slz-core' ),
		"params"          => $params
	)
);
