<?php
$style = array(
	esc_html__( 'Style Grid', 'slz-core' )	=> 'grid',
	esc_html__( 'Style Slide', 'slz-core' )	=> 'slide',
);
$yes_no  = array(
	esc_html__('Yes', 'slz-core')			=> 'yes',
	esc_html__('No', 'slz-core')			=> 'no',
);
$column = array(
	esc_html__( 'One', 'slz-core' )   		=> '1',
	esc_html__( 'Two', 'slz-core' )   		=> '2',
	esc_html__( 'Three', 'slz-core' ) 		=> '3',
	esc_html__( 'Four', 'slz-core' )  		=> '4',
);
$desc_type  = array(
	esc_html__('Short Description', 'slz-core')		=> 'desc_short',
	esc_html__('Project Description', 'slz-core')	=> 'desc_proj',
);
$method = array(
	esc_html__( 'Category', 'slz-core' )	=> 'cat',
	esc_html__( 'Project', 'slz-core' ) 	=> 'project'
);
$sort_by = array(
	esc_html__( '- Latest -', 'slz-core' )			=> '',
	esc_html__('Title A to Z', 'slz-core')			=> 'az_order',
	esc_html__('Title Z to A', 'slz-core')			=> 'za_order',
	esc_html__('Post is selected', 'slz-core')		=> 'post__in',
	esc_html__('Random', 'slz-core')				=> 'random_posts',
	esc_html__('Process Low to Hight', 'slz-core')	=> 'process_low_hight',
	esc_html__('Process Hight to Low', 'slz-core')	=> 'process_hight_low',
	esc_html__('Latest start date', 'slz-core')		=> 'start_latest',
	esc_html__('Oldest start date', 'slz-core')		=> 'start_oldest',
	esc_html__('Latest end date', 'slz-core')		=> 'end_latest',
	esc_html__('Oldest end date', 'slz-core')		=> 'end_oldest',
);

$args = array('post_type'     => 'buildplus_project');
$options = array('empty'      => esc_html__( '-All Project-', 'slz-core' ) );
$projects = BuildPlus_Core_Com::get_post_title2id( $args, $options );

$taxonomy = 'buildplus_project_cat';
$params_cat = array('empty'   => esc_html__( '-All Project Categories-', 'slz-core' ) );
$categories = BuildPlus_Core_Com::get_tax_options2slug( $taxonomy, $params_cat );

$taxonomy_location = 'buildplus_project_location';
$params_location = array('empty'   => esc_html__( '-All Project Locations-', 'slz-core' ) );
$project_location = BuildPlus_Core_Com::get_tax_options2slug( $taxonomy_location, $params_location );

$author   = Buildplus_Core_Com::get_user_login2id(array(), array('empty' => esc_html__( '-All authors-', 'slz-core' ) ) );

$params = array(
	array(
		'type'        	=> 'dropdown',
		'heading'     	=> esc_html__( 'Style', 'slz-core' ),
		'admin_label'	=> true,
		'param_name'  	=> 'style',
		'value'       	=> $style,
		'std'      		=> 'grid',
		'description' 	=> esc_html__( 'Choose style will be displayed.', 'slz-core' )
	),
	array(
		'type'        	=> 'dropdown',
		'heading'     	=> esc_html__( 'Column', 'slz-core' ),
		'admin_label'	=> true,
		'param_name'  	=> 'column',
		'value'       	=> $column,
		'std'      		=> '2',
		'description' 	=> esc_html__( 'Choose number column will be displayed.', 'slz-core' ),		
	),
	array(
		'type'        	=> 'dropdown',
		'heading'     	=> esc_html__( 'Show Description ?', 'slz-core' ),
		'param_name'  	=> 'show_desc',
		'value'       	=> $yes_no,
		'std'      		=> 'yes',
		'description' 	=> esc_html__( 'If choose Yes, block will be show description.', 'slz-core' ),
	),
	array(
		'type'        	=> 'dropdown',
		'heading'     	=> esc_html__( 'Description Type', 'slz-core' ),
		'param_name'  	=> 'desc_type',
		'value'       	=> $desc_type,
		'std'      		=> '',
		'description' 	=> esc_html__( 'Choose type description will be displayed.', 'slz-core' ),
		'dependency'     => array(
			'element'  => 'show_desc',
			'value'    => array( 'yes' ),
		),
	),
	array(
		'type'            => 'textfield',
		'heading'         => esc_html__( 'Description Length', 'slz-core' ),
		'param_name'      => 'desc_lenght',
		'description'     => esc_html__( 'Enter number for limiting the number of word displayed.', 'slz-core' ),
		'dependency'     => array(
			'element'  => 'show_desc',
			'value'    => array( 'yes' ),
		),
	),
	array(
		'type'        	=> 'dropdown',
		'heading'     	=> esc_html__( 'Show Thumbnail ?', 'slz-core' ),
		'param_name'  	=> 'show_thumbnail',
		'value'       	=> $yes_no,
		'std'      		=> 'yes',
		'description' 	=> esc_html__( 'If choose Yes, block will be show thumbnail image.', 'slz-core' ),
	),
	array(
		'type'        	=> 'dropdown',
		'heading'     	=> esc_html__( 'Show Process Bar ?', 'slz-core' ),
		'param_name'  	=> 'show_process',
		'value'       	=> $yes_no,
		'std'      		=> 'yes',
		'description' 	=> esc_html__( 'If choose Yes, block will be show process bar.', 'slz-core' ),
	),
	array(
		'type'        	=> 'dropdown',
		'heading'     	=> esc_html__( 'Show Pagination ?', 'slz-core' ),
		'param_name'  	=> 'pagination',
		'value'       	=> $yes_no,
		'std'      		=> 'no',
		'description' 	=> esc_html__( 'If choose Yes, block will be show pagination.', 'slz-core' ),
		'dependency'  => array(
			'element'   => 'style',
			'value'     => array( 'grid' )
		),		
	),
	array(
		'type'            => 'textfield',
		'heading'         => esc_html__( 'Limit Posts', 'slz-core' ),
		'param_name'      => 'limit_post',
		'value'           => '-1',
		'description'     => esc_html__( 'Add limit posts per page. Set -1 or empty to show all.', 'slz-core' )
	),
	array(
		'type'            => 'textfield',
		'heading'         => esc_html__( 'Max Posts', 'slz-core' ),
		'param_name'      => 'max_post',
		'value'           => '',
		'description'     => esc_html__( 'Add total posts when paging.', 'slz-core' ),
		'dependency'  => array(
			'element'   => 'pagination',
			'value'     => array( 'yes' )
		),
	),
	array(
		'type'            => 'textfield',
		'heading'         => esc_html__( 'Offset Posts', 'slz-core' ),
		'param_name'      => 'offset_post',
		'value'           => '0',
		'description'     => esc_html__( 'Enter offset to pass over posts. If you want to start on record 6, using offset 5', 'slz-core' )
	),
	array(
		'type'            => 'dropdown',
		'heading'         => esc_html__( 'Sort By', 'slz-core' ),
		'param_name'      => 'sort_by',
		'value'           => $sort_by,
		'description'     => esc_html__( 'Select order to display list properties.', 'slz-core' ),
	),
	array(
		'type'            => 'textfield',
		'heading'         => esc_html__( 'Extra Class', 'slz-core' ),
		'param_name'      => 'extra_class',
		'description'     => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'slz-core' )
	),

	array(
		'type'        	=> 'dropdown',
		'heading'     	=> esc_html__( 'Is Featured ?', 'slz-core' ),
		'param_name'  	=> 'is_featured',
		'value'       	=> $yes_no,
		'std'      		=> 'no',
		'description' 	=> esc_html__( 'If choose Yes, block will be show post is featured.', 'slz-core' ),
		'group'       	=> esc_html__('Filter', 'slz-core'),
	),
	array(
        'type'            => 'slz_date_picker',
        'heading'         => esc_html__( 'Start Date', 'slz-core' ),
        'param_name'      => 'date_start',
        'description'     => esc_html__( 'Choose start date of post.',  'slz-core'  ),
		'group'       	=> esc_html__('Filter', 'slz-core'),
    ),
	array(
        'type'            => 'slz_date_picker',
        'heading'         => esc_html__( 'End Date', 'slz-core' ),
        'param_name'      => 'date_end',
        'description'     => esc_html__( 'Choose end date of post.',  'slz-core'  ),
		'group'       	=> esc_html__('Filter', 'slz-core'),
    ),
	array(
		'type'        => 'dropdown',
		'heading'     => esc_html__( 'Display By', 'slz-core' ),
		'param_name'  => 'method',
		'value'       => $method,
		'description' => esc_html__( 'Choose project category or special projects to display', 'slz-core' ),
		'group'       	=> esc_html__('Filter', 'slz-core'),
	),
	array(
		'type'        => 'param_group',
		'heading'     => esc_html__( 'Category', 'slz-core' ),
		'param_name'  => 'category',
		'params'     => array(
			array(
				'type'        => 'dropdown',
				'admin_label' => true,
				'heading'     => esc_html__( 'Add Category', 'slz-core' ),
				'param_name'  => 'category_slug',
				'value'       => $categories,
				'description' => esc_html__( 'Choose special category to filter', 'slz-core'  )
			),
		),
		'value'       => '',
		'description' => esc_html__( 'Choose project category.', 'slz-core' ),
		'dependency'  => array(
			'element'   => 'method',
			'value'     => array( 'cat' )
		),
		'group'       	=> esc_html__('Filter', 'slz-core'),
	),
	array(
		'type'        => 'param_group',
		'heading'     => esc_html__( 'Location', 'slz-core' ),
		'param_name'  => 'location',
		'params'     => array(
			array(
				'type'        => 'dropdown',
				'admin_label' => true,
				'heading'     => esc_html__( 'Add Location', 'slz-core' ),
				'param_name'  => 'location_slug',
				'value'       => $project_location,
				'description' => esc_html__( 'Choose special location to filter', 'slz-core'  )
			),
		),
		'value'       => '',
		'description' => esc_html__( 'Choose project location.', 'slz-core' ),
		'dependency'  => array(
			'element'   => 'method',
			'value'     => array( 'cat' )
		),
		'group'       	=> esc_html__('Filter', 'slz-core'),
	),
	array(
		'type'       => 'param_group',
		'heading'    => esc_html__( 'Author', 'slz-core' ),
		'param_name' => 'author_list',
		'params'     => array(
			array(
				'type'        => 'dropdown',
				'admin_label' => true,
				'heading'     => esc_html__( 'Add Author', 'slz-core' ),
				'param_name'  => 'author',
				'value'       => $author,
				'description' => esc_html__( 'Choose special author to filter', 'slz-core'  )
			),
		),
		'value'       => '',
		'description' => esc_html__( 'Choose project by author.', 'slz-core' ),
		'dependency'  => array(
			'element'   => 'method',
			'value'     => array( 'cat' )
		),
		'group'       => esc_html__( 'Filter', 'slz-core' ),
	),
	array(
		'type'            => 'param_group',
		'heading'         => esc_html__( 'Projects', 'slz-core' ),
		'param_name'      => 'list_post',
		'params'          => array(
			array(
				'type'        => 'dropdown',
				'admin_label' => true,
				'heading'     => esc_html__( 'Add Project', 'slz-core' ),
				'param_name'  => 'project',
				'value'       => $projects,
				'description' => esc_html__( 'Choose special project to show',  'slz-core'  )
			),
			
		),
		'value'           => '',
		'dependency'  => array(
			'element'   => 'method',
			'value'     => array( 'project' )
		),
		'callbacks'       => array(
			'after_add'   => 'vcChartParamAfterAddCallback'
		),
		'description'     => esc_html__( 'Default display All Project if no project is selected and Number project is empty.', 'slz-core' ),
		'group'       	=> esc_html__('Filter', 'slz-core'),
	),

	array(
		'type'        	=> 'dropdown',
		'heading'     	=> esc_html__( 'Is Auto Play ?', 'slz-core' ),
		'param_name'  	=> 'slide_autoplay',
		'value'       	=> $yesno,
		'std'      		=> 'no',
		'description' 	=> esc_html__( 'Choose YES to slide auto play.', 'slz-core' ),
		'dependency'  => array(
			'element'   => 'style',
			'value'     => array( 'slide' )
		),
		'group'         => esc_html__('Slide Custom', 'slz-core'),
	),
	array(
		'type'        	=> 'dropdown',
		'heading'     	=> esc_html__( 'Is Dots Navigation ?', 'slz-core' ),
		'param_name'  	=> 'slide_dots',
		'value'       	=> $yesno,
		'std'      		=> 'yes',
		'description' 	=> esc_html__( 'Choose YES to show dot navigation.', 'slz-core' ),
		'dependency'  => array(
			'element'   => 'style',
			'value'     => array( 'slide' )
		),
		'group'         => esc_html__('Slide Custom', 'slz-core'),
	),
	array(
		'type'        	=> 'dropdown',
		'heading'     	=> esc_html__( 'Is Arrows Navigation ?', 'slz-core' ),
		'param_name'  	=> 'slide_arrows',
		'value'       	=> $yesno,
		'std'      		=> 'yes',
		'description' 	=> esc_html__( 'Choose YES to show arrow navigation.', 'slz-core' ),
		'dependency'  => array(
			'element'   => 'style',
			'value'     => array( 'slide' )
		),
		'group'         => esc_html__('Slide Custom', 'slz-core'),
	),
	array(
		'type'        	=> 'dropdown',
		'heading'     	=> esc_html__( 'Is Loop Infinite ?', 'slz-core' ),
		'param_name'  	=> 'slide_infinite',
		'value'       	=> $yesno,
		'std'      		=> 'yes',
		'description' 	=> esc_html__( 'Choose YES to slide loop infinite.', 'slz-core' ),
		'dependency'  => array(
			'element'   => 'style',
			'value'     => array( 'slide' )
		),
		'group'         => esc_html__('Slide Custom', 'slz-core'),
	),
	array(
		'type'           => 'textfield',
		'heading'        => esc_html__( 'Speed Slide', 'slz-core' ),
		'param_name'     => 'slide_speed',
		'value'			 => '600',
		'description'    => esc_html__( 'Enter number value. Unit is millisecond. Example: 600.', 'slz-core' ),
		'dependency'  => array(
			'element'   => 'style',
			'value'     => array( 'slide' )
		),
		'group'          => esc_html__('Slide Custom', 'slz-core'),
	),
	
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Title Color', 'slz-core' ),
		'param_name'      => 'color_title',
		'value'           => '',
		'description'     => esc_html__( 'Choose color title for block.', 'slz-core' ),
		'group'       	  => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Title Color Hover', 'slz-core' ),
		'param_name'      => 'color_title_hv',
		'value'           => '',
		'description'     => esc_html__( 'Choose color title for block when hover.', 'slz-core' ),
		'group'       	  => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Line Title Color', 'slz-core' ),
		'param_name'      => 'color_title_line',
		'value'           => '',
		'description'     => esc_html__( 'Choose color line title for block.', 'slz-core' ),
		'group'       	  => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Description Color', 'slz-core' ),
		'param_name'      => 'color_description',
		'value'           => '',
		'description'     => esc_html__( 'Choose color description for block.', 'slz-core' ),
		'group'       	  => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Process Text Color', 'slz-core' ),
		'param_name'      => 'color_process_text',
		'value'           => '',
		'description'     => esc_html__( 'Choose color process text for block.', 'slz-core' ),
		'group'       	  => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Background Process Color', 'slz-core' ),
		'param_name'      => 'color_process_bg',
		'value'           => '',
		'description'     => esc_html__( 'Choose background color process for block.', 'slz-core' ),
		'group'       	  => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Process Percent Color', 'slz-core' ),
		'param_name'      => 'color_process_at',
		'value'           => '',
		'description'     => esc_html__( 'Choose color process percent for block.', 'slz-core' ),
		'group'       	  => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Item Background Color Hover', 'slz-core' ),
		'param_name'      => 'color_item_bg',
		'value'           => '',
		'description'     => esc_html__( 'Choose background item for item when hover.', 'slz-core' ),
		'group'       	  => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Border Bottom Item Color', 'slz-core' ),
		'param_name'      => 'color_item_border',
		'value'           => '',
		'description'     => esc_html__( 'Choose border color bottom for item.', 'slz-core' ),
		'group'       	  => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Button Item Color', 'slz-core' ),
		'param_name'      => 'color_item_button',
		'value'           => '',
		'description'     => esc_html__( 'Choose color button for item.', 'slz-core' ),
		'group'       	  => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Button Item Background Color', 'slz-core' ),
		'param_name'      => 'color_item_button_bg',
		'value'           => '',
		'description'     => esc_html__( 'Choose background color button for item.', 'slz-core' ),
		'group'       	  => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Slide Arrow Color', 'slz-core' ),
		'param_name'      => 'color_slide_arrow',
		'value'           => '',
		'description'     => esc_html__( 'Choose color slide arrow for slide.', 'slz-core' ),
		'dependency'  => array(
			'element'   => 'slide_arrows',
			'value'     => array( 'yes' )
		),
		'group'       	  => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Slide Arrow Color Hover', 'slz-core' ),
		'param_name'      => 'color_slide_arrow_hv',
		'value'           => '',
		'description'     => esc_html__( 'Choose color slide arrow for slide when hover.', 'slz-core' ),
		'dependency'  => array(
			'element'   => 'slide_arrows',
			'value'     => array( 'yes' )
		),
		'group'       	  => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Slide Arrow Background Color', 'slz-core' ),
		'param_name'      => 'color_slide_arrow_bg',
		'value'           => '',
		'description'     => esc_html__( 'Choose background color slide arrow for slide.', 'slz-core' ),
		'dependency'  => array(
			'element'   => 'slide_arrows',
			'value'     => array( 'yes' )
		),
		'group'       	  => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Slide Arrow Background Color Hover', 'slz-core' ),
		'param_name'      => 'color_slide_arrow_bg_hv',
		'value'           => '',
		'description'     => esc_html__( 'Choose background color slide arrow for slide when hover.', 'slz-core' ),
		'dependency'  => array(
			'element'   => 'slide_arrows',
			'value'     => array( 'yes' )
		),
		'group'       	  => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Slide Dots Color', 'slz-core' ),
		'param_name'      => 'color_slide_dots',
		'value'           => '',
		'description'     => esc_html__( 'Choose color slide dots for slide.', 'slz-core' ),
		'dependency'  => array(
			'element'   => 'slide_dots',
			'value'     => array( 'yes' )
		),
		'group'       	  => esc_html__('Custom', 'slz-core'),
	),
);
vc_map(array(
	'name'        => esc_html__( 'SLZ Projects List', 'slz-core' ),
	'base'        => 'slzcore_project_list_sc',
	'class'       => 'slzcore-sc',
	'icon'        => 'icon-slzcore_project_sc',
	'category'    => BUILDPLUS_CORE_SC_CATEGORY,
	'description' => esc_html__( 'List of projects.', 'slz-core' ),
	'params'      => $params
	)
);