<?php
class Buildplus_Core_Block_Title {
	public $attributes;
	public $uniq;
	public $html_format;
	
	public function __construct() {
		$this->meta_attributes();
		$this->uniq = 'block-title-' . Buildplus_Core::make_id();
	}
	
	public function meta_attributes() {
		$default = array(
			'subtitle'           => '',
			'title'              => '',
			'title_02'           => '',
			'align'              => 'left',
			'show_line'          => 'yes',
			'subtitle_color'     => '',
			'title_color'        => '',
			'title_02_color'     => '',
			'line_color'         => '',
			'mrg_bottom'         => '',
			'extra_class'        => ''
		);
		$this->attributes = $default;
	}
	public function init( $atts, $content = null ) {
		$this->attributes = Buildplus_Core::set_shortcode_defaults( $this->attributes, $atts);
		if( function_exists( 'wpb_js_remove_wpautop' ) ) {
			$content = wpb_js_remove_wpautop( $content, true );
		}
		$this->attributes['content'] = $content;
	}
	/*-------------------- >> General Functions << --------------------*/
	
	public function setting_html( &$options = array() ){
		$default = array(
			'subtitle_format' => '<h5 class="subtitle">%1$s</h5>',
			'title_format'    => '<h2 class="title">%1$s %2$s</h2>',
			'title_02_format' => '<span class="last">%1$s</span>'
		);
		$this->html_format = array_merge( $default, $options);
	}
	public function get_subtitle() {
		$output = '';
		$format = $this->html_format['subtitle_format'];
		if( !empty( $this->attributes['subtitle'] ) && !empty( $format ) ) {
			$output = sprintf( $format, esc_attr( $this->attributes['subtitle'] ));
		}
		return $output;
	}
	public function get_title() {
		$output    = $title_02 = '';
		$format    = $this->html_format['title_format'];
		$format_02 = $this->html_format['title_02_format'];
		if( !empty( $this->attributes['title_02'] ) && !empty( $format_02 ) ) {
			$title_02 = sprintf( $format_02, esc_attr( $this->attributes['title_02'] ));
		}
		if( ( !empty( $this->attributes['title'] ) || !empty( $title_02 ) ) && !empty( $format ) ) {
			$output = sprintf( $format, esc_attr( $this->attributes['title'] ), $title_02 );
		}
		return $output;
	}
	/*-------------------- >> Css Functions << --------------------*/
	public function add_custom_css() {
		$custom_css = '';
		if( !empty( $this->attributes['subtitle_color'] ) ) {
			$custom_css .= '.%1$s .main-title .subtitle{color:%2$s;}' . "\n";
		}
		if( !empty( $this->attributes['title_color'] ) ){
			$custom_css .= '.%1$s .main-title .title{color:%3$s;}' . "\n";
		}
		if( !empty( $this->attributes['title_02_color'] ) ){
			$custom_css .= '.%1$s .main-title .title .last{color:%4$s;}' . "\n";
		}
		if( !empty( $this->attributes['line_color'] ) ) {
			$custom_css .= '.%1$s .main-title .title:before{background-color:%5$s;}' . "\n";
		}
		if( !empty( $this->attributes['align'] ) ) {
			$custom_css .= '.%1$s .main-title{text-align:%6$s;}' . "\n";
		}
		if( !empty( $this->attributes['show_line'] ) && $this->attributes['show_line'] == 'no' ) {
			$custom_css .= '.%1$s .main-title .title:before{display:none;}' . "\n";
		}
		if( !empty( $this->attributes['mrg_bottom'] ) ) {
			$custom_css .= '.%1$s .main-title{margin-bottom:%7$s;}' . "\n";
		}
		if ( !empty($custom_css) ) {
			$custom_css = sprintf($custom_css,
					esc_attr(trim($this->uniq)),
					esc_attr($this->attributes['subtitle_color']),
					esc_attr($this->attributes['title_color']),
					esc_attr($this->attributes['title_02_color']),
					esc_attr($this->attributes['line_color']),
					esc_attr($this->attributes['align']),
					esc_attr($this->attributes['mrg_bottom'])
			);
			do_action( BUILDPLUS_CORE_ADD_INLINE_CSS, $custom_css );
		}
	}
	/*-------------------- >> Render Html << -------------------------*/
	public function render_sc( $html_options = array() ) {
		$this->setting_html( $html_options );
		printf( $this->html_format['html_format'],
				$this->get_subtitle(),
				$this->get_title()
			);
		$this->add_custom_css();
	}
}