<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class Buildplus_Core_Shortcodes_Controller extends Buildplus_Core_Abstract {

	/**
	 * Init shortcodes.
	 */
	public function init() {
		// Add custom type
		if( function_exists("vc_add_shortcode_param") ) {
			// date time picker
			vc_add_shortcode_param( 'slz_datetime_picker' , array( &$this, 'buildplus_core_datetime_picker_field' ) , BUILDPLUS_CORE_ASSET_URI . '/js/buildplus-core-datetimepicker.js');
			vc_add_shortcode_param( 'slz_date_picker' , array( &$this, 'buildplus_core_date_picker_field' ) , BUILDPLUS_CORE_ASSET_URI . '/js/buildplus-core-datetimepicker.js');
		}
		
		$list_shortcodes = Buildplus_Core_Config::get( 'shortcode' );
		foreach( $list_shortcodes as $shortcode => $func ) {
			add_shortcode( $shortcode, array( &$this, $func ) );
		}
	}
	public function buildplus_core_datetime_picker_field( $settings, $value ) {
		$dependency = vc_generate_dependencies_attributes( $settings );
		$output = '<input name="' . $settings['param_name'] . '" ';
		$output .= 'class="wpb_vc_param_value wpb-textinput vc_slz_datetimepicker ' . $settings['param_name'] . ' ' . $settings['type'].'_field" ';
		$output .= 'type="text" value="' . $value . '" ' . $dependency . '/>';
		return $output;
	}
	public function buildplus_core_date_picker_field( $settings, $value ) {
		$dependency = vc_generate_dependencies_attributes( $settings );
		$output = '<input name="' . $settings['param_name'] . '" ';
		$output .= 'class="wpb_vc_param_value wpb-textinput vc_slz_datepicker ' . $settings['param_name'] . ' ' . $settings['type'].'_field" ';
		$output .= 'type="text" value="' . $value . '" ' . $dependency . '/>';
		return $output;
	}
	/**
	 * Map shortcodes to VC
	 */
	public function vc_map_shortcodes() {
		$list_shortcodes = Buildplus_Core_Config::get( 'shortcode' );
		foreach( $list_shortcodes as $shortcode => $func ) {
			$sc_file = BUILDPLUS_CORE_SHORTCODE_DIR . $func . '.php';
			if( file_exists( $sc_file ) ) {
				require_once( $sc_file );
			}
		}
	}
	//[slz_module cl="shortcode.Shortcodes" mt="shortcode_test" atr1="test" atr2="tesatres"]content[/slz_module]
	public function module( $atts, $content = null ) {
		if( ! empty( $atts['cl'] ) && ! empty( $atts['mt'] ) ) {
			if( Buildplus_Core::load_class( $atts['cl'] ) ) {
				return Buildplus_Core::new_object( $atts['cl'] )->{$atts['mt']}( $atts, $content );
			}
		}
	}
	// =======================Shortcode Functions==============================//
	/**
	 * Toggle Box
	 */
	public function toggle_box( $atts, $content = null ) {
		return $this->render( 'toggle_box', array('atts' => $atts, 'content' => $content), true );
	}
	/**
	 * Button
	 */
	public function button( $atts, $content = null ) {
		return $this->render( 'button', array('atts' => $atts, 'content' => $content), true );
	}
	/**
	 * Partner
	 */
	public function partner( $atts, $content = null ) {
		$default = array(
			'category'	  => '',
			'show_dot'    => '',
			'number_item' => '',
			'extra_class' => '',
			'dot_color'   => '',
			'dot_at_color'=>'',
		);
		$data       = Buildplus_Core::set_shortcode_defaults( $default, $atts);
		$data['id'] = Buildplus_Core::make_id();
		return $this->render( 'partner', array('atts' => $data), true );
	}
	/**
	 * Testimonial
	 */
	public function testimonial( $atts, $content = null ) {
		return $this->render( 'testimonial', array('atts' => $atts, 'content' => $content), true );
	}
	
	/**
	 * Gallery masonry
	 */
	public function gallery_masonry( $atts, $content = null ) {
		$default = array(
			'style'					=> '1',
			'column'				=> '3',
			'offset_post'			=> '',
			'limit_post'			=> '-1',
			'sort_by'				=> '',
			'category_list'			=> '',
			'category_list_project'	=> '',
			'posttype'				=> 'gallery',

			'item_padding'			=> 'yes',
			'show_filter'			=> 'yes',
			'show_filter_all'		=> 'yes',
			'filter_is_container'	=> 'no',
			'filter_title_all'		=> '',
			'filter_align'			=> '',
			'show_loadmore'			=> 'no',
			'button_title'			=> '',
			'content_is_container'	=> 'no',

			'color_filter_title'	=> '',
			'color_filter_title_at'	=> '',
			'color_filter_line'		=> '',
			'color_button_title'	=> '',
			'color_button_title_hv'	=> '',
			'color_button_bg'		=> '',
			'color_button_bg_hv'	=> '',
			'color_button_border'	=> '',
			'color_button_border_hv'=> '',
			'color_item_bg'			=> '',
			'color_item_border'		=> '',
			'color_item_button'		=> '',
			'color_item_button_bg'	=> '',
			'color_item_title'		=> '',
			'color_item_title_hv'	=> '',
			'color_item_title_line'	=> '',
			'color_item_cat'		=> '',
			'color_item_cat_hv'		=> '',
			'arrows_color'          => '',
			'arrows_bg_color'       => '',
			'featured_filter'       => '',
			'extra_class'			=> '',
		);
		$data = Buildplus_Core::set_shortcode_defaults( $default, $atts);
		$attr_catrgory_list = $data['posttype'] == 'project' ? 'category_list_project' : 'category_list';
		if( empty( $data['category_slug'] ) ) {
			list( $data['category_list_parse'], $data['category_slug'] ) = Buildplus_Core_Util::get_list_vc_param_group( $data, $attr_catrgory_list, 'category_slug' );
		}
		return $this->render( 'gallery_masonry', array( 'atts' => $data ), true );
	}

	/**
	 * Gallery slide
	 */
	public function gallery_slide( $atts, $content = null ) {
		$default = array(
			'column'				=> '3',
			'offset_post'			=> '',
			'limit_post'			=> '-1',
			'sort_by'				=> '',
			'category_list'			=> '',
			'category_list_project'	=> '',
			'posttype'				=> 'gallery',
			'item_padding'			=> 'yes',

			'slide_autoplay'		=> 'no',
			'slide_dots'			=> 'yes',
			'slide_arrows'			=> 'no',
			'slide_infinite'		=> 'yes',
			'slide_speed'			=> '600',

			'color_item_bg'			=> '',
			'color_item_border'		=> '',
			'color_item_button'		=> '',
			'color_item_button_bg'	=> '',
			'color_item_title'		=> '',
			'color_item_title_hv'		=> '',
			'color_item_title_line'	=> '',
			'color_item_cat'		=> '',
			'color_item_cat_hv'		=> '',
			'extra_class'			=> '',
			'category_slug'			=> ''
		);
		$data = Buildplus_Core::set_shortcode_defaults( $default, $atts);
		$attr_catrgory_list = $data['posttype'] == 'project' ? 'category_list_project' : 'category_list';
		if( empty( $data['category_slug'] ) ) {
			list( $data['category_list_parse'], $data['category_slug'] ) = Buildplus_Core_Util::get_list_vc_param_group( $data, $attr_catrgory_list, 'category_slug' );
		}
		elseif( is_string( $data['category_slug'] ) ){
			// related post
			$data['category_slug'] = explode( ',', $data['category_slug'] );
		}
		return $this->render( 'gallery_slide', array( 'atts' => $data ), true );
	}

	/**
	 * Project list
	 */
	public function project_list( $atts, $content = null ) {
		$default = array(
			'style'					=> 'grid',
			'column'				=> '2',
			'offset_post'			=> '',
			'limit_post'			=> '-1',
			'max_post'				=> '',
			'sort_by'				=> '',
			'extra_class'			=> '',
			'pagination'			=> '',
			'method' 				=> 'cat',
			'category' 				=> '',
			'location' 				=> '',
			'list_post' 			=> '',
			'author_list' 			=> '',
			'is_featured' 			=> '',
			'date_start' 			=> '',
			'date_end' 				=> '',

			'show_desc'				=> 'yes',
			'desc_type'				=> '', // Short Description or Project Description, show_desc = yes			
			'desc_lenght'			=> '', // limit content desc require, show_desc = yes
			'show_thumbnail'		=> 'yes',
			'show_process'			=> 'yes',

			'slide_autoplay'		=> 'no',
			'slide_dots'			=> 'yes',
			'slide_arrows'			=> 'yes',
			'slide_infinite'		=> 'yes',
			'slide_speed'			=> '600',

			'color_title'			=> '',
			'color_title_hv'		=> '',
			'color_title_line'		=> '',
			'color_description'		=> '',
			'color_process_text'	=> '',
			'color_process_bg'		=> '',
			'color_process_at'		=> '',
			'color_item_bg'			=> '',
			'color_item_border'		=> '',
			'color_item_button'		=> '',
			'color_item_button_bg'	=> '',
			'color_slide_arrow'		=> '',
			'color_slide_arrow_hv'	=> '',
			'color_slide_arrow_bg'	=> '',
			'color_slide_arrow_bg_hv'=> '',
			'color_slide_dots'		=> '',
		);
		$data = Buildplus_Core::set_shortcode_defaults( $default, $atts);
		if(isset($atts['list_post'])){
			$list_post = (array) vc_param_group_parse_atts( $atts['list_post'] );
			$data['list_post'] = $list_post;
		}
		if( empty( $data['category_slug'] ) ) {
			list( $data['category_list_parse'], $data['category_slug'] ) = Buildplus_Core_Util::get_list_vc_param_group( $data, 'category', 'category_slug' );
		}
		if( empty( $data['location_slug'] ) ) {
			list( $data['location_list_parse'], $data['location_slug'] ) = Buildplus_Core_Util::get_list_vc_param_group( $data, 'location', 'location_slug' );
		}
		if( empty( $data['author'] ) ) {
			list( $data['author_list_parse'], $data['author'] ) = Buildplus_Core_Util::get_list_vc_param_group( $data, 'author_list', 'author' );
		}
		return $this->render( 'project_list', array( 'atts' => $data ), true );
	}

	/**
	 * Project carousel
	 */
	public function project_carousel( $atts, $content = null ) {
		$default = array(
			'offset_post'			=> '',
			'limit_post'			=> '-1',
			'sort_by'				=> '',
			'extra_class'			=> '',
			'method' 				=> 'cat',
			'category' 				=> '',
			'list_post' 			=> '',

			'show_desc'				=> 'yes',
			'desc_type'				=> '',
			'desc_lenght'			=> '',
			'button_text'			=> '',

			'color_title'			=> '',
			'color_title_hv'			=> '',
			'color_description'		=> '',
			'color_button'			=> '',
			'color_button_hv'		=> '',
			'color_button_bg'		=> '',
			'color_button_bg_hv'	=> '',
			'color_button_border'	=> '',
			'color_button_border_hv'=> '',
		);
		$data = Buildplus_Core::set_shortcode_defaults( $default, $atts);
		if(isset($atts['list_post'])){
			$list_post = (array) vc_param_group_parse_atts( $atts['list_post'] );
			$data['list_post'] = $list_post;
		}
		if( empty( $data['category_slug'] ) ) {
			list( $data['category_list_parse'], $data['category_slug'] ) = Buildplus_Core_Util::get_list_vc_param_group( $data, 'category', 'category_slug' );
		}
		return $this->render( 'project_carousel', array( 'atts' => $data ), true );
	}
	
	/**
	 * Service list
	 */
	public function service_list( $atts, $content = null ) {
		$default = array(
			'style'					=> 'grid',
			'column'				=> '3',
			'offset_post'			=> '',
			'limit_post'			=> '-1',
			'max_post'				=> '',
			'sort_by'				=> '',
			'extra_class'			=> '',
			'pagination'			=> '',
			'method' 				=> 'cat',
			'category' 				=> '',
			'list_post' 			=> '',

			'show_desc'				=> 'yes',
			'desc_lenght'			=> '',
			'show_thumbnail'		=> 'yes',
			'button_text'			=> '',
			
			'slide_autoplay'		=> 'no',
			'slide_dots'			=> 'yes',
			'slide_arrows'			=> 'yes',
			'slide_infinite'		=> 'yes',
			'slide_speed'			=> '600',

			'color_title'			=> '',
			'color_title_hv'		=> '',
			'color_description'		=> '',
			'color_item_img_bg_hv'	=> '',
			'color_item_bg'			=> '',
			'color_item_bg_hv'	    => '',
			'color_item_border'		=> '',
			'color_button'			=> '',
			'color_button_hv'		=> '',
			'color_slide_arrow'		=> '',
			'color_slide_arrow_hv'	=> '',
			'color_slide_arrow_bg'	=> '',
			'color_slide_arrow_bg_hv'=> '',
			'color_slide_dots'		=> '',
		);
		$data = Buildplus_Core::set_shortcode_defaults( $default, $atts);
		if(isset($atts['list_post'])){
			$list_post = (array) vc_param_group_parse_atts( $atts['list_post'] );
			$data['list_post'] = $list_post;
		}
		if( empty( $data['category_slug'] ) ) {
			list( $data['category_list_parse'], $data['category_slug'] ) = Buildplus_Core_Util::get_list_vc_param_group( $data, 'category', 'category_slug' );
		}
		return $this->render( 'service_list', array( 'atts' => $data ), true );
	}
	
	/**
	 * Service carousel
	 */
	public function service_carousel( $atts, $content = null ) {
		$default = array(
			'offset_post'			=> '',
			'limit_post'			=> '-1',
			'sort_by'				=> '',
			'extra_class'			=> '',
			'method' 				=> 'cat',
			'category' 				=> '',
			'list_post' 			=> '',

			'show_desc'				=> 'yes',
			'desc_lenght'			=> '',
			'button_text'			=> '',

			'color_nav_title'		=> '',
			'color_nav_title_hv'	=> '',
			'color_nav_bg'			=> '',
			'color_nav_bg_hv'			=> '',
			'color_nav_border_hv'	=> '',
			'color_nav_icon'		=> '',
			'color_nav_icon_hv'		=> '',
			'color_nav_icon_bg_hv'	=> '',
			'color_description'		=> '',
			'color_button'			=> '',
			'color_button_hv'		=> '',
		);
		$data = Buildplus_Core::set_shortcode_defaults( $default, $atts);
		if(isset($atts['list_post'])){
			$list_post = (array) vc_param_group_parse_atts( $atts['list_post'] );
			$data['list_post'] = $list_post;
		}
		if( empty( $data['category_slug'] ) ) {
			list( $data['category_list_parse'], $data['category_slug'] ) = Buildplus_Core_Util::get_list_vc_param_group( $data, 'category', 'category_slug' );
		}
		return $this->render( 'service_carousel', array( 'atts' => $data ), true );
	}
	
	/**
	 * Team list
	 */
	public function team_list( $atts, $content = null ) {
		$default = array(
			'style'					=> 'grid',
			'column'				=> '4',
			'offset_post'			=> '',
			'limit_post'			=> '-1',
			'max_post'				=> '',
			'sort_by'				=> '',
			'extra_class'			=> '',
			'pagination'			=> '',
			'method' 				=> 'cat',
			'category' 				=> '',
			'list_post' 			=> '',
			'show_thumbnail'		=> 'yes',
			
			'slide_autoplay'		=> 'no',
			'slide_dots'			=> 'yes',
			'slide_arrows'			=> 'yes',
			'slide_infinite'		=> 'yes',
			'slide_speed'			=> '600',

			'color_title'			=> '',
			'color_title_hv'		=> '',
			'color_position'		=> '',
			'color_social_bg'		=> '',
			'color_social_icon'		=> '',
			'color_social_icon_hv'	=> '',
			'color_line'			=> '',
			'color_panel_bg'		=> '',
			'color_panel_bg_hv'		=> '',
			'color_slide_arrow'		=> '',
			'color_slide_arrow_hv'	=> '',
			'color_slide_arrow_bg'	=> '',
			'color_slide_arrow_bg_hv'=> '',
			'color_slide_dots'		=> '',
		);
		$data = Buildplus_Core::set_shortcode_defaults( $default, $atts);
		if(isset($atts['list_post'])){
			$list_post = (array) vc_param_group_parse_atts( $atts['list_post'] );
			$data['list_post'] = $list_post;
		}
		if( empty( $data['category_slug'] ) ) {
			list( $data['category_list_parse'], $data['category_slug'] ) = Buildplus_Core_Util::get_list_vc_param_group( $data, 'category', 'category_slug' );
		}
		return $this->render( 'team_list', array( 'atts' => $data ), true );
	}

	/**
	 * icon_box
	 */
	public function icon_box( $atts, $content = null ) {
		return $this->render( 'icon_box', array('atts' => $atts, 'content' => $content), true );
	}

	/**
	 * contact
	 */
	public function contact( $atts, $content = null ) {
		return $this->render( 'contact', array('atts' => $atts, 'content' => $content), true );
	}

	/**
	 * count down
	 */
	public function count_down( $atts, $content = null ) {
		$default = array(
			'date'					=> '',
			'extra_class' 			=> '',
			'text_color'            => '',
		);
		$data = Buildplus_Core::set_shortcode_defaults( $default, $atts);
		$data['id'] = Buildplus_Core::make_id();
		return $this->render( 'count_down', $data, true );
	}

	/*
	 * Number Factor
	 */
	public function number_factor( $atts, $content = null ) {
		 return $this->render( 'number_factor', array('atts' => $atts, 'content' => $content), true );
	}

	/**
	 * Block Title
	 */
	public function block_title( $atts, $content = null ) {
		return $this->render( 'block_title', array('atts' => $atts, 'content' => $content), true );
	}

	/**
	 * Video
	 */
	public function video( $atts, $content = null ) {
		$default = array(
			'image_bg'      => '',
			'extra_class'   => '',
			'image_video'  	=> '',
			'video_type'    => '',
			'id_youtube'	=> '',
			'id_vimeo'     	=> '',
			'height'         => '',
		);
		$data = Buildplus_Core::set_shortcode_defaults( $default, $atts);
		$data['id'] = Buildplus_Core::make_id();
		return $this->render( 'video', $data, true );
	}

	/**
	 * Banner
	 */
	public function banner( $atts, $content = null ) {
		return $this->render( 'banner', array('atts' => $atts, 'content' => $content), true );
	}

	/**
	 * Post Carousel
	 */
	public function post_carousel( $atts, $content = null ) {
		$default = array(
			'limit_post'           => '',
			'offset_post'          => '',
			'sort_by'              => '',
			'excerpt_length'       => '',
			'hover_color'          => '',
			'date_color'           => '',
			'extra_class'          => '',
			'category_list'        => '',
			'tag_list'             => '',
			'author_list'          => '',
			'format_list'          => '',
			'no_arrows'            => '',
			'show_date'            => '',
			'date_bg_color'        => '',
		);
		$data = Buildplus_Core::set_shortcode_defaults( $default, $atts);
		if( function_exists( 'wpb_js_remove_wpautop' ) ) {
			$data['content'] = wpb_js_remove_wpautop( $content, true );
		}
		else {
			$data['content'] = $content;
		}
		return $this->render( 'post_carousel', array( 'atts' => $data ), true );
	}
	/**
	 * Post List
	 */
	public function post_list( $atts, $content = null ) {
		$default = array(
			'style'                => '01',
			'column_02'            => '1',
			'column'               => '',
			'limit_post'           => '',
			'offset_post'          => '',
			'sort_by'              => '',
			'pagination'           => 'yes',
			'max_post'             => '',
			'show_content'         => '',
			'excerpt_length'       => '',
			'hover_color'          => '',
			'date_color'           => '',
			'extra_class'          => '',
			'show_sticky'          => '',
			'category_list'        => '',
			'tag_list'             => '',
			'author_list'          => '',
			'format_list'          => '',
			'show_date'            => '',
			'date_bg_color'        => '',
			'date_02_bg_color'     => '',
			'show_author'          => 'yes',
			'show_comments'        => 'yes',
			'show_views'           => 'yes',
		);
		$data = Buildplus_Core::set_shortcode_defaults( $default, $atts);
		if( function_exists( 'wpb_js_remove_wpautop' ) ) {
			$data['content'] = wpb_js_remove_wpautop( $content, true );
		}
		else {
			$data['content'] = $content;
		}
		if( $data['style'] == '03' || $data['style'] == '02' ){
			if( $data['style'] == '02' ){
				$data['show_date'] = 'ribbon';
				if( !empty( $data['date_02_bg_color'] ) ){
					$data['date_bg_color'] = $data['date_02_bg_color'];
				}
			}
			if( !empty( $data['column_02'] ) ){
				$data['column'] = $data['column_02'];
				unset( $data['column_02'] );
			}
		}
		return $this->render( 'post_list', array( 'atts' => $data ), true );
	}
	/**
	 * contact_map
	 */
	public function contact_map( $atts, $content = null ) {
		return $this->render( 'contact_map', array('atts' => $atts, 'content' => $content), true );
	}
	/**
	 * Download
	 */
	public function download( $atts, $content = null ) {
		return $this->render( 'download', array('atts' => $atts, 'content' => $content), true );
	}
	/**
	 * Item List
	 */
	public function item_list( $atts, $content = null ) {
		return $this->render( 'item_list', array('atts' => $atts, 'content' => $content), true );
	}
	/**
	 * Newsletter widget
	 */
	public function newsletter_widget( $atts, $content = null ) {
		$default = array(
			'input_name_placeholder'	=> esc_html( 'FullName', 'slz-core' ),
			'input_email_placeholder'	=> esc_html( 'Email Address', 'slz-core' ),
			'button_text'				=> esc_html( 'Get Notified', 'slz-core' ),
			'extra_class'				=> '',
			'title'                     => '',
			'description'               => '',
			'show_name'                 => 'yes',

			'color_input'				=> '',
			'color_input_border'		=> '',
			'color_input_border_fc'		=> '',
			'color_button'				=> '',
			'color_button_hv'			=> '',
			'color_button_bg'			=> '',
			'color_button_bg_hv'		=> '',
			'color_button_border'		=> '',
			'color_button_border_hv'	=> '',
		);
		$data = Buildplus_Core::set_shortcode_defaults( $default, $atts);
		$data['id'] = Buildplus_Core::make_id();
		return $this->render( 'newsletter_widget', $data, true );
	}
	public function image_slider( $atts, $content = null ) {
		$default = array(
			'images'		=> '',
			'item_number'   => '',
			'column'        => '1',
			'dot_color'     => '',
			'dot_at_color'  => '',
			'extra_class'   => '',

		);
		$data = Buildplus_Core::set_shortcode_defaults( $default, $atts);
		$data['id'] = Buildplus_Core::make_id();
		return $this->render( 'image_slider', $data, true );
	}
	public function pricing( $atts, $content = null ) {
		if( function_exists( 'wpb_js_remove_wpautop' ) ) {
			$atts['content'] = wpb_js_remove_wpautop( $content, true );
		}
		else {
			$atts['content'] = $content;
		}
		return $this->render( 'pricing', array( 'atts' => $atts ), true );
	}
	public function gallery_tab( $atts, $content = null ) {
		$default = array(
			'column'				=> '4',
			'offset_post'			=> '',
			'limit_post'			=> '4',
			'sort_by'				=> '',
			'category_list'			=> '',
			'category_list_project'	=> '',
			'posttype'				=> 'gallery',
	
			'item_padding'			=> 'no',
			'show_filter'			=> 'yes',
			'filter_is_container'	=> 'no',
			'filter_align'			=> '',
			'content_is_container'	=> 'no',
	
			'color_filter_title'	=> '',
			'color_filter_title_at'	=> '',
			'color_filter_line'		=> '',
			'color_item_border'		=> '',
			'color_item_button'		=> '',
			'color_item_button_bg'	=> '',
			'color_item_title'		=> '',
			'color_item_title_hv'	=> '',
			'color_item_title_line'	=> '',
			'color_item_cat'		=> '',
			'color_item_cat_hv'		=> '',
			'arrows_color'          => '',
			'arrows_bg_color'       => '',
			'featured_filter'       => '',
			'extra_class'			=> '',
			'featured_filter'       => '',
		);
		$data = Buildplus_Core::set_shortcode_defaults( $default, $atts);
		$attr_catrgory_list = $data['posttype'] == 'project' ? 'category_list_project' : 'category_list';
		if( empty( $data['category_slug'] ) ) {
			list( $data['category_list_parse'], $data['category_slug'] ) = Buildplus_Core_Util::get_list_vc_param_group( $data, $attr_catrgory_list, 'category_slug' );
		}
		return $this->render( 'gallery_tab', array( 'atts' => $data ), true );
	}
}