<?php
class Buildplus_Core_Team extends Buildplus_Core_Custom_Post_Model {

	private $post_type = 'buildplus_team';
	private $post_taxonomy = 'buildplus_team_cat';
	private $html_format;

	public function __construct() {
		$this->meta_attributes();
		$this->set_meta_attributes();
		$this->post_meta_prefix = $this->post_type . '_';
		$this->taxonomy_cat = $this->post_taxonomy;
		$this->html_format = $this->set_default_options();
	}
	public function meta_attributes() {
		$meta_atts = array(
			'thumbnail'        => esc_html__('Thumbnail Image', 'slz-core'),
			'information'      => esc_html__('Information', 'slz-core'),
			'position'         => esc_html__('Position', 'slz-core'),
			'phone'            => esc_html__('Phone', 'slz-core'),
			'email'            => esc_html__('Email', 'slz-core'),
			'skype'            => esc_html__('Skype', 'slz-core'),
			'url'              => esc_html__('Url', 'slz-core'),
			'signature'        => esc_html__('Transparent Signature', 'slz-core')
		);
		$this->post_meta_atts = array_merge($meta_atts, Buildplus_Core_Params::get( 'teammbox_social'));
	}
	public function set_meta_attributes() {
		$meta_arr = array();
		$meta_label_arr = array();
		foreach( $this->post_meta_atts as $att => $name ){
			$key = $att;
			$meta_arr[$key] = '';
			$meta_label_arr[$key] = $name;
		}
		$this->post_meta_def = $meta_arr;
		$this->post_meta = $meta_arr;
		$this->post_meta_label = $meta_label_arr;
	}
	public function init( $atts = array(), $query_args = array() ) {
		// set attributes
		$default_atts = array(
			'layout'			=> 'team',
			'style'				=> 'grid',
			'column'			=> '4',
			'limit_post'		=> '-1',
			'offset_post'		=> '0',
			'sort_by'			=> '',
			'post_id'			=> '',
			'method'			=> '',
			'category'			=> '',
			'list_post'			=> '',
		);
		$atts = array_merge( $default_atts, $atts );

		if( empty( $atts['post_id'] ) ){
			if( $atts['method'] == 'cat' ) {
				$atts['post_id'] = $this->parse_cat_slug_to_post_id( 
											$this->taxonomy_cat,
											$atts['category'],
											$this->post_type
										);
			} else {
				$atts['post_id'] = $this->parse_list_to_array( 'service', $atts['list_post'] );
			}
		}

		$this->attributes = $atts;

		// query
		$default_args = array(
			'post_type' => $this->post_type,
		);
		$query_args = array_merge( $default_args, $query_args );
		// setting
		$this->setting( $query_args);
	}
	public function setting( $query_args ){
		if( !isset( $this->attributes['uniq_id'] ) ) {
			$this->attributes['uniq_id'] = $this->post_type . '-' .Buildplus_Core::make_id();
		}
		// query
		$this->query = $this->get_query( $query_args, $this->attributes );
		$this->post_count = 0;
		if( $this->query->have_posts() ) {
			$this->post_count = $this->query->post_count;
		}
		$this->get_thumb_size();
		$this->set_responsive_class();

		$custom_css = $this->add_custom_css();
		if( $custom_css ) {
			do_action( BUILDPLUS_CORE_ADD_INLINE_CSS, $custom_css );
		}
	}
	public function reset(){
		wp_reset_postdata();
	}
	public function set_responsive_class( $atts = array() ) {
		$class = '';
		$column = $this->attributes['column'];
		$def = array(
			'1' => 'team-col-1 col-md-12',
			'2' => 'team-col-2 col-lg-6 col-md-6 col-xs-12',
			'3' => 'team-col-3 col-lg-4 col-md-4 col-sm-6 col-xs-12',
			'4' => 'team-col-4 col-lg-3 col-md-4 col-sm-6 col-xs-12',
		);;
		
		if( $column && isset($def[$column])) {
			$this->attributes['responsive-class'] = $def[$column];
		} else {
			$this->attributes['responsive-class'] = $def['4'];
		}
	}
	
	public function add_custom_css() {
		$custom_css = '';
		if( !empty($this->attributes['color_title']) ) {
			$custom_css .= sprintf('.%1$s .block-team .block-content .title { color: %2$s;}',
								$this->attributes['uniq_id'], $this->attributes['color_title']
							);
		}
		if( !empty($this->attributes['color_title_hv']) ) {
			$custom_css .= sprintf('.%1$s .block-team:hover .block-content .title { color: %2$s;}',
								$this->attributes['uniq_id'], $this->attributes['color_title_hv']
							);
		}
		if( !empty($this->attributes['color_position']) ) {
			$custom_css .= sprintf('.%1$s .block-team .block-content .position { color: %2$s;}',
								$this->attributes['uniq_id'], $this->attributes['color_position']
							);
		}
		if( !empty($this->attributes['color_social_bg']) ) {
			$custom_css .= sprintf('.%1$s .block-team .block-content .social-list .item { background-color: %2$s;}',
								$this->attributes['uniq_id'], $this->attributes['color_social_bg']
							);
		}
		if( !empty($this->attributes['color_social_icon']) ) {
			$custom_css .= sprintf('.%1$s .block-team .block-content .social-list .item .icons { color: %2$s;}',
								$this->attributes['uniq_id'], $this->attributes['color_social_icon']
							);
		}
		if( !empty($this->attributes['color_social_icon_hv']) ) {
			$custom_css .= sprintf('.%1$s .block-team .block-content .social-list .item:hover .icons { color: %2$s;}',
								$this->attributes['uniq_id'], $this->attributes['color_social_icon_hv']
							);
		}
		if( !empty($this->attributes['color_line']) ) {
			$custom_css .= sprintf('.%1$s .block-team .block-content { border-color: %2$s;}',
								$this->attributes['uniq_id'], $this->attributes['color_line']
							);
		}
		if( !empty($this->attributes['color_panel_bg']) ) {
			$custom_css .= sprintf('.%1$s .block-team .block-content { background-color: %2$s;}',
								$this->attributes['uniq_id'], $this->attributes['color_panel_bg']
							);
		}
		if( !empty($this->attributes['color_panel_bg_hv']) ) {
			$custom_css .= sprintf('.%1$s .block-team:hover .block-content { background-color: %2$s;}',
								$this->attributes['uniq_id'], $this->attributes['color_panel_bg_hv']
							);
		}
		if( !empty($this->attributes['color_slide_arrow']) ) {
			$custom_css .= sprintf('.%1$s .slick-arrow:before { color: %2$s !important;}',
								$this->attributes['uniq_id'], $this->attributes['color_slide_arrow']
							);
		}
		if( !empty($this->attributes['color_slide_arrow_hv']) ) {
			$custom_css .= sprintf('.%1$s .slick-arrow:hover:before { color: %2$s !important;}',
								$this->attributes['uniq_id'], $this->attributes['color_slide_arrow_hv']
							);
		}
		if( !empty($this->attributes['color_slide_arrow_bg']) ) {
			$custom_css .= sprintf('.%1$s .slick-arrow { background-color: %2$s !important;}',
								$this->attributes['uniq_id'], $this->attributes['color_slide_arrow_bg']
							);
		}
		if( !empty($this->attributes['color_slide_arrow_bg_hv']) ) {
			$custom_css .= sprintf('.%1$s .slick-arrow:hover { background-color: %2$s !important;}',
								$this->attributes['uniq_id'], $this->attributes['color_slide_arrow_bg_hv']
							);
		}
		if( !empty($this->attributes['color_slide_dots']) ) {
			$custom_css .= sprintf('.%1$s .slick-dots button:before { color: %2$s !important;}',
								$this->attributes['uniq_id'], $this->attributes['color_slide_dots']
							);
		}
		return $custom_css;		
	}
	public function set_default_options( $html_options = array() ) {
		$defaults = array(
			'title_format'			=> '<a href="%2$s" class="title">%1$s</a>',
			'position_format'		=> '<div class="position">%s</div>',
			'social_format'			=> '<a href="%2$s" class="item"><i class="icons fa fa-%1$s"></i></a>',
			'thumb_class' 			=> 'img-responsive img-full',
			'image_format'			=> '<div class="block-image"><a href="%2$s">%1$s</a></div>',
			'description_format'    => '<div class="detail-content">%1$s</div>',
			'email_format'          => '<a href="mailto:%2$s" class="item">
											<i class="icons fa fa-envelope"></i>
											<span class="text">%1$s</span>
										</a>',
			'phone_format'          => '<a href="tel:%2$s" class="item">
											<i class="icons fa fa-phone"></i>
											<span class="text text-bold">%1$s</span>
										</a>',
		);

		$html_options = array_merge( $defaults, $html_options );
		$this->html_format = $html_options;
		return $html_options;
	}
	private function get_thumb_size() {
		$params = Buildplus_Core_Params::get( 'block_image_size', $this->attributes['layout'] );
		$this->attributes['thumb-size'] = Buildplus_Core_Util::get_thumb_size( $params, $this->attributes );
	}

	/*-------------------- >> Render Html << -------------------------*/
	/**
	 * Render html by shortcode.
	 *
	 * @param array $html_options
	 * Format: 1$ - image, 2$ - title, 3$ - position, 4$ - social, 5$ - permalink, 6$ - post_id, 7$ - responsive
	 */
	public function render_team_list_sc( $html_options = array() ) {
		$this->html_format = $this->set_default_options( $html_options );
		$row_count = 0;
		if( $this->query->have_posts() ) {
			while ( $this->query->have_posts() ) {
				$this->query->the_post();
				$this->loop_index();

				$html_options = $this->html_format;
				printf( $html_options['html_format'],
					$this->get_featured_image( $html_options, 'small' ),
					$this->get_title( $html_options ),
					$this->get_meta_position(),
					$this->get_meta_social(),
					$this->permalink,
					$this->post_id,
					$this->attributes['responsive-class']
				);
				$row_count++;
			}
			$this->reset();
			if( !empty($this->attributes['pagination']) && $this->attributes['pagination'] == 'yes' ) {
				echo BuildPlus_Core_Pagination::paging_nav( $this->query->max_num_pages, 2, $this->query);
			}
		}
	}

	/*-------------------- >> General Functions << --------------------*/
	public function get_current_category() {
		$term = $this->get_current_taxonomy( $this->taxonomy_cat );
		$format = $this->html_format['category_format'];
		
		$out = '';
		if( $term ) {
			$out = sprintf( $format, esc_html( $term['name'] ) );
		}
		return $out;
	}
	public function get_meta_position() {
		$format = $this->html_format['position_format'];
		$position = $this->post_meta['position'];
		if( empty( $position ) ) {
			return '';
		}
		$out = sprintf( $format, esc_html($position) );
		return $out;
	}
	public function get_meta_phone() {
		$format = $this->html_format['phone_format'];
		$phone = $this->post_meta['phone'];
		$phoneRe = str_replace(' ', '', $phone);
		if( empty( $phone ) ) {
			return '';
		}
		$out = sprintf( $format, esc_html($phone), esc_html($phoneRe) );
		return $out;
	}
	public function get_meta_email() {
		$format = $this->html_format['email_format'];
		$out = $this->post_meta['email'];
		
		if( empty( $out ) ) {
			return '';
		}
		$mailto = str_replace(' ', '', $out);;
		$out = sprintf( $format, esc_html($out), esc_attr($mailto) );
		return $out;
	}
	public function get_meta_information() {
		$format = $this->html_format['description_format'];
		$out = $this->post_meta['information'];
		if( empty( $out ) ) {
			return '';
		}
		$out = sprintf( $format, wp_kses_post(nl2br($out)) );
		return $out;
	}

	public function get_meta_social() {
		$out ='';
		$format = $this->html_format['social_format'];
		$social_group = Buildplus_Core_Params::teammbox_social();
		foreach( $social_group as $social => $social_text ){
			$item = $this->post_meta[$social];
			if( !empty($item) ) {
				$href = $this->post_meta[$social];
				$out.= sprintf( $format, esc_attr( $social ), esc_url( $href ) );
			}
		}
		return $out;
	}

}