<?php
$model = new BuildPlus_Core_Team();
$model->init( $atts );
$uniq_id = $model->attributes['uniq_id'];
$block_cls = $model->attributes['extra_class'] . ' ' . $uniq_id;
$style = !empty($model->attributes['style']) ? $model->attributes['style'] : 'grid';
$column = !empty($model->attributes['column']) ? $model->attributes['column'] : '4';

$classRowBegin = $classRowEnd = '';
$classInlineBlock = 'inline_block';
$slick_json = $model->get_atts_option_slick_slide();

if ( $style == 'slide' ) {
	$classRowBegin = '<div class="team_slide_slick slide-block" data-slick-json="'.esc_attr($slick_json).'">';
	$classRowEnd = '</div>';
	$classInlineBlock = '';
}

// 1$ - image, 2$ - title, 3$ - position, 4$ - social, 5$ - permalink, 6$ - post_id, 7$ - responsive
$html_format = '
	<div class="item team_%6$s '.$classInlineBlock.'">
		<div class="block-team">
			%1$s
			<div class="block-content">
				%2$s
				%3$s
				<div class="social-list list-social">
					%4$s
				</div>
			</div>
		</div>
	</div>
';
$html_render = array(
	'html_format' 		=> $html_format,
);
?>
<div class="slz-shortcode sc_team_list <?php echo esc_attr( $block_cls ); ?>" data-item="<?php echo esc_attr($uniq_id); ?>">
	<div class="list-team">
		<div class="list-block-team list-block column-<?php echo esc_attr( $column ); ?>">
			<?php
			echo ($classRowBegin);
			$model->render_team_list_sc( $html_render ); 
			echo ($classRowEnd); ?>
		</div>
	</div>
</div>