<?php
/**
 * Controller Top.
 * 
 * @since 1.0
 */
Buildplus_Core::load_class( 'Abstract' );

class Buildplus_Core_Top_Controller extends Buildplus_Core_Abstract {

	/* Ajax get load_more of gallery */
	public function ajax_get_more_gallery(){
		$atts = $_POST['params'][0];
		echo ( $this->render( 'ajax-gallery_masonry', array( 'atts' => $atts, 'content' => null ), true ) );
		exit;
	}
	public function show_image_slider( $args = array() ){
		$this->render('image-slider', array( 'params' => $args ) );
	}
	// project single title
	public function show_project_title( $args = array() ){
		$this->render('project-title', array( 'args' => $args ) );
	}
	public function show_project_gallery( $args = array() ) {
		$this->render('project-gallery', array('args' => $args) );
	}
	public function show_project_related( $args = array() ) {
		$this->render('project-related', array('args' => $args) );
	}
	public function show_service_gallery( $args = array() ) {
		$this->render('service-gallery', array('args' => $args) );
	}
	public function show_project_list( $atts = array() ) {
		$defaults = array(
			'column'          => 1,
			'method'          => 'project',
			'show_desc'       => 'yes',
			'desc_lenght'     => 30,
			'desc_type'       => 'desc_proj',
			'pagination'      => 'ajax',
			'limit_post'      => get_option('posts_per_page')
		);
		$atts = array_merge( $defaults, $atts );
		if( isset($atts['has_sidebar']) && $atts['has_sidebar'] == 'none' ){
			$atts['column'] = 2;
		}
		$currentObject = get_queried_object();
		if ( is_tax('buildplus_project_cat') ) {
			$atts['method'] = '';
			$atts['category_slug'] = $currentObject->slug;
		}
		elseif( is_tax('buildplus_project_location') ) {
			$atts['method'] = '';
			$atts['location_slug'] = $currentObject->slug;
		}
		$this->render('project-list', array( 'atts' => $atts, 'base' => '' ) );
	}
	public function show_service_list( $atts = array() ) {
		$defaults = array(
			'column'          => 2,
			'show_desc'       => 'yes',
			'desc_lenght'     => 30,
			'show_thumbnail'  => 'yes',
			'button_text'  	  => esc_html__( 'Read more', 'slz-core' ),
			'pagination'      => 'ajax',
			'limit_post'      => get_option('posts_per_page')
		);
		$atts = array_merge( $defaults, $atts );
		if( isset($atts['has_sidebar']) && $atts['has_sidebar'] == 'none' ){
			$atts['column'] = 3;
		}
		$currentObject = get_queried_object();
		if ( is_tax('buildplus_service_cat') ) {
			$atts['category_slug'] = $currentObject->slug;
		}
		$this->render('service-list', array( 'atts' => $atts, 'base' => '' ) );
	}
	public function show_team_list( $atts = array() ) {
		$defaults = array(
			'column'          => 3,
			'show_thumbnail'  => 'yes',
			'pagination'      => 'ajax',
			'limit_post'      => get_option('posts_per_page')
		);
		
		$atts = array_merge( $defaults, $atts );
		if( isset($atts['has_sidebar']) && $atts['has_sidebar'] == 'none' ){
			$atts['column'] = 4;
		}
		$currentObject = get_queried_object();
		if ( is_tax('buildplus_team_cat') ) {
			$atts['category_slug'] = $currentObject->slug;
		}
		$this->render('team-list', array( 'atts' => $atts, 'base' => '' ) );
	}
	public function show_custom_entry_video( $args = array() ) {
		$show_video = false;
		if(class_exists('Buildplus_Core_Video_Model')){
			$post_id = get_the_ID();
			$post_options = get_post_meta( $post_id, 'buildplus_feature_video', true);
			$youtube_id = Buildplus::get_value( $post_options, 'youtube_id' );
			$vimeo_id = Buildplus::get_value( $post_options, 'vimeo_id' );
			$upload_video = Buildplus::get_value( $post_options, 'upload_video' );
			if(empty($youtube_id) && empty($vimeo_id) && empty($upload_video) ){
				$show_video = false;
			}
			else{
				$show_video = true;
				$video_model = new Buildplus_Core_Video_Model();
				$video_model->init();
				echo ( $video_model->get_video( $post_options['video_type'] , $youtube_id, $vimeo_id , $upload_video ) );
			}
		}
		$this->render( 'custom-thumbnail', array ( 'args' => $args ) );
	}
	// share post
	public function get_share_link( $args = array()) {
		$this->render( 'share_link', array( 'args' => $args ));
	}
	/* Ajax team pagination */
	public function ajax_team_pagination(){
		$atts  = $_POST['params']['atts'];
		$page  = $_POST['params']['page'];
		$base  = $_POST['params']['base'];
		$atts['paged'] = $page;
		$this->render( 'team-list', array( 'atts' => $atts, 'base' => $base ) );
		exit;
	}
	// Project Pagination
	public function ajax_project_pagination(){
		$atts  = $_POST['params']['atts'];
		$page  = $_POST['params']['page'];
		$base  = $_POST['params']['base'];
		$atts['paged'] = $page;
		$this->render( 'project-list', array( 'atts' => $atts, 'base' => $base ) );
		exit;
	}
	// Service Pagination
	public function ajax_service_pagination(){
		$atts  = $_POST['params']['atts'];
		$page  = $_POST['params']['page'];
		$base  = $_POST['params']['base'];
		$atts['paged'] = $page;
		$this->render( 'service-list', array( 'atts' => $atts, 'base' => $base ) );
		exit;
	}
	public function show_team_about( $atts = array() ) {
		$this->render('team-about', array( 'atts' => $atts ) );
	}

}