<?php
$model = new BuildPlus_Core_Service();
$model->init( $atts );
$block_cls = $model->attributes['uniq_id'];

// 1$ - image, 2$ - title, 3$ - description, 4$ - permalink, 5$ - post_id, 6$ - responsive class, 7$ - read more
$html_format = '
	<div class="item service_%5$s inline_block">
		<div class="block-1">
			%1$s
			<div class="block-content">
				<a href="%4$s" class="title">%2$s</a>
				%3$s
				%7$s
			</div>
		</div>
	</div>
';
$html_render = array(
	'html_format' 		=> $html_format,
	'excerpt_format' 	=> '<div class="description">%s</div>',
	'thumb_class' 		=> 'img-full',
	'image_format'		=> '<div class="block-image">%1$s<a href="%2$s" class="link"></a></div>'
);
if ( $model->query->have_posts() ):
?>
<div class="<?php echo esc_attr( $block_cls ); ?>">
	<div class="list-block column-<?php echo esc_attr($model->attributes['column']); ?>">
		<?php $model->render_service_list_sc( $html_render );?>
	</div>
	<div class="clearfix"></div>
	<?php
		if( !empty($model->attributes['pagination']) && $model->attributes['pagination'] == 'ajax' ) {
			echo '<div class="hide slz-pagination-json" data-json="'.esc_attr(json_encode($model->attributes)).'"></div>';
			echo BuildPlus_Core_Pagination::paging_ajax( $model->query->max_num_pages, 2, $model->query, $base );
		}
	?>
</div>
<?php
else:
	get_template_part( 'inc/content', 'none' );
endif;
?>