<?php
/**
 * Setting_Init class.
 * 
 * @since 1.0
 */

class Buildplus_Core_Setting_Init {
	/**
	 * Regist scripts - admin
	 * 
	 */
	public function enqueue(){
		$uri = BUILDPLUS_CORE_ASSET_URI;
		$protocol = is_ssl() ? 'https' : 'http';
		// css
		wp_enqueue_style( 'buildplus-core-admin',        $uri . '/css/buildplus-core-admin.css', false, BUILDPLUS_CORE_VERSION, 'all' );
		wp_enqueue_style( 'buildplus-core-importer',     $uri . '/css/buildplus-core-importer.css', false, BUILDPLUS_CORE_VERSION, 'all' );
		// js
		wp_enqueue_media();

		//-----------------enqueue script to run ajax-------------------------- 
		wp_enqueue_script( 'buildplus-core-form', $uri . '/js/buildplus-core-form.js', array('jquery'), BUILDPLUS_CORE_VERSION, true );
		wp_localize_script(
				'buildplus-core-form',
				'ajaxurl',
				esc_url(admin_url( 'admin-ajax.php' ))
		);

		wp_enqueue_script( 'jquery.datetimepicker.min', $uri . '/libs/datetimepicker/jquery.datetimepicker.min.js', array(), BUILDPLUS_CORE_VERSION, true );

		wp_enqueue_script( 'buildplus-core-common',       $uri . '/js/buildplus-core-common.js', array('jquery'), BUILDPLUS_CORE_VERSION, false );
		wp_enqueue_script( 'buildplus-core-admin',        $uri . '/js/buildplus-core-admin.js', array('jquery'), BUILDPLUS_CORE_VERSION, false );
		wp_enqueue_script( 'buildplus-core-importer',     $uri . '/js/buildplus-core-importer.js', array('jquery'), BUILDPLUS_CORE_VERSION, false );

		wp_enqueue_script( 'buildplus-core-metabox',      $uri . '/js/buildplus-core-metabox.js', array('jquery'), BUILDPLUS_CORE_VERSION, false );		
		wp_enqueue_script( 'buildplus-core-datepicker',   $uri . '/js/buildplus-core-datetimepicker.js', array('jquery'), BUILDPLUS_CORE_VERSION, false );
		wp_enqueue_script( 'buildplus-core-image',        $uri . '/js/buildplus-core-image.js', array('jquery'), BUILDPLUS_CORE_VERSION, false );
		
		wp_localize_script( 'buildplus-core-image', 'slz_meta_image',
				array(
					'title' => esc_html__( 'Choose or Upload an Image', 'slz-core' ),
					'button' => esc_html__( 'Use this image', 'slz-core' ),
				)
		);
		wp_enqueue_style( 'wp-color-picker' );
		wp_enqueue_script( 'buildplus-core-metacolor', $uri . '/js/buildplus-core-metacolor.js', array( 'wp-color-picker' ) );
		
		wp_enqueue_script( 'jquery.tooltipster.min',   $uri . '/libs/tooltipster/jquery.tooltipster.min.js', array(), BUILDPLUS_CORE_VERSION, true );
		// css for shortcode 
		wp_enqueue_style( 'jquery.datetimepicker',     $uri . '/libs/datetimepicker/jquery.datetimepicker.css', array(), BUILDPLUS_CORE_VERSION );

		// select2
		wp_enqueue_style( 'select2.min', $uri . '/libs/select2/css/select2.min.css', array(), BUILDPLUS_CORE_VERSION );
		wp_enqueue_script( 'select2.full.min', $uri . '/libs/select2/js/select2.full.min.js', array( 'jquery' ), BUILDPLUS_CORE_VERSION );

		// dragdealer
		wp_enqueue_style( 'dragdealer', $uri . '/libs/dragdealer/css/dragdealer.css', array(), BUILDPLUS_CORE_VERSION );
		wp_enqueue_script( 'dragdealer', $uri . '/libs/dragdealer/js/dragdealer.js', array( 'jquery' ), BUILDPLUS_CORE_VERSION );
		// process
		wp_enqueue_script( 'buildplus-core-process',      $uri . '/js/buildplus-core-process.js', array('jquery'), BUILDPLUS_CORE_VERSION, false );
		
	}

	/**
	 * Scripts & Css - frondend
	 */
	public function dev_enqueue_scripts(){
		$uri = BUILDPLUS_CORE_ASSET_URI;
		$protocol = is_ssl() ? 'https' : 'http';
		// css
		wp_enqueue_style( 'slick',                    $uri . '/libs/slick-slider/slick.css');
		wp_enqueue_style( 'slick-theme',              $uri . '/libs/slick-slider/slick-theme.css');
		
// 		wp_enqueue_style( 'jquery-jvectormap',        $uri . '/libs/jquery-jvectormap/jquery-jvectormap.css');
		wp_enqueue_style( 'jquery.fancybox',          $uri . '/libs/fancybox/css/jquery.fancybox.css');
		wp_enqueue_style( 'jquery.fancybox-buttons',  $uri . '/libs/fancybox/css/jquery.fancybox-buttons.css');
		wp_enqueue_style( 'jquery.fancybox-thumbs',   $uri . '/libs/fancybox/css/jquery.fancybox-thumbs.css');
		// js
		wp_enqueue_script( 'moment.min',                   $uri . '/libs/moment/js/moment.min.js', array(), false, true );
		wp_enqueue_script( 'wow.min',                      $uri . '/libs/wow-js/wow.min.js', array(), false, true );
		//slick
		wp_enqueue_script( 'slick.min',                    $uri . '/libs/slick-slider/slick.min.js', array(), false, true );
		wp_enqueue_script( 'isotope.pkgd.min',             $uri . '/libs/isotope/isotope.pkgd.min.js', array(), false, true );
		
		wp_enqueue_script( 'jquery.countTo',               $uri . '/libs/count-to/jquery.countTo.js', array(), false, true );
		wp_enqueue_script( 'jquery.appear',                $uri . '/libs/appear/jquery.appear.js', array(), false, true );
		
		//fancybox
		wp_enqueue_script( 'jquery.fancybox',              $uri . '/libs/fancybox/js/jquery.fancybox.js', array(), false, true );
		wp_enqueue_script( 'jquery.fancybox-buttons',      $uri . '/libs/fancybox/js/jquery.fancybox-buttons.js', array(), false, true );
		wp_enqueue_script( 'jquery.fancybox-thumbs',       $uri . '/libs/fancybox/js/jquery.fancybox-thumbs.js', array(), false, true );

		$keyMapAPI = '';
		$keyMapAPIOption = Buildplus_Core::get_theme_option('slz-map-key-api');
		if ( !empty($keyMapAPIOption) ) {
			$keyMapAPI = 'key='.trim($keyMapAPIOption).'&';
		}
		wp_enqueue_script( 'googleapis', $protocol . '://maps.googleapis.com/maps/api/js?'.$keyMapAPI.'sensor=false&amp;libraries=places', array(), false, true );
		
		//-----------------enqueue script to run ajax-------------------------- 
		wp_enqueue_script( 'buildplus-core-form', $uri . '/js/buildplus-core-form.js', array('jquery'), BUILDPLUS_CORE_VERSION, true );
		wp_localize_script(
				'buildplus-core-form',
				'ajaxurl',
				esc_url( admin_url( 'admin-ajax.php' ) )
		);
		wp_enqueue_script( 'buildplus-core-shortcode',   $uri . '/js/buildplus-core-shortcode.js', array('jquery'), BUILDPLUS_CORE_VERSION, true );
		wp_enqueue_script( 'buildplus-core-map',         $uri . '/js/buildplus-core-map.js', array('jquery'), '20200629', true );
	}
	/**
	 * action using generate inline css
	 * @param string $custom_css
	 */
	public function add_inline_style( $custom_css ) {
		wp_enqueue_style('buildplus-core-custom', BUILDPLUS_CORE_ASSET_URI . '/css/buildplus-core-custom.css', array(), BUILDPLUS_CORE_VERSION);
		wp_add_inline_style( 'buildplus-core-custom', $custom_css );
	}
	//********************* Post << *********************
	/**
	 * Add columns to post type list screen.
	 *
	 * @param array $columns Existing columns.
	 * @return array Amended columns.
	 */
	public function add_buildplus_team_columns( $columns ) {
		$defaults = array(
			'cb'                 => '',
			'slzcore-thumbs'     => esc_html__( 'Thumbnail', 'slz-core' ),
			'title'              => '',
			'slzcore-category'   => esc_html__( 'Categories', 'slz-core' ),
			'date'               => '',
		);
		$columns = array_merge( $defaults, $columns );
		return $columns;
	}
	public function add_buildplus_service_columns( $columns ) {
		$defaults = array(
			'cb'                 => '',
			'slzcore-thumbs'     => esc_html__( 'Thumbnail', 'slz-core' ),
			'title'              => '',
			'slzcore-category'   => esc_html__( 'Categories', 'slz-core' ),
			'slzcore-icons'       => esc_html__( 'Service Icon', 'slz-core' ),
			'date'               => '',
		);
		$columns = array_merge( $defaults, $columns );
		return $columns;
	}
	public function add_buildplus_project_columns( $columns ) {
		$defaults = array(
			'cb'                 => '',
			'slzcore-thumbs'     => esc_html__( 'Thumbnail', 'slz-core' ),
			'title'              => '',
			'slzcore-category'   => esc_html__( 'Categories', 'slz-core' ),
			'date'               => '',
		);
		$columns = array_merge( $defaults, $columns );
		return $columns;
	}
	public function add_custom_columns( $columns ) {
		global $post;

		$defaults = array(
			'cb'               => '',
			'slzcore-thumbs'   => esc_html__( 'Thumbnail', 'slz-core' ),
			'title'            => '',
			'slzcore-category' => esc_html__( 'Categories', 'slz-core' ),
			'date'             => '',
		);
		$columns = array_merge( $defaults, $columns );
		return $columns;
	}
	
	/**
	 * Custom column callback
	 *
	 * @param string $column Column ID.
	 */
	public function display_custom_columns( $column ){
		global $post;
		if ( ! $post ) return '';
		$post_id = $post->ID;
		$post_type = get_post_type();
		$method_name = $post_type . '_columns';
		if ( method_exists( $this, $method_name ) ) {
			$this->$method_name( $column, $post_id, $post_type );
		}
		switch ( $column ) {
			case 'slzcore-thumbs':
				$opts = array(
					'post_id'    => $post_id,
					'size'       => array( 100, 100 ),
					'post_title' => $post->post_title,
				);
				echo Buildplus_Core_Util::get_thumb_image( $opts );
				break;
			case 'slzcore-category':
				$taxonomy_cat = $post_type . '_cat';
				$term = $this->get_taxonomy_column( $taxonomy_cat, $post_id, $post_type );
				echo wp_kses_post($term);
				break;
			case 'slzcore-location':
				$taxonomy_cat = $post_type . '_location';
				$term = $this->get_taxonomy_column( $taxonomy_cat, $post_id, $post_type );
				echo wp_kses_post($term);
				break;
			case 'slzcore-status':
				$taxonomy_cat = $post_type . '_status';
				$term = $this->get_taxonomy_column( $taxonomy_cat, $post_id, $post_type );
				echo wp_kses_post($term);
				break;
			case 'slzcore-icons':
				$val = get_post_meta( $post_id, $post_type . '_icon', true);
				if( $val ) {
					echo '<div class="glyph"><span class="slz-icon  '.esc_attr($val).'"></span><span class="mls">'.esc_attr($val).'</span></div>';
				}
				break;
		}
	}
	private function get_taxonomy_column( $taxonomy, $post_id, $post_type ) {
		$term = '';
		if( taxonomy_exists( $taxonomy ) ) {
			// add separator for two or more terms
			$separtor = ', ';
			// get lists of term associated in the current post type
			$terms = get_the_terms( $post_id, $taxonomy );
			$links = array();
			if( $terms ) {
				foreach ( $terms as $term ) {
					// get link
					$term_link = esc_url(home_url('/')).'/wp-admin/edit.php?post_type='.$post_type.'&'.$taxonomy.'='.$term->slug;
					// the function explain its purpose
					if( is_wp_error( $term_link ) )
						continue;
					$links[] = '<a href="'.$term_link.'">'.$term->name.'</a>';
				}
			}
			$term = implode( $separtor, $links );
		}
		return $term;
	}
	/**
	 * Add columns to post type list
	 */
	public function manage_custom_columns(){
		$post_types = Buildplus_Core_Config::get( 'post_type', 'custom_column' );
		if( $post_types ) {
			foreach( $post_types as $pt ) {
				$method_name = 'add_'.$pt.'_columns';
				if( method_exists( $this, $method_name)) {
					add_filter( 'manage_edit-'. $pt .'_columns', array( 'Buildplus_Core', '[setting.Setting_Init, add_'. $pt .'_columns]' ) );
				} else {
					add_filter( 'manage_edit-'. $pt .'_columns', array( 'Buildplus_Core', '[setting.Setting_Init, add_custom_columns]' ) );
				}
				add_action( 'manage_'. $pt .'_posts_custom_column', array( 'Buildplus_Core', '[setting.Setting_Init, display_custom_columns]' ) );
			}
		}
	}
	/**
	 * Add meta box feature video to post type
	 */
	public function add_metabox_feature_video() {
		$post_types = Buildplus_Core_Config::get( 'post_type', 'feature_video' );
		if( $post_types ) {
			foreach( $post_types as $post_type ) {
				add_meta_box( 'buildplus_core_mbox_feature_video', esc_html__( 'Featured Video', 'slz-core' ), array( 'Buildplus_Core', '[posttype.Post_Controller, metabox_feature_video]' ), $post_type, 'side', 'low' );
			}
		}
	}
	/**
	 * Save feature video to post type
	 */
	public function save_feature_video( $post_id ) {
		$metakey = BUILDPLUS_CORE_THEME_PREFIX . '_feature_video';
		if( isset( $_POST[$metakey] ) ) {
			if( !isset($_POST[$metakey]['generate_thumnail']) ) {
				$_POST[$metakey]['generate_thumnail'] = '';
			}
			update_post_meta( $post_id, $metakey, $_POST[$metakey] );
			if( $_POST[$metakey]['generate_thumnail'] ) {
				$model = new Buildplus_Core_Video_Model();
				$model->get_video_thumb( $post_id, $metakey );
			}
		}
	}
	//********************* Post >> *********************
	public function add_permalink_settings(){
		$screen = get_current_screen();
		if ( !$screen ) {
			return;
		}
		if( $screen->id == 'options-permalink' ){
			$this->add_permalink_options();
			$this->save_permalink_options();
		}
	}
	public function add_permalink_options(){
		$custom_link_obj = array(
			'service'          => esc_html__( 'Service base', 'slz-core' ),
			'service_cat'      => esc_html__( 'Service category base', 'slz-core' ),
			'project'          => esc_html__( 'Project base', 'slz-core' ),
			'project_cat'      => esc_html__( 'Project category base', 'slz-core' ),
			'project_location' => esc_html__( 'Project location base', 'slz-core' ),
			'team'             => esc_html__( 'Team base', 'slz-core' ),
			'team_cat'         => esc_html__( 'Team category base', 'slz-core' )
		);
		foreach( $custom_link_obj as $key => $value ){
			add_settings_field(
				'buildplus_' . $key . '_slug',
				$value,
				array( 'Buildplus_Core', '[setting.Setting_Init, render_permalink_input]' ),
				'permalink',
				'optional',
				array( 'key' => $key )
			);
		}
	}
	public function save_permalink_options(){
		if ( ! is_admin() ) {
			return;
		}
		if ( isset( $_POST['permalink_structure'] ) ) {
			$permalinks = get_option( 'buildplus_permalinks' );
			if ( ! $permalinks ) {
				$permalinks = array();
			}
			$custom_link = array(
							'service', 'service_cat',
							'project', 'project_cat', 'project_location',
							'team', 'team_cat'
						);
			foreach( $custom_link as $name ){
				if( isset( $_POST['buildplus_'.$name.'_slug'] ) ){
					$permalinks[$name] = untrailingslashit( trim( $_POST['buildplus_'.$name.'_slug'] ) );
				}
			}
			update_option( 'buildplus_permalinks', $permalinks );
		}
	}
	public function render_permalink_input( $data ) {
		$permalinks = get_option( 'buildplus_permalinks' );
		if( isset( $data['key'] ) && !empty( $data['key'] ) ){
			$value = '';
			$key = $data['key'];
			if( isset( $permalinks[$key] ) && !empty( $permalinks[$key] ) ){
				$value = $permalinks[$key];
			}
			switch ( $key ) {
				case 'service':
					echo '<input name="buildplus_service_slug" type="text" class="regular-text code" value="'.esc_attr( $value ).'" placeholder="'.esc_attr__('service', 'slz-core').'" />';
					break;
				case 'service_cat':
					echo '<input name="buildplus_service_cat_slug" type="text" class="regular-text code" value="'.esc_attr( $value ).'" placeholder="'.esc_attr__('service-category', 'slz-core').'" />';
					break;
				case 'project':
					echo '<input name="buildplus_project_slug" type="text" class="regular-text code" value="'.esc_attr( $value ).'" placeholder="'.esc_attr__('project', 'slz-core').'" />';
					break;
				case 'project_cat':
					echo '<input name="buildplus_project_cat_slug" type="text" class="regular-text code" value="'.esc_attr( $value ).'" placeholder="'.esc_attr__('project-category', 'slz-core').'" />';
					break;
				case 'project_location':
					echo '<input name="buildplus_project_location_slug" type="text" class="regular-text code" value="'.esc_attr( $value ).'" placeholder="'.esc_attr__('project-location', 'slz-core').'" />';
					break;
				case 'team':
					echo '<input name="buildplus_team_slug" type="text" class="regular-text code" value="'.esc_attr( $value ).'" placeholder="'.esc_attr__('team', 'slz-core').'" />';
					break;
				case 'team_cat':
					echo '<input name="buildplus_team_cat_slug" type="text" class="regular-text code" value="'.esc_attr( $value ).'" placeholder="'.esc_attr__('team-category', 'slz-core').'" />';
					break;
			}
			
		}
	}
}