<?php
$style = array(
	esc_html__('Style 1', 'slz-core') => '1',
	esc_html__('Style 2', 'slz-core') => '2',
);
$icon_type = Buildplus_Core_Params::get('icon_type');
$icon_ex   = Buildplus_Core_Params::get('font_flaticon');
$admin_icon_url = '<a href="'.esc_url(admin_url( 'admin.php?page='.BUILDPLUS_CORE_THEME_PREFIX.'_icon' )).'" target="_blank">'.esc_html__('Buildplus Icons','slz-core').'</a>';
$params = array(
	//group contact info
	array(
		'type'           => 'dropdown',
		'heading'        => esc_html__( 'Style', 'slz-core' ),
		'param_name'     => 'style',
		'value'          => $style,
		'description'    => esc_html__( 'Choose style to display.', 'slz-core' ),
	),
	array(
		'type'           => 'textfield',
		'heading'        => esc_html__( 'Title', 'slz-core' ),
		'param_name'     => 'title',
		'description'    => esc_html__( 'Enter title for block.', 'slz-core' ),
	),
	array(
		'type'            => 'attach_image',
		'heading'         => esc_html__( 'Block Background Image', 'slz-core' ),
		'param_name'      => 'bg_image',
		'value'           => '',
		'dependency'     => array(
			'element'  => 'style',
			'value'    => array( '2'),
		),
		'description'     => esc_html__( 'Select background image for block.', 'slz-core' ),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Icon Color', 'slz-core' ),
		'param_name'      => 'icon_color',
		'value'           => '',
		'description'     => esc_html__( 'Set color for icon.', 'slz-core' ),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Icon Border Color', 'slz-core' ),
		'param_name'      => 'icon_bd_color',
		'value'           => '',
		'description'     => esc_html__( 'Set color for border of icon.', 'slz-core' ),
	),
	array(
		'type'           => 'textfield',
		'heading'        => esc_html__( 'Margin Bottom', 'slz-core' ),
		'param_name'     => 'margin_bt',
		'description'    => esc_html__( 'Enter margin bottom for block.Unit is px(ex:12px)', 'slz-core' ),
	),
	array(
		'type'          => 'textfield',
		'heading'       => esc_html__( 'Extra Class', 'slz-core' ),
		'param_name'    => 'extra_class',
		'description'   => esc_html__( 'Enter extra class name.', 'slz-core' )
	),
		array(
		'type'            => 'param_group',
		'heading'         => esc_html__( 'Contact Information', 'slz-core' ),
		'param_name'      => 'group_list',
		'group'           => esc_html__( 'Contact Information', 'slz-core'),
		'params'          => array(
			array(
				'type'           => 'dropdown',
				'heading'        => esc_html__( 'Choose type of icon', 'slz-core' ),
				'param_name'     => 'icon_type',
				'value'          => $icon_type,
				'description'    => esc_html__( 'Choose type of icon to display block.', 'slz-core' )
			),
			array(
				'type'           => 'iconpicker',
				'heading'        => esc_html__( 'Choose Icon', 'slz-core' ),
				'param_name'     => 'icon_fw',
				'dependency'     => array(
					'element'  => 'icon_type',
					'value'    => array( '02'),
				),
				'description'    => esc_html__( 'Choose icon to display in box.', 'slz-core' )
			),
			array(
				'type'           => 'dropdown',
				'heading'        => esc_html__( 'Choose Icon', 'slz-core' ),
				'param_name'     => 'icon_flat',
				'value'          => $icon_ex,
				'dependency'     => array(
					'element'  => 'icon_type',
					'value'    => array( ''),
				),
				'description'    => sprintf(__( 'Please go on "%s" to reference about icons of our theme.', 'slz-core' ), $admin_icon_url )
			),
			array(
				'type'           => 'textarea',
				'heading'        => esc_html__( 'Contact Information', 'slz-core' ),
				'param_name'     => 'info_title',
			),
		)
	),
	
);
vc_map(array(
	'name'        => esc_html__( 'SLZ Contact', 'slz-core' ),
	'base'        => 'slzcore_contact_sc',
	'class'       => 'slzcore-sc',
	'icon'        => 'icon-slzcore_contact_sc',
	'category'    => BUILDPLUS_CORE_SC_CATEGORY,
	'description' => esc_html__( 'Display contact information', 'slz-core' ),
	'params'      => $params
));