<?php
$contact_form_arr = array(esc_html__( '-None-', 'slz-core' ) => '');
$args = array (
			'post_type'     => 'wpcf7_contact_form',
			'post_per_page' => -1,
			'status'        => 'publish',
		);
$post_arr = get_posts( $args );
foreach( $post_arr as $post ){
	$k = ( !empty( $post->post_title ) )? $post->post_title : $post->post_name;
	$contact_form_arr[$k] =  $post->ID ;
}
$params = array(
	array(
		"type"        => "attach_image",
		"heading"     => esc_html__( 'Map Marker Image', 'slz-core' ),
		"param_name"  => "map_marker",
		'value'       => '',
	),
	array(
		'type'           => 'textfield',
		'heading'        => esc_html__( 'Zoom', 'slz-core' ),
		'param_name'     => 'zoom',
		'value'          => '9',
		'description'    => esc_html__( 'Enter zoom number of map. Number between 0 (farthest) and 22 that sets the zoom level of the map.', 'slz-core' ),
	),	
	array(
		'type'            => 'param_group',
		'heading'         => esc_html__( 'Address for Map', 'slz-core' ),
		'param_name'      => 'group_list',
		'params'          => array(
			array(
				'type'           => 'textfield',
				'heading'        => esc_html__( 'Address', 'slz-core' ),
				'param_name'     => 'address',
				'description'    => esc_html__( 'Enter Address.', 'slz-core' ),
			),
		)
	),
	array(
		'type'          => 'textfield',
		'heading'       => esc_html__( 'Extra Class', 'slz-core' ),
		'param_name'    => 'extra_class',
		'description'   => esc_html__( 'Enter extra class name.', 'slz-core' )
	),
	// group contact form
	array(
		'type'          => 'textfield',
		'heading'       => esc_html__( 'Title of Contact Form', 'slz-core' ),
		'param_name'    => 'ctf_title',
		'group'         => esc_html__( 'Contact Form', 'slz-core'),
	),
	array(
		'type'            => 'dropdown',
		'heading'         => esc_html__( 'Contact Form', 'slz-core' ),
		'param_name'      => 'contact_form',
		'group'           => esc_html__( 'Contact Form', 'slz-core'),
		'value'           => $contact_form_arr,
		'description'     => esc_html__( 'Select contact form to display.', 'slz-core' ),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Title Color', 'slz-core' ),
		'param_name'      => 'ctf_title_cl',
		'value'           => '',
		'group'           => esc_html__( 'Contact Form', 'slz-core'),
		'description'     => esc_html__( 'Select color for title of contact form.', 'slz-core' ),
		'edit_field_class' => 'vc_col-sm-6 vc_column',
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Text Color', 'slz-core' ),
		'param_name'      => 'ctf_text_cl',
		'value'           => '',
		'group'           => esc_html__( 'Contact Form', 'slz-core'),
		'description'     => esc_html__( 'Select color for placeholder of input.', 'slz-core' ),
		'edit_field_class' => 'vc_col-sm-6 vc_column',
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Border Color', 'slz-core' ),
		'param_name'      => 'ctf_border_cl',
		'value'           => '',
		'group'           => esc_html__( 'Contact Form', 'slz-core'),
		'description'     => esc_html__( 'Select color for border of input.', 'slz-core' ),
		'edit_field_class' => 'vc_col-sm-6 vc_column',
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Block Background Color', 'slz-core' ),
		'param_name'      => 'ctf_bg_cl',
		'value'           => '',
		'group'           => esc_html__( 'Contact Form', 'slz-core'),
		'description'     => esc_html__( 'Select background color for block.', 'slz-core' ),
		'edit_field_class' => 'vc_col-sm-6 vc_column',
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Button Color', 'slz-core' ),
		'param_name'      => 'ctf_btn_cl',
		'value'           => '',
		'group'           => esc_html__( 'Contact Form', 'slz-core'),
		'edit_field_class' => 'vc_col-sm-6 vc_column',
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Button Background Color', 'slz-core' ),
		'param_name'      => 'ctf_btn_bg_cl',
		'value'           => '',
		'group'           => esc_html__( 'Contact Form', 'slz-core'),
		'edit_field_class' => 'vc_col-sm-6 vc_column',
	),
);
vc_map(array(
	'name'        => esc_html__( 'SLZ Contact Map', 'slz-core' ),
	'base'        => 'slzcore_contact_map_sc',
	'class'       => 'slzcore-sc',
	'icon'        => 'icon-slzcore_contact_sc',
	'category'    => BUILDPLUS_CORE_SC_CATEGORY,
	'description' => esc_html__( 'Display contact information with map and contact form', 'slz-core' ),
	'params'      => $params
));