<?php
$icon_type = Buildplus_Core_Params::get('icon_type');
$icon_ex   = Buildplus_Core_Params::get('font_awesome');
$admin_icon_url = '<a href="'.esc_url(admin_url( 'admin.php?page='.BUILDPLUS_CORE_THEME_PREFIX.'_icon' )).'" target="_blank">'.esc_html__('Buildplus Icons','slz-core').'</a>';
$style = array(
		esc_html__('Style 1', 'slz-core') => '1',
		esc_html__('Style 2', 'slz-core') => '2',
	);
$params = array(
	array(
		'type'           => 'dropdown',
		'heading'        => esc_html__( 'Style', 'slz-core' ),
		'param_name'     => 'style',
		'value'          => $style,
		'description'    => esc_html__( 'Choose style to display.', 'slz-core' ),
	),
	array(
		'type'           => 'dropdown',
		'heading'        => esc_html__( 'Choose type of icon', 'slz-core' ),
		'param_name'     => 'icon_type',
		'value'          => $icon_type,
		'dependency'     => array(
			'element'  => 'style',
			'value'    => array('1')),
		'description'    => esc_html__( 'Choose style to display block.', 'slz-core' )
	),
	array(
		'type'           => 'iconpicker',
		'heading'        => esc_html__( 'Choose Icon', 'slz-core' ),
		'param_name'     => 'icon_fw',
		'dependency'     => array(
			'element'  => 'icon_type',
			'value'    => array('02')),
		'description'    => esc_html__( 'Choose icon to display in box.', 'slz-core' )
	),
	array(
		'type'           => 'dropdown',
		'heading'        => esc_html__( 'Choose Icon', 'slz-core' ),
		'param_name'     => 'icon_ex',
		'value'          => $icon_ex,
		'dependency'     => array(
			'element'  => 'icon_type',
			'value'    => array('')),
		'description'    => sprintf(__( 'Please go on "%s" to reference about icons of our theme.', 'slz-core' ), $admin_icon_url )
	),
	array(
		'type'            => 'param_group',
		'heading'         => esc_html__( 'Add Item', 'slz-core' ),
		'param_name'      => 'group_list',
		'params'          => array(
			array(
				'type'        => 'textfield',
				'admin_label' => true,
				'heading'     => esc_html__( 'Description', 'slz-core' ),
				'param_name'  => 'description',
				'description' => esc_html__( 'Enter description of item',  'slz-core'  )
			)
		)
	),
	array(
		"type"        		=> "colorpicker",
		"class"       		=> "",
		"value"		  		=> '',
		"heading"     		=> esc_html__( "Icon Color", 'slz-core' ),
		"param_name"  		=> "icon_color",
		"description" 		=> esc_html__( "Choose color for icon", 'slz-core' ),
		'group'				=> esc_html__( 'Custom Options', 'slz-core' ),
	),
	array(
		"type"        		=> "colorpicker",
		"class"       		=> "",
		"value"		  		=> '',
		"heading"     		=> esc_html__( "Description Color", 'slz-core' ),
		"param_name"  		=> "desc_color",
		"description" 		=> esc_html__( "Choose color for description", 'slz-core' ),
		'group'				=> esc_html__( 'Custom Options', 'slz-core' ),
	),
	array(
		'type'            => 'textfield',
		'heading'         => esc_html__( 'Extra Class', 'slz-core' ),
		'param_name'      => 'extra_class',
		'description'     => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'slz-core' )
	)
);

vc_map(
	array(
		"name"			=> esc_html__( 'SLZ Item List', 'slz-core' ),
		"base"			=> "slzcore_item_list_sc",
		"class"			=> "slzcore-sc",
		"category"		=> BUILDPLUS_CORE_SC_CATEGORY,
		'icon'			=> 'icon-slzcore_item_list_sc',
		"description"	=> esc_html__( 'Help you to create item list.', 'slz-core' ),
		"params"		=> $params
	)
);
