<?php
$category = Buildplus_Core_Com::get_category2slug_array();
$tag      = Buildplus_Core_Com::get_tax_options2slug( 'post_tag', array('empty' => esc_html__( '-All tags-', 'slz-core' ) ) );
$author   = Buildplus_Core_Com::get_user_login2id(array(), array('empty' => esc_html__( '-All authors-', 'slz-core' ) ) );
$formats  = Buildplus_Core_Com::get_post_formats( array(esc_html__( '-All formats-', 'slz-core' ) => '' ) );
$orderby  = Buildplus_Core_Params::get('sort-blog');
$show_paging   = array(
	esc_html__('No', 'slz-core') => '',
	esc_html__('Yes', 'slz-core')=> 'yes',
);
$yes_no   = array(
	esc_html__('Yes', 'slz-core')=> 'yes',
	esc_html__('No', 'slz-core') => 'no',
);
$show_content  = array(
	esc_html__('Excerpt', 'slz-core')      => 'excerpt',
	esc_html__('Full Content', 'slz-core') => 'content'
);
$columns  = Buildplus_Core_Params::get('block_column');
$date_style   = array(
	esc_html__('Normal Style', 'slz-core')=> '',
	esc_html__('Ribbon Style', 'slz-core')=> 'ribbon',
	esc_html__('Hide', 'slz-core') => 'no',
);
$block_style  = array(
	esc_html__('Vertical', 'slz-core')      => '01',
	esc_html__('Horizontal 01', 'slz-core') => '02',
	esc_html__('Horizontal 02', 'slz-core') => '03'
);
$column_02 = array(
				esc_html__('One', 'slz-core') => '1',
				esc_html__('Two', 'slz-core') => '2'
			);
$params = array(
	array(
		'type'        => 'dropdown',
		'heading'     => esc_html__( 'Style', 'slz-core' ),
		'param_name'  => 'style',
		'value'       => $block_style,
		'description' => esc_html__( 'Choose style for block.', 'slz-core' )
	),
	array(
		'type'        => 'dropdown',
		'heading'     => esc_html__( 'Columns', 'slz-core' ),
		'param_name'  => 'column_02',
		'value'       => $column_02,
		'description' => esc_html__( 'Choose number of columns to display.', 'slz-core' ),
		'dependency'  => array(
			'element' => 'style',
			'value'   => array('02','03')
		)
	),
	array(
		'type'        => 'dropdown',
		'heading'     => esc_html__( 'Columns', 'slz-core' ),
		'param_name'  => 'column',
		'value'       => $columns,
		'description' => esc_html__( 'Choose number of columns to display.', 'slz-core' ),
		'dependency'  => array(
			'element' => 'style',
			'value'   => array('01')
		)
	),
	array(
		'type'        => 'textfield',
		'heading'     => esc_html__( 'Limit Posts', 'slz-core' ),
		'param_name'  => 'limit_post',
		'value'       => 5,
		'description' => esc_html__( 'Enter limit of posts per page. If it blank the limit posts will be the number from Wordpress settings -> Reading. If you want show all, enter "-1".', 'slz-core' )
	),
	array(
		'type'        => 'textfield',
		'heading'     => esc_html__( 'Offset Posts', 'slz-core' ),
		'param_name'  => 'offset_post',
		'value'       => '',
		'description' => esc_html__( 'Enter offset to pass over posts. If you want to start on record 6, using offset 5.', 'slz-core' )
	),
	
	array(
		'type'        => 'dropdown',
		'heading'     => esc_html__( 'Sort By', 'slz-core' ),
		'param_name'  => 'sort_by',
		'value'       => $orderby,
		'description' => esc_html__( 'Choose criteria to display.', 'slz-core' )
	),
	array(
		'type'        => 'dropdown',
		'heading'     => esc_html__( 'Pagination', 'slz-core' ),
		'param_name'  => 'pagination',
		'value'       => $show_paging,
		'std'         => 'yes',
		'description' => esc_html__( 'Show pagination.', 'slz-core' ),
	),
	array(
		'type'        => 'textfield',
		'heading'     => esc_html__( 'Max posts', 'slz-core' ),
		'param_name'  => 'max_post',
		'description' => esc_html__( 'Total posts when paging.', 'slz-core' ),
		'dependency' => array(
			'element' => 'pagination',
			'value'   => array( 'yes' ),
		),
	),
	array(
		'type'        => 'textfield',
		'heading'     => esc_html__( 'Extra Class', 'slz-core' ),
		'param_name'  => 'extra_class',
		'description' => esc_html__( 'Enter extra class.', 'slz-core' )
	),
	array(
		'type'            => 'checkbox',
		'heading'         => esc_html__( 'Include Sticky Posts', 'slz-core' ),
		'param_name'      => 'show_sticky',
		'value'           => array( esc_html__( 'Yes', 'slz-core' ) => 'yes' ),
		'description'     => esc_html__( 'Checked to show sticky posts.', 'slz-core' ),
		'group'           => esc_html__('Filter', 'slz-core')
	),
	array(
		'type'       => 'param_group',
		'heading'    => esc_html__( 'Category', 'slz-core' ),
		'param_name' => 'category_list',
		'params'     => array(
			array(
				'type'        => 'dropdown',
				'admin_label' => true,
				'heading'     => esc_html__( 'Add Category', 'slz-core' ),
				'param_name'  => 'category_slug',
				'value'       => $category,
				'description' => esc_html__( 'Choose special category to filter', 'slz-core'  )
			),
		),
		'value'       => '',
		'description' => esc_html__( 'Default no filter by category.', 'slz-core' ),
		'group'       => esc_html__( 'Filter', 'slz-core' ),
	),
	array(
		'type'       => 'param_group',
		'heading'    => esc_html__( 'Tag', 'slz-core' ),
		'param_name' => 'tag_list',
		'params'     => array(
			array(
				'type'        => 'dropdown',
				'admin_label' => true,
				'heading'     => esc_html__( 'Add Tag', 'slz-core' ),
				'param_name'  => 'tag_slug',
				'value'       => $tag,
				'description' => esc_html__( 'Choose special tag to filter', 'slz-core'  )
			),
		),
		'value'       => '',
		'description' => esc_html__( 'Default no filter by tag.', 'slz-core' ),
		'group'       => esc_html__( 'Filter', 'slz-core' ),
	),
	array(
		'type'       => 'param_group',
		'heading'    => esc_html__( 'Author', 'slz-core' ),
		'param_name' => 'author_list',
		'params'     => array(
			array(
				'type'        => 'dropdown',
				'admin_label' => true,
				'heading'     => esc_html__( 'Add Author', 'slz-core' ),
				'param_name'  => 'author',
				'value'       => $author,
				'description' => esc_html__( 'Choose special author to filter', 'slz-core'  )
			),
		),
		'value'       => '',
		'description' => esc_html__( 'Default no filter by author.', 'slz-core' ),
		'group'       => esc_html__( 'Filter', 'slz-core' ),
	),
	array(
		'type'       => 'param_group',
		'heading'    => esc_html__( 'Post Formats', 'slz-core' ),
		'param_name' => 'format_list',
		'params'     => array(
			array(
				'type'        => 'dropdown',
				'admin_label' => true,
				'heading'     => esc_html__( 'Add Author', 'slz-core' ),
				'param_name'  => 'post_format',
				'value'       => $formats,
				'description' => esc_html__( 'Choose special post format to filter', 'slz-core'  )
			),
		),
		'value'       => '',
		'description' => esc_html__( 'Default no filter by post format.', 'slz-core' ),
		'group'       => esc_html__( 'Filter', 'slz-core' ),
	),
	array(
		'type'        => 'dropdown',
		'heading'     => esc_html__( 'Show Date Style', 'slz-core' ),
		'param_name'  => 'show_date',
		'value'       => $date_style,
		'description' => esc_html__( 'Choose style to display or hide post date.', 'slz-core' ),
		'group'       => esc_html__( 'Options', 'slz-core' ),
		'dependency'  => array(
			'element' => 'style',
			'value'   => array('01', '03')
		)
	),
	array(
		'type'        => 'dropdown',
		'heading'     => esc_html__( 'Show Post Author', 'slz-core' ),
		'param_name'  => 'show_author',
		'value'       => $yes_no,
		'std'         => 'yes',
		'description' => esc_html__( 'Show or hide post author.', 'slz-core' ),
		'group'       => esc_html__( 'Options', 'slz-core' ),
		'dependency'  => array(
			'element' => 'style',
			'value'   => array('01', '03')
		)
	),
	array(
		'type'        => 'dropdown',
		'heading'     => esc_html__( 'Show Post Comments', 'slz-core' ),
		'param_name'  => 'show_comments',
		'value'       => $yes_no,
		'std'         => 'yes',
		'description' => esc_html__( 'Show or hide post comments.', 'slz-core' ),
		'group'       => esc_html__( 'Options', 'slz-core' ),
		'dependency'  => array(
			'element' => 'style',
			'value'   => array('01', '03')
		)
	),
	array(
		'type'        => 'dropdown',
		'heading'     => esc_html__( 'Show Post Views', 'slz-core' ),
		'param_name'  => 'show_views',
		'value'       => $yes_no,
		'std'         => 'yes',
		'description' => esc_html__( 'Show or hide post views.', 'slz-core' ),
		'group'       => esc_html__( 'Options', 'slz-core' ),
		'dependency'  => array(
			'element' => 'style',
			'value'   => array('01', '03')
		)
	),
	array(
		'type'        => 'dropdown',
		'heading'     => esc_html__( 'Show Content or Excerpt', 'slz-core' ),
		'param_name'  => 'show_content',
		'value'       => $show_content,
		'description' => esc_html__( 'Choose what you want to display as content of post.', 'slz-core' ),
		'group'       => esc_html__( 'Options', 'slz-core' ),
	),
	array(
		'type'        => 'textfield',
		'heading'     => esc_html__( 'Excerpt Length', 'slz-core' ),
		'param_name'  => 'excerpt_length',
		'value'       => '',
		'dependency' => array(
			'element' => 'show_content',
			'value'   => array( 'excerpt' ),
		),
		'description' => esc_html__( 'Enter limit of text will be truncated. If it is empty, the default is not cut. It will trim word', 'slz-core' ),
		'group'       => esc_html__( 'Options', 'slz-core' ),
	),
	array(
		'type'        => 'colorpicker',
		'heading'     => esc_html__( 'Ribbon Date Background Color', 'slz-core' ),
		'param_name'  => 'date_bg_color',
		'value'       => '',
		'dependency' => array(
			'element' => 'show_date',
			'value'   => array( 'ribbon' ),
		),
		'description' => esc_html__( 'Enter backgroundcolor for post date.', 'slz-core' ),
		'group'       => esc_html__( 'Options', 'slz-core' ),
	),
	array(
		'type'        => 'colorpicker',
		'heading'     => esc_html__( 'Date Background Color', 'slz-core' ),
		'param_name'  => 'date_02_bg_color',
		'value'       => '',
		'dependency' => array(
			'element' => 'style',
			'value'   => array( '02' ),
		),
		'description' => esc_html__( 'Enter backgroundcolor for post date.', 'slz-core' ),
		'group'       => esc_html__( 'Options', 'slz-core' ),
	),
	array(
		'type'        => 'colorpicker',
		'heading'     => esc_html__( 'Date Color', 'slz-core' ),
		'param_name'  => 'date_color',
		'value'       => '',
		'description' => esc_html__( 'Enter color for post date.', 'slz-core' ),
		'group'       => esc_html__( 'Options', 'slz-core' ),
	),
	array(
		'type'        => 'colorpicker',
		'heading'     => esc_html__( 'Hover Color', 'slz-core' ),
		'param_name'  => 'hover_color',
		'value'       => '',
		'description' => esc_html__( 'Enter hover color for title, more icon.', 'slz-core' ),
		'group'       => esc_html__( 'Options', 'slz-core' ),
	),
);
vc_map(array(
	'name'               => esc_html__( 'SLZ Post List', 'slz-core' ),
	'base'               => 'slzcore_post_list_sc',
	'class'              => 'slzcore-sc',
	'icon'               => 'icon-slzcore_post_list_sc',
	'category'           => BUILDPLUS_CORE_SC_CATEGORY,
	'description'        => esc_html__( 'List posts.', 'slz-core' ),
	'params'             => $params
));