<?php
$yes_no  = array(
	esc_html__('Yes', 'slz-core')			=> 'yes',
	esc_html__('No', 'slz-core')			=> 'no',
);
$method = array(
	esc_html__( 'Category', 'slz-core' )	=> 'cat',
	esc_html__( 'Service', 'slz-core' ) 	=> 'service'
);
$sort_by = BuildPlus_Core_Params::get('sort-other');

$args = array('post_type'     => 'buildplus_service');
$options = array('empty'      => esc_html__( '-All Service-', 'slz-core' ) );
$services = BuildPlus_Core_Com::get_post_title2id( $args, $options );

$taxonomy = 'buildplus_service_cat';
$params_cat = array('empty'   => esc_html__( '-All Service Categories-', 'slz-core' ) );
$categories = BuildPlus_Core_Com::get_tax_options2slug( $taxonomy, $params_cat );

$params = array(
	array(
		'type'        	=> 'dropdown',
		'heading'     	=> esc_html__( 'Show Description ?', 'slz-core' ),
		'param_name'  	=> 'show_desc',
		'value'       	=> $yes_no,
		'std'      		=> 'yes',
		'description' 	=> esc_html__( 'If choose Yes, block will be show description.', 'slz-core' ),
	),
	array(
		'type'            => 'textfield',
		'heading'         => esc_html__( 'Description Length', 'slz-core' ),
		'param_name'      => 'desc_lenght',
		'description'     => esc_html__( 'Enter number for limiting the number of word displayed.', 'slz-core' ),
		'dependency'     => array(
			'element'  => 'show_desc',
			'value'    => array( 'yes' ),
		),
	),
	array(
		'type'            => 'textfield',
		'heading'         => esc_html__( 'Button Text', 'slz-core' ),
		'param_name'      => 'button_text',
		'description'     => esc_html__( 'Enter value for button displayed. If blank, the button does not show.', 'slz-core' ),
	),

	array(
		'type'            => 'textfield',
		'heading'         => esc_html__( 'Limit Posts', 'slz-core' ),
		'param_name'      => 'limit_post',
		'value'           => '-1',
		'description'     => esc_html__( 'Add limit posts per page. Set -1 or empty to show all.', 'slz-core' )
	),
	array(
		'type'            => 'textfield',
		'heading'         => esc_html__( 'Offset Posts', 'slz-core' ),
		'param_name'      => 'offset_post',
		'value'           => '0',
		'description'     => esc_html__( 'Enter offset to pass over posts. If you want to start on record 6, using offset 5', 'slz-core' )
	),
	array(
		'type'            => 'dropdown',
		'heading'         => esc_html__( 'Sort By', 'slz-core' ),
		'param_name'      => 'sort_by',
		'value'           => $sort_by,
		'description'     => esc_html__( 'Select order to display list properties.', 'slz-core' ),
	),
	array(
		'type'            => 'textfield',
		'heading'         => esc_html__( 'Extra Class', 'slz-core' ),
		'param_name'      => 'extra_class',
		'description'     => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'slz-core' )
	),

	array(
		'type'        => 'dropdown',
		'heading'     => esc_html__( 'Display By', 'slz-core' ),
		'param_name'  => 'method',
		'value'       => $method,
		'description' => esc_html__( 'Choose service category or special services to display', 'slz-core' ),
		'group'       	=> esc_html__('Filter', 'slz-core'),
	),
	array(
		'type'        => 'param_group',
		'heading'     => esc_html__( 'Category', 'slz-core' ),
		'param_name'  => 'category',
		'params'     => array(
			array(
				'type'        => 'dropdown',
				'admin_label' => true,
				'heading'     => esc_html__( 'Add Category', 'slz-core' ),
				'param_name'  => 'category_slug',
				'value'       => $categories,
				'description' => esc_html__( 'Choose special category to filter', 'slz-core'  )
			),
		),
		'value'       => '',
		'callbacks'   => array(
			'after_add' => 'vcChartParamAfterAddCallback'
		),
		'description' => esc_html__( 'Choose Service Category.', 'slz-core' ),
		'dependency'  => array(
			'element'   => 'method',
			'value'     => array( 'cat' )
		),
		'group'       	=> esc_html__('Filter', 'slz-core'),
	),
	array(
		'type'            => 'param_group',
		'heading'         => esc_html__( 'Services', 'slz-core' ),
		'param_name'      => 'list_post',
		'params'          => array(
			array(
				'type'        => 'dropdown',
				'admin_label' => true,
				'heading'     => esc_html__( 'Add Service', 'slz-core' ),
				'param_name'  => 'service',
				'value'       => $services,
				'description' => esc_html__( 'Choose special service to show',  'slz-core'  )
			),
			
		),
		'value'           => '',
		'dependency'  => array(
			'element'   => 'method',
			'value'     => array( 'service' )
		),
		'callbacks'       => array(
			'after_add'   => 'vcChartParamAfterAddCallback'
		),
		'description'     => esc_html__( 'Default display All Service if no service is selected and Number service is empty.', 'slz-core' ),
		'group'       	=> esc_html__('Filter', 'slz-core'),
	),

	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Navigation Title Color', 'slz-core' ),
		'param_name'      => 'color_nav_title',
		'value'           => '',
		'description'     => esc_html__( 'Choose color title for navigation.', 'slz-core' ),
		'group'       	  => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Navigation Title Color Hover', 'slz-core' ),
		'param_name'      => 'color_nav_title_hv',
		'value'           => '',
		'description'     => esc_html__( 'Choose color title for navigation when hover.', 'slz-core' ),
		'group'       	  => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Navigation Background Color Hover', 'slz-core' ),
		'param_name'      => 'color_nav_bg_hv',
		'value'           => '',
		'description'     => esc_html__( 'Choose background color for navigation when hover.', 'slz-core' ),
		'group'       	  => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Navigation Background Color', 'slz-core' ),
		'param_name'      => 'color_nav_bg',
		'value'           => '',
		'description'     => esc_html__( 'Choose background color for navigation.', 'slz-core' ),
		'group'       	  => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Navigation Border Bottom Color', 'slz-core' ),
		'param_name'      => 'color_nav_border_hv',
		'value'           => '',
		'description'     => esc_html__( 'Choose border bottom color for navigation.', 'slz-core' ),
		'group'       	  => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Navigation Icon Color', 'slz-core' ),
		'param_name'      => 'color_nav_icon',
		'value'           => '',
		'description'     => esc_html__( 'Choose color icon for navigation.', 'slz-core' ),
		'group'       	  => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Navigation Icon Color Hover', 'slz-core' ),
		'param_name'      => 'color_nav_icon_hv',
		'value'           => '',
		'description'     => esc_html__( 'Choose color icon for navigation when hover.', 'slz-core' ),
		'group'       	  => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Navigation Icon Background Color Hover', 'slz-core' ),
		'param_name'      => 'color_nav_icon_bg_hv',
		'value'           => '',
		'description'     => esc_html__( 'Choose background color icon for navigation when hover.', 'slz-core' ),
		'group'       	  => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Description Color', 'slz-core' ),
		'param_name'      => 'color_description',
		'value'           => '',
		'description'     => esc_html__( 'Choose color description for block image.', 'slz-core' ),
		'group'       	  => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Button Read More Color', 'slz-core' ),
		'param_name'      => 'color_button',
		'value'           => '',
		'description'     => esc_html__( 'Choose color button read more for block image.', 'slz-core' ),
		'group'       	  => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Button Read More Color Hover', 'slz-core' ),
		'param_name'      => 'color_button_hv',
		'value'           => '',
		'description'     => esc_html__( 'Choose color button read more for block image when hover.', 'slz-core' ),
		'group'       	  => esc_html__('Custom', 'slz-core'),
	),
);
vc_map(array(
	'name'        => esc_html__( 'SLZ Service Carousel', 'slz-core' ),
	'base'        => 'slzcore_service_carousel_sc',
	'class'       => 'slzcore-sc',
	'icon'        => 'icon-slzcore',
	'category'    => BUILDPLUS_CORE_SC_CATEGORY,
	'description' => esc_html__( 'Carousel of Services.', 'slz-core' ),
	'params'      => $params
	)
);