<?php
Buildplus_Core::load_class( 'models.Blog_Model' );

class Buildplus_Core_Blog extends Buildplus_Core_Blog_Model {

	private $row_post_counter = 0;
	private $row_counter;
	private $post_counter = 0;
	private $block_atts;
	
	public $large_image_post = true;
	public $start_group = true;
	public $show_full_meta = true;
	public $show_widget_meta = false;

	public function init( $atts ) {
		// default
		$this->large_image_post = true;
		$this->start_group = true;
		$this->row_post_counter = 0;
		$this->row_counter = 1;
		$this->post_counter = 0;

		// set attributes
		$atts = $this->get_block_setting($atts);
		$this->block_atts = $atts;
		$this->set_attributes( $atts );
		$this->block_atts['block-class'] = $this->attributes['block-class'];

		$this->get_thumb_size();
		$this->set_responsive_class($atts);
		// add inline css
		$custom_css = $this->add_custom_css();
	}
	public function set_post_options_defaults( $atts ) {
		$default = array(
			'large_post_format' => '',
			'small_post_format' => '',
			'open_group'        => '',
			'open_row'          => '',
			'close_row'         => '',
			'close_group'       => '',
			'content_length'    => '',
			'large_post_counter'=> 1,
			'show_related_post' => '',
			'new_row'           => '1',
			'thumb_href_class'  => '',
			'show_full_meta'    => '',
			'show_widget_meta'  => '',
			'meta_more_format'  => '',
			'html_format'       => '',
			'title_format'      => '<a href="%2$s" class="title" >%1$s</a>',
			'title_quote_format'=> '<div class="block-quote"><a href="%2$s" class="content" >%1$s</a></div>',
			'excerpt_format'    => '<div class="description">%1$s</div>',
			'content_format'    => '<div class="description">%1$s%2$s</div>',
			'meta_info_format'  => '<div class="block-info"><i class="icons fa fa-bookmark"></i>%1$s</div>',
			'image_format'      => '<div class="block-image">%2$s<a href="%1$s" class="link"></a></div>',
			'video_format'      => '<div class="block-image block-video">
										<div class="btn-play"> <img src="'.esc_url(BUILDPLUS_CORE_VIDEO_BTN).'" alt="" class="img-responsive"></div>
										<div class="btn-close"><img src="'.esc_url(BUILDPLUS_CORE_VIDEO_CLOSE).'" alt="" class="img-responsive"></div>
										%2$s
										%1$s
									</div>',
			'author_format'     => '<div class="block"><a href="%1$s" class="link">%2$s</a></div>',
			'view_format'       => '<div class="block"><span class="link">%1$s</span></div>',
			'comment_format'    => '<div class="block"><a href="%1$s" class="link">%2$s</a></div>',
			'date_format'       => '<div class="block"><span class="link">'.esc_html__('date:', 'slz-core').'</span><a href="%1$s" class="link date">%2$s</a></div>',
			'rib_date_format'   => '<div class="label-block">
										<div class="text-1">25.07</div>
										<div class="text-2">2016</div>
										<a href="#" class="link-date"></a>
									</div>
									<a href="#" class="link"></a>',
			'more_btn_format'   => '<a href="%1$s" class="readmore-icons"><i class="icons flaticon-bleed"></i></a>',
			
			'no_thumbnails_image' => '',
			'no_image_class'     => 'style-2',
			'bg_image' => '',
		);
		foreach($default as $key => $val ) {
			if( isset( $atts[$key] ) ) {
				$default[$key] = $atts[$key];
				unset( $atts[$key] );
			}
		}
		if( $atts ) {
			foreach($atts as $key => $val ) {
				$default[$key] = $atts[$key];
			}
		}
		return $default;
	}
	public function set_responsive_class($atts) {
		$class = '';
		$column = $this->attributes['column'];
		if( isset($atts['res_class']) ) {
			$class = $atts['res_class'];
		}
		$def = array(
			'1' => 'column-1',
			'2' => 'column-2 ' . $class,
			'3' => 'column-3',
			'4' => 'column-4',
		);;
		
		if( $column && isset($def[$column])) {
			$this->attributes['responsive-class'] = $def[$column];
		} else {
			$this->attributes['responsive-class'] = $def['1'];
		}
	}
	
	
	public function get_blog_left_content( $options = array() ){
		$out = '';
		if( isset( $options['left_content_format'] ) && !empty( $options['left_content_format'] ) ){
			$out = sprintf( $options['left_content_format'], $this->get_featured_by_format( 'large', $options ) );
		}
		return $out;
	}
	
	public function get_meta_info() {
		$meta_array = array(
			'author'   => $this->get_author(),
			'date'     => '',
			'view'     => $this->get_views(),
			'comment'  => $this->get_comments()
		);
		$output = '';
		if( $this->attributes['show_date'] != 'ribbon') {
			$meta_array['date'] = $this->get_date();
		}
		foreach( $meta_array as $key => $val ) {
			if( !empty( $val ) ) {
				$output .= $val;
			}
		}
		if( !empty( $output ) ) {
			$output = sprintf( $this->html_format['meta_info_format'], $output );
		}
		return $output;
	}
	
	public function get_meta_info_more( $seperate = '' ) {
		$meta_array = array(
			'comment'  => $this->get_comments(),
			'view'     => $this->get_views(),
		);
		foreach( $meta_array as $key => $val ) {
			if( empty( $val ) ) {
				unset($meta_array[$key]);
			}
		}
		if( isset($this->html_format['meta_seperate'])) {
			$seperate = $this->html_format['meta_seperate'];
		}
		$output = implode( $seperate, $meta_array );
		$format = $this->html_format['meta_info_format'];
		if( $output ) {
			$output = sprintf( $format, $output );
		}
		return $output;
	}
	
	public function get_meta( $seperate = '') {
		$output = '';
		if( $this->attributes['show_meta'] == 'hide' ) {
			return '';
		}
		if ( !$this->show_full_meta ){
			$output = $this->get_meta_info().$this->get_meta_info_more();
			return $output;
		}else{
			$meta_array = array(
				'category' => $this->get_category(),
				'date'     => $this->get_date(),
				'author'   => $this->get_author(),
				'view'     => $this->get_views(),
				'comment'  => $this->get_comments(),
				);
				foreach( $meta_array as $key => $val ) {
					if( empty( $val ) ) {
						unset($meta_array[$key]);
					}
				}
				$format = $this->html_format['meta_info_format'];
			if( $this->show_widget_meta ){
				$output = sprintf( $format, $this->get_date(), $this->get_comments(), $this->get_views());
				return $output;
			}else{
				if( isset($this->html_format['meta_seperate'])) {
					$seperate = $this->html_format['meta_seperate'];
				}
				$output= implode( $seperate, $meta_array );
				if( $output ) {
					$output = sprintf( $format, $output );
				}
				return $output;
			}
		}
	}
	
	public function add_custom_css() {
		$css = '';
		if( $this->attributes['hover_color'] ) {
			if( $this->attributes['style'] == '01' ){
				$css .= '.%1$s .block-1 .block-content .readmore-icons,
								.%1$s .block-1 .block-content::before{ background-color: %2$s;}
								.%1$s .block-1 .block-content .title:hover{ color: %2$s;}' ."\n";
			}
			else{
				$css .= '.%1$s .block-2 .block-content::before,
								.%1$s .block-2 .block-content .title:before{ background-color: %2$s;}
								.%1$s .block-2 .block-content .readmore:hover,
								.%1$s .block-2 .block-content .title:hover{ color: %2$s;}' ."\n";
			}
		}
		if( $this->attributes['date_color'] ) {
			$css .= '.%1$s .block-1 .block-info .block .link.date{ color: %3$s;}';
			$css .= '.%1$s .item .label-block{ color: %3$s;}';
		}
		if( $this->attributes['date_bg_color'] ) {
			$css .= '.%1$s .item .label-block{ background-color: %4$s;}';
		}
		if( $css ) {
			$css = sprintf( $css,
					$this->attributes['block-class'],
					esc_attr($this->attributes['hover_color']),
					esc_attr($this->attributes['date_color']),
					esc_attr($this->attributes['date_bg_color'])
			);
			do_action( BUILDPLUS_CORE_ADD_INLINE_CSS, $css );
		}
	}
	private function get_thumb_size() {
		$params = Buildplus_Core_Params::block_image_size();
		if( !isset($params[$this->attributes['layout']]) || !empty($this->attributes['style']) ) {
			$this->attributes['thumb-size'] = array(
				'large'          => 'post-thumbnail',
				'no-image-large' => 'thumb-no-image.gif',
			);
		}
		else {
			$this->attributes['thumb-size'] = Buildplus_Core_Util::get_thumb_size( $params[$this->attributes['layout']], $this->attributes );
		}
	}
	private function get_block_setting( $atts ) {
		$displays = array(
			'show_category'        => '',
			'show_tag'             => '',
			'show_comments'        => '',
			'show_views'           => '',
			'show_date'            => '',
			'show_author'          => '',
			'show_excerpt'         => '',
			'show_meta'            => '',
			'content_length'       => '',
			'title_length'         => '',
		);
		$displays['layout'] = Buildplus_Core::get_value($atts, 'layout');
		if( function_exists( 'buildplus_get_blog_options')){
			buildplus_get_blog_options( $displays );
		}
		foreach( $displays as $key => $val ) {
			if( ! isset($atts[$key]) ) {
				$atts[$key] = $displays[$key];
			} else if( ($atts[$key] == 'no' || $atts[$key] == 'hide') ) {
				$atts[$key] = 'hide';
			}
		}
		
		return $atts;
	}
	private function get_ribbon_post_date() {
		$format = '<div class="label-block">
						<div class="text-1">%1$s</div>
						<div class="text-2">%2$s</div>
						<a href="%3$s" class="link-date"></a>
					</div>';
		$day    = get_the_date(esc_html_x('d.m','daily posts date format', 'slz-core'));
		$year   = get_the_time(esc_html_x('Y','yearly posts date format', 'slz-core'));
		return sprintf( $format, $day, $year, esc_url( $this->permalink ) );
	}
	public function get_button() {
		$format = $this->html_format['more_btn_format'];
		return sprintf($format, $this->permalink, $this->attributes['button_text'] );
	}
	/**-------------------------Render html--------------------------*/
	/**
	 * Render carousel
	 * 
	 * @param array $options
	 */
	public function render_carousel( $options = array() ) {
		$this->html_format = $this->set_post_options_defaults( $options );
		if( $this->query->have_posts() ) {
			while ( $this->query->have_posts() ) {
				$this->query->the_post();
				$this->loop_index();
				$post_class = $this->get_post_class();
				$excerpt = $this->get_excerpt();
				$ribbon_date = '';
				if( $this->attributes['show_date'] == 'ribbon') {
					$ribbon_date = $this->get_ribbon_post_date();
				}
				printf( $this->html_format['html_format'],
						$this->get_featured_by_format( 'large', $this->html_format ),
						$this->get_meta_info(),
						$this->get_title(),
						$excerpt,
						$this->get_button(),
						$post_class,
						$this->attributes['no_image_class'],
						$ribbon_date
				);
			}// end while
			// reset query
			wp_reset_postdata();
		}
	}
	/**
	 * Render list.
	 *
	 */
	public function render_list( $options = array() ) {
		$this->html_format = $this->set_post_options_defaults( $options );
		if( $this->query->have_posts() ) {
			while ( $this->query->have_posts() ) {
				$this->query->the_post();
				$this->loop_index();
				$post_class = $this->get_post_class();
				$excerpt = $this->get_content($this->html_format);
				if( $this->attributes['show_content'] == 'content' ){
					$excerpt = $this->get_content($this->html_format);
				} else {
					$excerpt = $this->get_excerpt($this->html_format);
				}
				$ribbon_date = '';
				if( $this->attributes['show_date'] == 'ribbon') {
					$ribbon_date = $this->get_ribbon_post_date();
				}
				printf( $this->html_format['html_format'],
						$this->get_featured_by_format( 'large', $this->html_format ),
						$this->get_meta_info(),
						$this->get_title(),
						$excerpt,
						$this->get_button(),
						$post_class,
						$this->attributes['no_image_class'],
						$ribbon_date
				);
			}// end while
			// reset query
			wp_reset_postdata();
			
		}
	}
}