<?php
class Buildplus_Core_Item_List {
	public $attributes;
	public $uniq;
	public $html_format;
	
	public function __construct() {
		$this->meta_attributes();
		$this->uniq = 'item-list-' . Buildplus_Core::make_id();
	}
	
	public function meta_attributes() {
		$default = array(
			'style'                 => '1',
			'icon'					=> '',
			'icon_type'      		=> '',
			'icon_fw'        		=> '',
			'icon_ex'        		=> '',
			'group_list'         	=> '',
			'group_values'          => '',
			'desc_color'			=> '',
			'icon_color'			=> '',
			'extra_class'			=> ''
		);
		$this->attributes = $default;
	}
	public function init( $atts, $content = null ) {
		$this->attributes = Buildplus_Core::set_shortcode_defaults( $this->attributes, $atts);
		if( function_exists( 'wpb_js_remove_wpautop' ) ) {
			$content = wpb_js_remove_wpautop( $content, true );
		}
		$this->attributes['content'] = $content;
		if( !empty( $this->attributes['group_list'] ) ){
			$item_content = vc_param_group_parse_atts( $this->attributes['group_list'] );
			$this->attributes['group_values'] = $item_content;
		}
		if ( !empty($this->attributes['icon_type']) && $this->attributes['icon_type'] == '02' && !empty( $this->attributes['icon_fw'] ) ) {
			$this->attributes['icon'] = $this->attributes['icon_fw'];
		}
		if(empty($this->attributes['icon_type']) && !empty($this->attributes['icon_ex'])){
			$this->attributes['icon'] = $this->attributes['icon_ex'];
		}
	}
	/*-------------------- >> General Functions << --------------------*/
	public function parse_param_group( $param ){
		$param_def = array(
			'description' => '',
		);
		$param = array_merge($param_def, $param);
		return $param;
	}
	public function get_icon( $value ) {
		$output = '';
		if( !empty($value) ) {
			$format = $this->html_format['icon_format'];
			if( $format ) {
				//1: icon
				$output = sprintf( $format, esc_attr($value) );
			}
		}
		return $output;
	}
	public function get_description( $value ) {
		$output = '';
		if( !empty($value) ) {
			$format = $this->html_format['desc_format'];
			if( $format ) {
				//1: content
				$output = sprintf( $format, wp_kses_post(nl2br($value)) );
			}
		}
		return $output;
	}
	public function setting_html( &$options = array() ){
		$default = array(
			'icon_format'  => '<i class="icons fa fa-%1$s"></i>',
			'desc_format'  => '<div class="text">%1$s</div>',
		);
		$this->html_format = array_merge( $default, $options);
	}
	/*-------------------- >> Css Functions << --------------------*/
	public function add_custom_css() {
		$custom_css = '';
		if( !empty( $this->attributes['icon_color'] ) ){
			$custom_css .= '.%1$s .icons{color:%2$s;}'."\n";
		}
		if( !empty( $this->attributes['desc_color'] ) ){
			$custom_css .= '.%1$s .text {color:%3$s;}'."\n";
		}
		if ( !empty( $custom_css ) ) {
			$custom_css = sprintf($custom_css,
					esc_attr($this->uniq),
					esc_attr($this->attributes['icon_color']),
					esc_attr($this->attributes['desc_color'])
			);
			do_action( BUILDPLUS_CORE_ADD_INLINE_CSS, $custom_css );
		}
	}
	/*-------------------- >> Render Html << -------------------------*/
	public function render_sc( $html_options ) {;
		$this->setting_html( $html_options );
		if( $this->attributes['group_values'] ) {
			foreach( $this->attributes['group_values'] as $item ) {
				if( $item) {
					$item = $this->parse_param_group($item);
					if(!empty( $item['description'] ) ) {
						printf($this->html_format['html_format'],
								$this->get_icon($this->attributes['icon']),
								$this->get_description($item['description'])
						);
					}
				}
			}
			$this->add_custom_css();
		}
	}
}