<?php
class Buildplus_Core_Testimonial extends Buildplus_Core_Custom_Post_Model {

	private $post_type = 'buildplus_testi';
	private $post_taxonomy = 'buildplus_testi_cat';
	
	public function __construct() {
		$this->meta_attributes();
		$this->set_meta_attributes();
		$this->post_meta_prefix = $this->post_type . '_';
		$this->taxonomy_cat = $this->post_taxonomy;
		$this->uniq_id = 'block-' . BuildPlus_Core::make_id();
		$this->html_format = $this->set_default_options();
	}
	public function meta_attributes() {
		$meta_atts = array(
			'thumbnail'     => '',
			'position'      => '',
			'company'       => '',
			'signature'     => ''
		);
		$this->post_meta_atts = $meta_atts;
	}
	public function set_meta_attributes() {
		$meta_arr = array();
		$meta_label_arr = array();
		foreach( $this->post_meta_atts as $att => $name ){
			$key = $att;
			$meta_arr[$key] = '';
			$meta_label_arr[$key] = $name;
		}
		$this->post_meta_def = $meta_arr;
		$this->post_meta = $meta_arr;
		$this->post_meta_label = $meta_label_arr;
	}
	public function init( $atts = array(), $query_args = array() ) {
		// set attributes
		$default_atts = array(
			'layout'            => 'testimonial',
			'limit_post'        => '',
			'offset_post'       => '',
			'sort_by'           => '',
			'post_id'           => '',
			'style'             => '1',
			'category_list'     => '',
			'values'            => '',
			'extra_class'       => '',
			'icon_color'        => '',
			'show_sign'         => 'yes',
			'title_color'       => '',
			'position_color'    => '',
			'background_color'  => '',
			'description_color' => '',
			'title_hover_color' => '',
			'separator_line'    => 'false',
			'separator_color'   => '',
			'dot_color'         => '',
			'dot_active_color'  => '',
			'arrow_color'       => '',
			'arrow_hv_color'    => '',
			'arrow_bg_color'    => '',
			'arrow_bg_hv_color' => ''
		);
		$atts = array_merge( $default_atts, $atts );
		$this->attributes = $atts;
		if( empty( $this->attributes['category_slug'] ) ) {
			list( $this->attributes['category_list_parse'], $this->attributes['category_slug'] ) = Buildplus_Core_Util::get_list_vc_param_group( $atts, 'category_list', 'category_slug' );
		}
		$atts['post_id'] = $this->parse_cat_slug_to_post_id(
											$this->taxonomy_cat,
											$atts['category_list'],
											$this->post_type
										);
		// query
		$default_args = array(
			'post_type' => $this->post_type,
		);
		$query_args = array_merge( $default_args, $query_args );
		// setting
		$this->setting( $query_args);
	}
	public function setting( $query_args ){
		if( !isset( $this->attributes['uniq_id'] ) ) {
			$this->attributes['uniq_id'] = $this->post_type . '-' .Buildplus_Core::make_id();
		}
		// query
		$this->query = $this->get_query( $query_args, $this->attributes );
		$this->post_count = 0;
		if( $this->query->have_posts() ) {
			$this->post_count = $this->query->post_count;
		}
		// image size
		$this->get_thumb_size();
	}
	public function reset(){
		wp_reset_postdata();
	}
	/*-------------------- >> General Functions << --------------------*/
	public function get_position() {
		$format = $this->html_format['position_format'];
		$val = $this->post_meta['position'];
	
		$out = '';
		if( !empty($val) ) {
			$out = sprintf( $format, esc_html( $val ) );
		}
		return $out;
	}
	public function get_company() {
		$format = $this->html_format['company_format'];
		$val = $this->post_meta['company'];
	
		$out = '';
		if( !empty($val) ) {
			$out = sprintf( $format, esc_html( $val ) );
		}
		return $out;
	}
	public function get_signature() {
		$thumb_id = $this->post_meta['signature'];
		$thumb_img = $output = '';
		if( $thumb_id ) {
			$format = $this->html_format['signature_format'];
			$thumb_size = 'full';
			$thumb_class = Buildplus_Core::get_value( $this->html_format, 'signature_class', 'img-responsive' );
			$thumb_img = wp_get_attachment_image( $thumb_id, $thumb_size, false, array('class' => $thumb_class ) );
		}
		if( $thumb_img ) {
			$output = sprintf( $format, $thumb_img );
		}
		return $output;
	}
	public function get_meta_thumbnail($thumb_meta = '') {
		if ( !empty($thumb_meta) ) {
			$thumb_id = $this->post_meta[$thumb_meta];
		} else {
			return;
		}

		$format = $this->html_format['thumbnail_format'];
		if ( empty($format) ) {
			$format = '<a href="%2$s">%1$s</a>';
		}
		
		$thumb_class = Buildplus_Core::get_value( $this->html_format, 'thumbnail_class', ' img-responsive' );
		$thumb_size = 'buildplus-thumb-100x100';
		$helper = new Buildplus_Core_Helper();
		$helper->regenerate_attachment_sizes($thumb_id, $thumb_size);
		$thumb_img = wp_get_attachment_image( $thumb_id, $thumb_size, false, array('class' => $thumb_class ) );
		$output = sprintf( $format, $thumb_img, $this->permalink );
		return $output;
	}
	public function set_default_options( &$html_options = array() ) {
		$defaults = array(
			'title_format'      => '<div class="testimonial-content"><span class="name">%1$s</span></div>',
			'content_format'    => '<div class="testimonial">%1$s</div>',
			'company_format'    => '<span class="company">%1$s</span>',
			'signature_format'  => '%1$s',
			'position_format'   => '<div class="position">%1$s</div>',
			'thumbnail_format'  => '<div class="testimonial-image">%1$s</div>',
			'image_format'      => '<div class="img-wrapper">%1$s</div>',
		);
		$html_options = array_merge( $defaults, $html_options );
		return $html_options;
	}
	public function get_thumb_size() {
		$params = Buildplus_Core_Params::get( 'block_image_size', $this->attributes['layout'] );
		$this->attributes['thumb-size'] = Buildplus_Core_Util::get_thumb_size( $params, $this->attributes );
	}
	/*-------------------- >> Render Html << -------------------------*/
	/**
	 * Render html.
	 *
	 * @param array $html_options
	 * @format: 1$ - content, 2$ - feature image, 3$ - title, 4$ - position, 5$ - signature, 6$ - post class, $7 - thumnail, $8 - permalink
	 */
	public function render_sc( $html_options = array() ) {
		$html_options = $this->set_default_options( $html_options );
		while ( $this->query->have_posts() ) {
			$this->query->the_post();
			$this->loop_index();
			$data = $this->get_content( $html_options );
			$html_options['title_format'] = '%1$s';
			$signature = '';
			$position  = $this->get_position(); 
			$title 	   = $this->get_title();
			if($this->attributes['show_sign'] == 'yes'){
				$signature = $this->get_signature();
			}
			if($this->attributes['style'] == 2){
				if(!empty($position) && !empty($title)){
					$position = ' - '.$position;
				}
			}
			else{
				if(!empty($title)){
					$html_options['title_format'] = '<a class="name" href="%2$s">%1$s</a>';
				}
			}
			printf( $html_options['html_format'],
					$data,
					$this->get_featured_image($html_options, 'large', false),
					$this->get_title( $html_options ),
					$position,
					$signature,
					$this->get_post_class(),
					$this->get_meta_thumbnail('thumbnail')
			);
		}
		$this->add_custom_css();
		$this->reset();
	}
	/*-------------------- >> Css Functions << --------------------*/
	public function add_custom_css() {
		$custom_css = '';
		if( !empty( $this->attributes['title_color'] ) ){
			$custom_css .= '.%1$s .testimonial-2 .name{color:%2$s;}'."\n";
			$custom_css .= '.%1$s .testimonial-1 .name{color:%2$s;}'."\n";
		}
		if( !empty( $this->attributes['icon_color'] ) ){
			$custom_css .= '.%1$s .testimonial-2 .content-wrapper::before{color:%3$s;opacity: 1;}' ."\n";
			$custom_css .= '.%1$s .testimonial-1 .testimonial-image::before{color:%3$s;}' ."\n";
		}
		if( !empty( $this->attributes['description_color'] ) ){
			$custom_css .= '.%1$s .testimonial-2 .testimonial{color:%4$s;}' ."\n";
			$custom_css .= '.%1$s .testimonial-1 .testimonial{color:%4$s;}' ."\n";
		}
		if( !empty( $this->attributes['position_color'] ) ){
			$custom_css .= '.%1$s .testimonial-2 .name .position{color:%5$s;}' ."\n";
			$custom_css .= '.%1$s .testimonial-1 .position{color:%5$s;}' ."\n";
		}
		if( !empty( $this->attributes['title_hover_color'] ) ){
			$custom_css .= '.%1$s .testimonial-1 .testimonial-content .name:hover{color:%6$s;}' ."\n";
		}
		if( !empty( $this->attributes['dot_color'] ) ){
			$custom_css .= '.%1$s .slick-dots li button:before{color:%7$s;}' ."\n";
		}
		if( !empty( $this->attributes['dot_active_color'] ) ){
			$custom_css .= '.%1$s .slick-dots li.slick-active button:before{color:%8$s;}' ."\n";
		}
		if( !empty( $this->attributes['arrow_color'] ) ){
			$custom_css .= '.%1$s .slick-arrow:before{color:%9$s;}' ."\n";
		}
		if( !empty( $this->attributes['arrow_hv_color'] ) ){
			$custom_css .= '.%1$s .slick-arrow:hover:before{color:%10$s;}' ."\n";
		}
		if( !empty( $this->attributes['arrow_bg_color'] ) ){
			$custom_css .= '.%1$s .slick-arrow{background-color:%11$s;}' ."\n";
		}
		if( !empty( $this->attributes['arrow_bg_hv_color'] ) ){
			$custom_css .= '.%1$s .slick-arrow:hover{background-color:%12$s;}' ."\n";
		}
		if ( !empty( $custom_css ) ) {
			$custom_css = sprintf($custom_css,
					esc_attr($this->attributes['uniq_id']),
					esc_attr($this->attributes['title_color']),
					esc_attr($this->attributes['icon_color']),
					esc_attr($this->attributes['description_color']),
					esc_attr($this->attributes['position_color']),
					esc_attr($this->attributes['title_hover_color']),
					esc_attr($this->attributes['dot_color']),
					esc_attr($this->attributes['dot_active_color']),
					esc_attr($this->attributes['arrow_color']),
					esc_attr($this->attributes['arrow_hv_color']),
					esc_attr($this->attributes['arrow_bg_color']),
					esc_attr($this->attributes['arrow_bg_hv_color'])
			);
			do_action( BUILDPLUS_CORE_ADD_INLINE_CSS, $custom_css );
		}
	}
}