<?php
Buildplus::load_class( 'front.Blog' );
$userID = get_query_var('author');
$limit_post = get_option('posts_per_page');
$model = new Buildplus_Blog;
$atts = array(
	'layout' 	  => 'author',
	'pagination'  => 'yes',
	'offset_post' => 0,
	'limit_post'  => $limit_post,
	'author' 	  => $userID,
	'show_author' => 'hide',
);
$model->init( $atts );
$html_format = 
'
<div class="author_post item %6$s">
	<div class="block-1">
		%1$s
		%2$s
		<div class="block-content">
			%3$s
			%4$s
			%5$s
		</div>
	</div>
</div>
';
if ( $model->query->have_posts() ) :
	$display_name = get_the_author_meta( 'display_name', $userID);
	printf('<div class="main-title margin-bottom-30"><h2 class=" author_article title">%s %s</h2></div>',
			esc_html( ucfirst($display_name) ),
			esc_html__( 'Articles', 'buildplus' ));?>
	<div class="slz-shortcode blog-content" data-item=".<?php echo esc_attr( $model->attributes['block-class'] ) ?>">
		<div class="list-block column-2"><?php 
			$post_options = array(
				'html_format' => $html_format,
				);
			$model->render_author( $post_options );?>
		</div>
		<div class="clearfix"></div>
		<?php 
		if( $model->attributes['pagination'] == 'yes' ) {
			echo ( $model->paging_nav( $model->query->max_num_pages, 2, $model->query) );
		}?>
	</div>
<?php endif; ?>