<?php
/**
 * Widget_About_Us class.
 * 
 * @since 1.0
 */

class Buildplus_Widget_Advertisement extends WP_Widget {

	public function __construct() {
		$widget_ops = array(
			'classname'   => 'widget_advertisement',
			'description' => esc_html__( "Add a advertisement for your's site.", 'buildplus')
		);
		parent::__construct( 'buildplus_advertisement', esc_html_x( 'SLZ: Advertisement', 'Advertisement widget', 'buildplus' ), $widget_ops );
	}

	function form( $instance ) {
		$default = array(
			'image'       => '',
			'alternate'   => '',
			'link_custom' =>'',
			'link_page'   =>'',
			'newtab'      =>'',
		);
		$model          = new Buildplus_Abstract();
		$instance       = wp_parse_args( (array) $instance, $default );
		$image          = esc_attr( $instance['image'] );
		$alternate      = esc_attr( $instance['alternate'] );
		$link_custom    = esc_attr( $instance['link_custom'] );
		$link_page      = esc_attr( $instance['link_page'] );
		$newtab         = esc_attr( $instance['newtab'] );
		$page_style     = get_pages();
		$newtab_arr     = array('yes' => esc_html__('Yes', 'buildplus'),'no' => esc_html__('No', 'buildplus'));
		?>

		<p>
			<label for="<?php echo esc_attr( $this->get_field_id('image') ); ?>"><?php esc_html_e('Advertisement Image:', 'buildplus');?>
			</label>
			<?php echo ( $model->single_image(esc_attr( $this->get_field_name('image') ),$image,array(
				'class'=>'wiget-upload-image',
				'data-rel' => esc_attr( $this->get_field_id('image')),
				'id'=> esc_attr( $this->get_field_id('image').'_id' ) ) ))?>
		</p>
		<p>
			<label for="<?php echo  esc_attr( $this->get_field_id('alternate') ); ?>"><?php esc_html_e('Alternate', 'buildplus');?></label>
			<input class="widefat" type="text" id="<?php echo esc_attr( $this->get_field_id('alternate') ); ?>" name="<?php echo esc_attr( $this->get_field_name('alternate') ); ?>" value="<?php echo esc_attr( $alternate ); ?>" />
		</p>
		<p>
			<label for="<?php echo  esc_attr( $this->get_field_id('link_custom') ); ?>"><?php esc_html_e('Link(Custom)', 'buildplus');?>
			</label>
			<input class="widefat" type="text" id="<?php echo esc_attr( $this->get_field_id('link_custom') ); ?>" name="<?php echo esc_attr( $this->get_field_name('link_custom') ); ?>" value="<?php echo esc_attr( $link_custom ); ?>" />
		</p>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'link_page' ) ); ?>"><?php esc_html_e( 'Or Link to Page', 'buildplus' );?></label>
			<select class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'link_page' ) );?>" name="<?php echo esc_attr( $this->get_field_name( 'link_page' ) );?>">
				<?php
					$result[''] = esc_html__('--All Pages--', 'buildplus');
					foreach( $page_style as $row ) {
						$result[$row->post_name] = $row->post_title;
					}
					foreach ($result as $k1 => $v1 ) {
						$selected = '';
						if( $link_page ==  $k1){
							$selected = 'selected';
						}  
						printf(
							'<option value="%s" %s>%s</option>',
							esc_attr($k1),
							$selected,
							esc_attr($v1)
						);
					}
				?>
			</select>
		</p>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_name( 'newtab' ) ); ?>"><?php esc_html_e( 'Open in new tab ?', 'buildplus' ); ?></label>
			<select class="widefat" id="<?php echo esc_attr( $this->get_field_id('newtab') ); ?>" name="<?php echo esc_attr( $this->get_field_name('newtab') ); ?>" >
				<?php
				foreach($newtab_arr as $k=>$v){
					if($newtab == $k) $selected = "selected";
					else $selected = "";
					echo '<option value="'.$k.'" '.$selected.'>'.$v.'</option>';
				}
				?>
			</select>
		</p>
		<?php
	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['image']       = strip_tags( $new_instance['image'] );
		$instance['alternate']   = strip_tags( $new_instance['alternate'] );
		$instance['link_custom'] = strip_tags( $new_instance['link_custom'] );
		$instance['link_page']   = strip_tags( $new_instance['link_page'] );
		$instance['newtab']      = strip_tags( $new_instance['newtab'] );
		return $instance;
	}

	function widget( $args, $instance ) {
		extract( $args );
		$html = $link = '';
		$default = array(
			'image'         => '',
			'link_custom'   => '',
			'link_page'     => '',
			'newtab'        => ''
		);
		$instance = wp_parse_args( (array) $instance, $default );
		$image = $instance['image'];
		$link_custom = $instance['link_custom'];
		$link_page = $instance['link_page'];
		$newtab = $instance['newtab'];
		$alternate =  $instance['alternate'];
		$image_url = wp_get_attachment_url($image);

		if(!empty($image_url)){
			if(!empty($link_custom)){
			$link = $link_custom;
			}else if(!empty($link_page)){
				$link = get_page_link(get_page_by_path($link_page));
			}
			if(empty($link)){
				$html = '<img alt="'.esc_attr($alternate).'" src="'.esc_url($image_url).'"  class="img-responsive">';
			}else{
				//new tab
				$newtab = ($newtab == 'yes') ? 'target=_blank':'';
				$html = '<a '.esc_attr($newtab).' href="'.esc_url($link).'"><img src="'.esc_url($image_url).'" alt="'.esc_attr($alternate).'" class="img-responsive"></a>';
			}
			
		}
		echo wp_kses_post($before_widget); ?>
		<div class="widget banner-adv-widget">
			<div class="banner-adv-inner">
				<?php echo wp_kses_post($html);?>
			</div>
		</div>
		<?php echo wp_kses_post($after_widget);
	}
}