<?php
/**
 * Widget_Project_Attributes class.
 * 
 * @since 1.0
 */

class Buildplus_Widget_Project_Attributes extends WP_Widget {

	public function __construct() {
		$widget_ops = array( 'classname' => 'widget_buildplus_project_attributes', 'description' => esc_html__( "List project attributes in project detail page.", 'buildplus' ) );
		parent::__construct( 'buildplus_project_attributes', esc_html_x( 'SLZ: Project Attributes', 'Projects Attributes widget', 'buildplus' ), $widget_ops );
	}

	function form( $instance ) {
		$default = array( 
			'title'      => esc_html__( "Project Details", 'buildplus' ),
			'project_id' => '',
		);
		$instance   = wp_parse_args( (array) $instance, $default );
		$title      = $instance['title'];
		$project_id = $instance['project_id'];
		?>
		<p>
			<label for="<?php echo  esc_attr( $this->get_field_id('title') ); ?>"><?php esc_html_e( 'Title', 'buildplus' );?></label>
			<input class="widefat" type="text" id="<?php echo esc_attr( $this->get_field_id('title') ); ?>" name="<?php echo esc_attr( $this->get_field_name('title') ); ?>" value="<?php echo esc_attr( $title ); ?>" />
		</p>
		<p>
			<label for="<?php echo  esc_attr( $this->get_field_id('project_id') ); ?>"><?php esc_html_e( 'Enter Project ID', 'buildplus' );?></label>
			<input class="widefat" type="text" id="<?php echo esc_attr( $this->get_field_id('project_id') ); ?>" name="<?php echo esc_attr( $this->get_field_name('project_id') ); ?>" value="<?php echo esc_attr( $project_id ); ?>" />
		</p>
		<?php
	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$params = array(
			'title',
			'project_id',
		);
		foreach( $params as $item ) {
			$instance[$item] = strip_tags( $new_instance[$item] );
		}
		return $instance;
	}

	function widget( $args, $instance ) {
		extract( $args );
		$default  = array(
			'title'        => '',
			'project_id'   => '',
		);
		$instance = wp_parse_args( (array) $instance, $default ); 
		extract( $instance );
		$atts = $instance;
		
		if( is_single() && get_post_type() == 'buildplus_project' ) {
			$project_id = get_the_ID();
		}
		$html_options = array(
			'html_format' => '<div class="item %3$s"><span class="label">'.esc_html_x('%1$s: ', 'Name of project attributes', 'buildplus').'</span><span>%2$s</span></div>'
		);
		echo wp_kses_post( $before_widget );?>
			<div class="widget project-details-widget">
			<?php
				if( !empty( $title ) ) {
					echo wp_kses_post( $before_title );
					echo esc_html( $title );
					echo wp_kses_post( $after_title );
				}
				if( !empty($project_id)) {
					$args = array(
						'p' => $project_id,
					);
					$model = new Buildplus_Core_Project();
					$model->init( $atts, $args );
			?>
					<div class="list-details">
						<?php $model->render_attr_widget($html_options);?>
					</div><?php 
				}?>
			</div><?php 
		echo wp_kses_post( $after_widget );
	}
}