<?php

// Set post view
add_action('wp_head', 'buildplus_postview_set');
if( ! function_exists( 'buildplus_postview_set' ) ) :

	function buildplus_postview_set() {
		global $post;
		$post_types = array('post');
		if( $post ) {
			$post_id = $post->ID;
			if( in_array(get_post_type(), $post_types) && is_single() ) {
				$count_key = 'buildplus_postview_number';
				$count = get_post_meta( $post_id, $count_key, true );
				if( $count == '' ) {
					$count = 0;
					delete_post_meta( $post_id, $count_key );
					add_post_meta( $post_id, $count_key, '0' );
				} else {
					$count++;
					update_post_meta( $post_id, $count_key, $count );
				}
			}
		}
	}
endif;

// Get post view
if( ! function_exists( 'buildplus_postview_get' ) ) :

	function buildplus_postview_get( $post_id ) {
		$view_text = esc_html__( 'view', 'buildplus' );
		$count_key = 'buildplus_postview_number';
		$count = get_post_meta( $post_id, $count_key, true );
		$res = '';
		if($count == '') {
			delete_post_meta( $post_id, $count_key );
			add_post_meta( $post_id, $count_key, '0' );
			$res = 0;
		} else {
			$res = $count;
		}
		return $res;
	}
endif;

//-----------------------------------------------
if ( ! function_exists( 'buildplus_is_custom_post_type_archive' ) ) :
	function buildplus_is_custom_post_type_archive() {
		if( is_post_type_archive('buildplus_project') || is_tax( 'buildplus_project_cat' ) || is_tax( 'buildplus_project_location' ) ) {
			return 1;
		} else if( is_post_type_archive('buildplus_service') || is_tax( 'buildplus_service_cat' ) ) {
			return 2;
		} else if( is_post_type_archive('buildplus_team') || is_tax( 'buildplus_team_cat' ) ) {
			return 3;
		} else if( is_post_type_archive('buildplus_gallery') || is_tax( 'buildplus_gallery_cat' )
				|| is_post_type_archive('buildplus_testi')   || is_tax( 'buildplus_testi_cat' )
				|| is_post_type_archive('buildplus_partner') || is_tax( 'buildplus_partner_cat' )) {
			return 99;
		}
		return false;
	}
endif;

// Breadcrumb
if ( ! function_exists( 'buildplus_get_breadcrumb' ) ) :
	function buildplus_get_breadcrumb()
	{
		if ( BUILDPLUS_WOOCOMMERCE_ACTIVE && get_post_type() == 'product' ) 
		{
			$breadcrumbs = new WC_Breadcrumb();
			$breadcrumbs->add_crumb( esc_html_x( 'Home', 'breadcrumb', 'buildplus' ), apply_filters( 'woocommerce_breadcrumb_home_url', esc_url( home_url('/') ) ) );
		} else {
			$breadcrumbs = new Buildplus_Breadcrumb();
			$breadcrumbs->add_crumb( esc_html_x( 'Home', 'breadcrumb', 'buildplus' ), apply_filters( 'buildplus_breadcrumb_home_url', esc_url( home_url('/') ) ) );
		}
		return $breadcrumbs->generate();
	}
endif;

if( !function_exists('buildplus_regex') ) :

	function buildplus_regex($string, $pattern = false, $start = "^", $end = "")
	{
		if(!$pattern) return false;

		if($pattern == "url")
		{
			$pattern = "!$start((https?|ftp)://(-\.)?([^\s/?\.#-]+\.?)+(/[^\s]*)?)$end!";
		}
		else if($pattern == "mail")
		{
			$pattern = "!$start\w[\w|\.|\-]+@\w[\w|\.|\-]+\.[a-zA-Z]{2,4}$end!";
		}
		else if($pattern == "image")
		{
			$pattern = "!$start(https?(?://([^/?#]*))?([^?#]*?\.(?:jpg|gif|png)))$end!";
		}
		else if(strpos($pattern,"<") === 0)
		{
			$pattern = str_replace('<',"",$pattern);
			$pattern = str_replace('>',"",$pattern);

			if(strpos($pattern,"/") !== 0) { $close = "\/>"; $pattern = str_replace('/',"",$pattern); }
			$pattern = trim($pattern);
			if(!isset($close)) $close = "<\/".$pattern.">";

			$pattern = "!$start\<$pattern.+?$close!";

		}

		preg_match($pattern, $string, $result);

		if(empty($result[0]))
		{
			return false;
		}
		else
		{
			return $result;
		}

	}
endif;

// Paging
if(!function_exists('buildplus_paging_nav')) :
	/**
	 * Displays a page pagination if more posts are available than can be displayed on one page
	 * @param string $pages pass the number of pages instead of letting the script check the gobal paged var
	 * @return string $output returns the pagination html code
	 */
	function buildplus_paging_nav( $pages = '', $current_query = '' )
	{
		global $paged;
		if( $current_query == '' ) {
			if( empty( $paged ) ) $paged = 1;
		} else {
			$paged = $current_query->query_vars['paged'];
		}
		$prev = $paged - 1;
		$next = $paged + 1;
		$range = 1; // only edit this if you want to show more page-links
		$showitems = ($range * 2);
		
		if($pages == '') {
			global $wp_query;
			$pages = $wp_query->max_num_pages;
			if( ! $pages ) {
				$pages = 1;
			}
		}
		$method = "get_pagenum_link";
		if(is_single()) {
			$method = 'buildplus_post_pagination_link';
		}
		$output = $output_page = $showpages = $disable = '';
		$page_format = '<li><a href="%2$s" class="link" >%1$s</a></li>';
		if( 1 != $pages ) {
			$output_page .= '<ul class="pagination">';
			// prev
			if( $paged == 1 ) {
				$disable = ' hide';
			}
			$output_page .= '<li><a href="'.$method($prev).'" class="link previous">'.esc_html__('previous', 'buildplus').'</a></li>';
			// first pages
			if( $paged > $showitems ) {
				$output_page .= sprintf( $page_format, 1, $method(1) );
			}
			// show ...
			if( $paged - $range > $showitems && $paged - $range > 2 ) {
				$output_page .= sprintf( $page_format, '&bull;&bull;&bull;', $method($paged - $range - 1) );'<li><a href="'.$method($prev).'">&bull;&bull;&bull;</a></li>';
			}
			for ($i=1; $i <= $pages; $i++) {
				if (1 != $pages &&( !($i >= $paged+$showitems || $i <= $paged-$showitems) || $pages <= $showitems )) {
					if( $paged == $i ) {
						$output_page .= '<li><span class="link active">'.$i.'</span></li>';
					} else {
						$output_page .= sprintf( $page_format, $i, $method($i) );
					}
					$showpages = $i;
				}
			}
			// show ...
			if( $paged < $pages-1 && $showpages < $pages -1 ){
				$showpages = $showpages + 1;
				$output_page .= sprintf( $page_format, '&bull;&bull;&bull;', $method($showpages) );
			}
			// end pages
			if( $paged < $pages && $showpages < $pages ) {
				$output_page .= sprintf( $page_format, $pages, $method($pages) );
			}
			//next
			$disable = '';
			if( $paged == $pages ) {
				$disable = ' hide';
			}
			$output_page .= '<li><a href="'.$method($next).'" class="link next">'.esc_html__('next', 'buildplus').'</a></li>';
			$output_page .= '</ul>'."\n";
			$output = sprintf('<div class="pagination-wrapper undefined margin-top-50">%1$s</div>', $output_page );
		}
		return $output;
	}

	function buildplus_post_pagination_link($link)
	{
		$url =  preg_replace('!">$!','',_wp_link_page($link));
		$url =  preg_replace('!^<a href="!','',$url);
		return $url;
	}

	function buildplus_get_pagenum_link( $pagenum = 1, $escape = true, $base = null) {
		global $wp_rewrite;

		$pagenum = (int) $pagenum;
	
		$request = $base ? remove_query_arg( 'paged', $base ) : remove_query_arg( 'paged' );
	
		$home_root = parse_url(home_url('/'));
		$home_root = ( isset($home_root['path']) ) ? $home_root['path'] : '';
		$home_root = preg_quote( $home_root, '|' );
	
		$request = preg_replace('|^'. $home_root . '|i', '', $request);
		$request = preg_replace('|^/+|', '', $request);
	
		if ( !$wp_rewrite->using_permalinks() || is_admin() ) {
			$base = trailingslashit( home_url('/') );
	
			if ( $pagenum > 1 ) {
				$result = add_query_arg( 'paged', $pagenum, $base . $request );
			} else {
				$result = $base . $request;
			}
		} else {
			$qs_regex = '|\?.*?$|';
			preg_match( $qs_regex, $request, $qs_match );
	
			if ( !empty( $qs_match[0] ) ) {
				$query_string = $qs_match[0];
				$request = preg_replace( $qs_regex, '', $request );
			} else {
				$query_string = '';
			}
	
			$request = preg_replace( "|$wp_rewrite->pagination_base/\d+/?$|", '', $request);
			$request = preg_replace( '|^' . preg_quote( $wp_rewrite->index, '|' ) . '|i', '', $request);
			$request = ltrim($request, '/');
	
			$base = trailingslashit( home_url('/') );
	
			if ( $wp_rewrite->using_index_permalinks() && ( $pagenum > 1 || '' != $request ) )
				$base .= $wp_rewrite->index . '/';
	
			if ( $pagenum > 1 ) {
				$request = ( ( !empty( $request ) ) ? trailingslashit( $request ) : $request ) . user_trailingslashit( $wp_rewrite->pagination_base . "/" . $pagenum, 'paged' );
			}
	
			$result = $base . $request . $query_string;
		}
	
		/**
		 * Filter the page number link for the current request.
		 *
		 * @since 2.5.0
		 *
		 * @param string $result The page number link.
		 */
		$result = apply_filters( 'get_pagenum_link', $result );
	
		if ( $escape )
			return esc_url( $result );
		else
			return esc_url_raw( $result );
	}
endif;

// Post Navigation
if ( ! function_exists( 'buildplus_post_nav' ) ) :
	/**
	 * Display navigation to next/previous post when applicable.
	*
	*/
	function buildplus_post_nav() {
		global $post;
		// Don't print empty markup if there's nowhere to navigate.
		$previous = ( is_attachment() ) ? get_post( $post->post_parent ) : get_adjacent_post( false, '', true );
		$next     = get_adjacent_post( false, '', false );
		if ( ! $next && ! $previous )
			return;
		?>
		<nav class="post-navigation row" >
			<div class="col-md-12">
				<div class="nav-links">
					<div class="pull-left prev-post">
					<?php previous_post_link( '%link', _x( '<span class="meta-nav">&larr;</span> %title', 'Previous post link', 'buildplus' ) ); ?>
					</div>
					<div class="pull-right next-post">
					<?php next_post_link( '%link', _x( '%title <span class="meta-nav">&rarr;</span>', 'Next post link', 'buildplus' ) ); ?>
					</div>
				</div><!-- .nav-links -->
			</div>
		</nav><!-- .navigation -->
		<?php
	}
endif;

// Get link of blog content ( post-format: link)
if ( ! function_exists( 'buildplus_get_link_url' ) ) :
	/**
	 * Return the post URL.
	 *
	 * @uses get_url_in_content() to get the URL in the post meta (if it exists) or
	 * the first link found in the post content.
	 *
	 * Falls back to the post permalink if no URL is found in the post.
	 *
	 *
	 * @return string The Link format URL.
	 */
	function buildplus_get_link_url() {
		$has_url = '';
		if( get_post_format() == 'link') {
			$content = get_the_content();
			$has_url = get_url_in_content( $content );
		}
		return ( $has_url ) ? $has_url : apply_filters( 'the_permalink', get_permalink() );
	}
endif;

// Get Format Date
if ( ! function_exists( 'buildplus_post_date' ) ) :
	function buildplus_post_date() {
		$format_string = '<div class="block"><span class="link">%3$s</span><a href="%2$s" class="link date">%1$s</a></div>';
		$output = sprintf( $format_string, get_the_date(), esc_url( buildplus_get_link_url() ), esc_html__('Date:', 'buildplus') );
		return $output;
	}
endif;
if ( ! function_exists( 'buildplus_ribbon_post_date' ) ) :
	function buildplus_ribbon_post_date() {
		$format = '<div class="label-block">
						<div class="text-1">%1$s</div>
						<div class="text-2">%2$s</div>
						<a href="%3$s" class="link-date"></a>
					</div>';
		$day    = get_the_date(esc_html_x('d.m','daily posts date format', 'buildplus'));
		$year   = get_the_time(esc_html_x('Y','yearly posts date format', 'buildplus'));
		$output = sprintf( $format, $day, $year, esc_url( buildplus_get_link_url() ) );
		return $output;
	}
endif;

// Get css to show/hide sidebar
if ( ! function_exists( 'buildplus_get_container_css' ) ) :
	function buildplus_get_container_css( $show_sidebar = false ) {
		/* Global variable from theme option */
		do_action('buildplus_page_options');
		$def_sidebar = Buildplus::get_option('slz-sidebar-layout');
		$def_sidebar_id = Buildplus::get_option('slz-sidebar');
		$post_type = get_post_type();
		$sidebar = $sidebar_id = $has_sidebar = '';
		if( is_single() ) {
			if( $post_type == 'product' ) {
				$sidebar = Buildplus::get_option('slz-shop-sidebar-layout');
				$sidebar_id = Buildplus::get_option('slz-shop-sidebar');
			} elseif( $post_type == 'buildplus_project' ) {
				$sidebar = Buildplus::get_option('slz-project-sidebar-layout');
				$sidebar_id = Buildplus::get_option('slz-project-sidebar');
			} elseif( $post_type == 'buildplus_service' ) {
				$sidebar = Buildplus::get_option('slz-service-sidebar-layout');
				$sidebar_id = Buildplus::get_option('slz-service-sidebar');
			} elseif( $post_type == 'buildplus_team' ) {
				$sidebar = Buildplus::get_option('slz-team-sidebar-layout');
				$sidebar_id = Buildplus::get_option('slz-team-sidebar');
			}elseif( $post_type == 'post') {
				$sidebar = Buildplus::get_option('slz-blog-sidebar-layout');
				$sidebar_id = Buildplus::get_option('slz-blog-sidebar');
			}
		}else if( is_archive() ) {
			if( BUILDPLUS_WOOCOMMERCE_ACTIVE ) {
				if( !is_shop()  && $post_type == 'product' ) {
					$sidebar = Buildplus::get_option('slz-shop-sidebar-layout');
					$sidebar_id = Buildplus::get_option('slz-shop-sidebar');
				}
			}
			if( $post_type == 'buildplus_project' ){
				$sidebar = Buildplus::get_option('slz-project-ac-sidebar-layout');
				$sidebar_id = Buildplus::get_option('slz-project-ac-sidebar');
			}
			if( $post_type == 'buildplus_team') {
				$sidebar = Buildplus::get_option('slz-team-ac-sidebar-layout');
				$sidebar_id = Buildplus::get_option('slz-team-ac-sidebar');
			}
			if( $post_type == 'buildplus_service' ) {
				$sidebar = Buildplus::get_option('slz-service-ac-sidebar-layout');
				$sidebar_id = Buildplus::get_option('slz-service-ac-sidebar');
			}
			if( (is_author() || is_tax() || is_category() || is_archive()) && $post_type != 'product' ) {
				if( empty($sidebar)) {
					$sidebar = 'right';
				}
			}
		} else if( is_search() ) {
			$sidebar = 'right';
		}
		if( empty($sidebar)) {
			$sidebar = $def_sidebar;
		}
		if( empty($sidebar_id)) {
			$sidebar_id = $def_sidebar_id;
		}
		$content_css = 'col-md-8';
		$sidebar_css = 'col-md-4';

		if ( $sidebar == 'left' ) {
			$content_css = 'col-md-8 content-with-sidebar-left';
			$sidebar_css = 'col-md-4';
		} else if ( $sidebar == 'right' ) {
			$content_css = 'col-md-8 content-with-sidebar-right';
			$sidebar_css = 'col-md-4';
		} else {
			if( $show_sidebar ){
				$content_css = 'col-md-8 layout-left';
				$sidebar_css = 'col-md-4 layout-right';
			} else {
				$content_css = 'col-md-12';
				$sidebar_css = 'hide';
				$has_sidebar = 'none';
			}
		}
		$container_css = 'container';
		return array(
			'container_css' => $container_css,
			'content_css'   => $content_css,
			'sidebar_css'   => $sidebar_css,
			'sidebar'       => $sidebar,
			'sidebar_id'    => $sidebar_id,
			'has_sidebar'   => $has_sidebar
		);
	}
endif;

if ( ! function_exists( 'buildplus_get_sidebar' ) ) :
	function buildplus_get_sidebar( $sidebar_id ) {
		if( empty($sidebar_id) ) {
			get_sidebar();
		} else {
			if ( is_active_sidebar( $sidebar_id ) ) {
				echo '<div class="sidebar-wrapper">';
				dynamic_sidebar( $sidebar_id );
				echo '</div>';
			}
		}
	}
endif;
/**
 * Custom callback function, see comments.php
 * 
 */
if ( ! function_exists( 'buildplus_display_comments' ) ) : 
	function buildplus_display_comments( $comment, $args, $depth ) {
		$GLOBALS['comment'] = $comment;
		$comment_id = get_comment_ID();
		$url	= get_comment_author_url( $comment_id );
		$author = get_comment_author( $comment_id );
		?>
		<li class="parent" id="comment-<?php echo get_comment_ID() ?>">
			<div class="comment-item">
				<div class="comment-left">
					<a href="<?php echo esc_url($url);?>" class="media-image"><?php echo get_avatar($comment, 70) ?>
					</a>
				</div>
				<div class="comment-right">
					 <div class="meta">
						<div class="meta-info author">
					   	 <?php 
							if ( empty( $url ) || 'http://' == $url ){
								printf('<a class="link" title="%1$s">%1$s</a>',
									esc_html(ucfirst($author))
								);
								
							}else {
								printf('<a class="link" href="%1$s" title="%2$s">%2$s</a>',
										esc_url($url),
										esc_html(ucfirst($author))
								);
							}
						?>
						</div>
						<div class="meta-info time"><?php echo esc_html__('Date:','buildplus')?><a class="link"><?php echo buildplus_display_comments_date(); ?></a>
						</div>
						<?php
						$comment_reply_link_args = array(
							'depth'  => $depth, 
							'before' => '',
							'after'  => ''
						);
						comment_reply_link( array_merge ( $args, $comment_reply_link_args ) ); 
						?>
					</div>
					<div class="des">
						<?php comment_text() ?>
					</div>
				</div>
			</div>
		<!-- </li> no open -->
		<?php
	}
endif;

if ( ! function_exists( 'buildplus_display_comments_date' ) ) : 
	function buildplus_display_comments_date() {
		$cmt_time = get_comment_time( 'U' );
		$current_time = current_time( 'timestamp' );
		$subtract_time = $current_time - $cmt_time;
		$days = ( 60*60*24*5 ); // 5 days
		if( $subtract_time > $days ){
			$res = get_comment_date();
		}
		else {
			$res = human_time_diff( get_comment_time( 'U' ), current_time( 'timestamp' ) );
			$res .= esc_html__( ' ago', 'buildplus' );
		}
		return $res;
	}
endif;
/*move field of comment form*/
if ( ! function_exists( 'buildplus_move_comment_field' ) ) : 
	function buildplus_move_comment_field( $fields ) {
		$comment_field = $fields['comment'];
		unset( $fields['comment'] );
		$fields['comment'] = $comment_field;
		return $fields;
	}
	add_filter( 'comment_form_fields', 'buildplus_move_comment_field' );
endif;
/**
 * getPosts
 * @param  string $postType : post type
 * @param  array $params   	: aguments to get post
 * @return array            : posts terms and conditions
 */
if ( ! function_exists( 'buildplus_getPosts' ) ) : 
	function buildplus_getPosts($postType = null, $params = null, $wp_query = false) {
		$postType || $postType = 'post';
		$defaultParams = array(
			'post_type' => $postType,
			'posts_per_page' => -1,
			'suppress_filters' => false
		);
		($params != null && is_array($params)) && $defaultParams = array_merge($defaultParams, $params);
		return !$wp_query ? get_posts($defaultParams) : new WP_Query($defaultParams);
	}
endif;

/*
* getTermSimpleByPost (Related post or post tag)
* params:
* 		- post id
* 		- taxonomy: (taxonomy slug | category | post_tag)
* return: One term related by post
*/
if ( ! function_exists( 'buildplus_getTermSimpleByPost' ) ) : 
	function buildplus_getTermSimpleByPost( $postID, $taxonomy ) {
		if( empty( $postID ) && empty($taxonomy) ) {
			return;
		}
		$result = array();
		$terms = get_the_terms( $postID, $taxonomy );
		if ($terms && ! is_wp_error($terms)) {
			$result = current( $terms );
		}
		return (array)$result;
	}
endif;

//---- Change logo in login page
if ( ! function_exists( 'buildplus_login_style' ) ) {
	function buildplus_login_style() {
		$logo = Buildplus::get_option('slz-logo-header', 'url');
		if( $logo ) {
			$custom_css = '.login h1 a { 
								background : url('.esc_url($logo).') center no-repeat; 
								width: 100%; 
							}';
			wp_enqueue_style( 'buildplus-login-style', get_template_directory_uri()."/assets/admin/css/buildplus-admin-style.css", false, BUILDPLUS_THEME_VER, 'all' );
			wp_add_inline_style( 'buildplus-login-style', $custom_css );
		}
	}
}
add_action( 'login_enqueue_scripts', 'buildplus_login_style' );
if ( ! function_exists( 'buildplus_login_logo_url' ) ) {
	function buildplus_login_logo_url() {
		return esc_url(home_url('/'));
	}
}
add_filter( 'login_headerurl', 'buildplus_login_logo_url' );
//-------------------------Header Functions <<-----------------
//---- Add body class to special template
if ( ! function_exists( 'buildplus_add_body_class' ) ) {
	function buildplus_add_body_class( $classes)  {
		$classes[] = 'template-login';
		return $classes;
	}
}
//---- Check header page, using on header
if ( ! function_exists( 'buildplus_has_header_page' ) ) {
	function buildplus_has_header_page() {
		$header_page = true;
		if( is_page_template ( 'page-templates/page-coming-soon.php' ) ){
			$header_page = false;
			add_filter( 'body_class', 'buildplus_add_body_class' );
		}
		return $header_page;
	}
}
//---- Get body wraper class, using on header
if ( ! function_exists( 'buildplus_get_body_wrapper_class' ) ) {
	function buildplus_get_body_wrapper_class( $wapper_class = array() )  {
		//body-extra-class
		$wapper_class[] = Buildplus::get_option('slz-body-extra-class');
		//header layout
		$header = Buildplus::get_option('slz-header-layout');
		$header_class_mapping = array(
			'one'   => 'homepage-1',
			'two'   => 'homepage-2',
			'three' => 'homepage-3',
		);
		$header_class = 'homepage-1';
		if( isset($header_class_mapping[$header]) ) {
			$header_class = $header_class_mapping[$header];
		}
		$wapper_class[] = $header_class;
		
		//convert to string
		$wapper_class = array_map( 'esc_attr', $wapper_class );
		$wapper_class = join( ' ', array_unique( $wapper_class ) );
		return $wapper_class;
	}
}
//---- Get page class, using on header
if ( ! function_exists( 'buildplus_get_page_class' ) ) {
	function buildplus_get_page_class() {
		$page_class = '';
		//Layout boxed
		if ( Buildplus::get_option('slz-layout') == '2' ) {
			$page_class .= 'layout-boxed';
		}
		return $page_class;
	}
}
//------------------------>> Header Functions -----------------
//----Footer class
if ( ! function_exists( 'buildplus_get_footer_class' ) ) {
	function buildplus_get_footer_class() {
		$footer_col = Buildplus::get_option('slz-footer-col');
		$arr_footer_css = array(
			'footer_c1' => '',
			'footer_c2' => '',
			'footer_c3' => '',
			'footer_c4' => '',
		);
		if ( $footer_col == '2' ) {
			$arr_footer_css = array(
				'footer_c1' => 'col-md-6 col-sm-6',
				'footer_c2' => 'col-md-6 col-sm-6',
				'footer_c3' => 'hide',
				'footer_c4' => 'hide',
			);
		}
		if ( $footer_col == '3' ) {
			$arr_footer_css = array(
				'footer_c1' => 'col-md-4 col-sm-4',
				'footer_c2' => 'col-md-4 col-sm-4',
				'footer_c3' => 'col-md-4 col-sm-4',
				'footer_c4' => 'hide',
			);
		}
		if ( $footer_col == '4' ) {
			$arr_footer_css = array(
				'footer_c1' => 'col-md-3 prl col-sm-3',
				'footer_c2' => 'col-md-3 pll prl col-sm-3',
				'footer_c3' => 'col-md-3 pll col-sm-3',
				'footer_c4' => 'col-md-3 prl col-sm-3',
			);
		}
		return $arr_footer_css;
	}
}

if( !function_exists('buildplus_get_image_class')) {
	function buildplus_get_image_class(){
		$image_class = '';
		if(class_exists('Buildplus_Core_Video_Model')){
			$post_id = get_the_ID();
			$post_options = get_post_meta( $post_id, 'buildplus_feature_video', true);
			$youtube_id = Buildplus::get_value( $post_options, 'youtube_id' );
			$vimeo_id = Buildplus::get_value( $post_options, 'vimeo_id' );
			$upload_video = Buildplus::get_value( $post_options, 'upload_video' );
			if(empty($youtube_id) && empty($vimeo_id) && empty($upload_video) ){
				if(!has_post_thumbnail()){
					$image_class = 'no-image';
				}else{
					$image_class = 'feature_image';
				}
			}else{
				$image_class = 'feature_video';
			}
		}else{
			if(!has_post_thumbnail()){
					$image_class = 'no-image';
			}else{
				$image_class = 'feature_image';
			}
		}
		return $image_class;
	}
}
if( !function_exists('buildplus_get_blog_options')) {
	function buildplus_get_blog_options( &$display ){
		$blog_info = Buildplus_Config::get('blog_info');
		foreach($blog_info as $key => $options ){
			if( is_array($options) && count($options) == 3 ) {
				$arr = Buildplus::get_option($options[0], $options[1]);
				if( !isset($arr[$options[2]]) ){
					$display[$key] = 'hide';
				}
			}else if( !is_array($options) ){
				$display[$key]= Buildplus::get_option($options);
				if( $display[$key] == '0') {
					$display[$key] = 'hide';
				}
			}
		}
	}
}
if( !function_exists('buildplus_comming_soon_options')) {
	function buildplus_comming_soon_options( $field = '' ){
		$output = '';
		if( $field == 'slz-cms-logo' ) {
			$logo_url  = Buildplus::get_option( 'slz-cms-logo' );
			if( empty($logo_url)) {
				$logo_url = Buildplus::get_option( 'slz-logo-header', 'url' );
				if( is_numeric($logo_url) ){
					$logo_url = wp_get_attachment_url($logo_url);
				}
			}
			$output = $logo_url;
		} else {
			$output = Buildplus::get_option( $field );
		}
		return $output;
	}
}
if( !function_exists( 'buildplus_is_wishlist_page') ) {
	/**
	 * Check if current page is wishlist
	 *
	 * @return bool
	 */
	function buildplus_is_wishlist_page() {
		if( ! BUILDPLUS_WOOCOMMERCE_WISHLIST ) {
			return false;
		}
		$wishlist_page_id = yith_wcwl_object_id( get_option( 'yith_wcwl_wishlist_page_id' ) );
		if ( ! $wishlist_page_id ) {
			return false;
		}
		return is_page( $wishlist_page_id );
	}
}
if( !function_exists( 'buildplus_get_post_id') ) {
	function buildplus_get_post_id(){
		$post_id = get_the_ID();
		$shop_page = false;
		if( BUILDPLUS_WOOCOMMERCE_ACTIVE ) {
			if( is_shop() ) {
				$post_id = get_option('woocommerce_shop_page_id');
				$shop_page = true;
			} else if( is_cart() ) {
				$post_id = get_option('woocommerce_cart_page_id');
				$shop_page = true;
			} else if( is_account_page() ) {
				$post_id = get_option('woocommerce_myaccount_page_id');
				$shop_page = true;
			} else if( is_checkout() || is_checkout_pay_page() ) {
				$post_id = get_option('woocommerce_checkout_page_id');
				$shop_page = true;
			} else if( buildplus_is_wishlist_page() ) {
				$shop_page = true;
			}
		}
		return array($post_id, $shop_page);
	}
}
