<?php
/**
 * Theme init
 *
 * @author Swlabs
 * @package BuildPlus
 * @since 1.0
 */
// File Security Check
if ( ! defined( 'ABSPATH' ) ) { exit; }

// Theme setup
add_action('after_setup_theme', array( 'Buildplus', '[theme.Theme_Init, theme_setup]' ) );

require_once BUILDPLUS_FRAMEWORK_DIR . '/class-buildplus-loader.php';
require_once BUILDPLUS_FRAMEWORK_DIR . '/class-buildplus-config.php';
require_once BUILDPLUS_FRAMEWORK_DIR . '/class-buildplus-params.php';
require_once BUILDPLUS_FRAMEWORK_DIR . '/class-buildplus.php';
require_once BUILDPLUS_THEME_DIR . '/admin/admin-init.php';

/**
 * Theme option function
 */
require_once BUILDPLUS_FRAMEWORK_DIR . '/slz-theme-option.php';

// Setup plugins
require BUILDPLUS_FRAMEWORK_DIR . '/slz-tgm.php';

// Load class
Buildplus::load_class( 'Breadcrumb' );

/**
 * Register sidebars
 */
add_action( 'widgets_init', array('Buildplus', '[widget.Widget_Init, widgets_init]') );

/**
 * Handles JavaScript detection.
 *
 * Adds a `js` class to the root `<html>` element when JavaScript is detected.
 *
 */
function buildplus_javascript_detection() {
	echo "<script>(function(html){html.className = html.className.replace(/\bno-js\b/,'js')})(document.documentElement);</script>\n";
}
add_action( 'wp_head', 'buildplus_javascript_detection', 0 );

/**
 * Enqueues scripts and styles.
 */
if( ! is_admin() ) {
	add_action( 'wp_enqueue_scripts', array( 'Buildplus', '[theme.Theme_Init, public_enqueue]' ) );
}

require_once BUILDPLUS_FRAMEWORK_DIR . '/slz-functions.php';
require_once BUILDPLUS_FRAMEWORK_DIR . '/slz-menu.php';

// default
/**
 * Customizer additions.
 */
require BUILDPLUS_THEME_DIR . '/inc/customizer.php';

Buildplus::load_class( 'Application' );
$app = new Buildplus_Application();
$app->run();