<?php
/**
 * Header template.
 * 
 * @author Swlabs
 * @since 1.0
 */
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
	<head>
		<meta charset="<?php bloginfo('charset'); ?>">
		<meta name="viewport" content="width=device-width, initial-scale=1">
		<link rel="profile" href="http://gmpg.org/xfn/11">
		<?php if ( is_singular() && pings_open( get_queried_object() ) ) : ?>
		<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
		<?php endif; ?>
		<?php wp_head(); ?>
	</head>

	<body <?php body_class(); ?>>

		<div class="body-wrapper body-wrapper-content <?php echo buildplus_get_body_wrapper_class();?>">
			<?php 
			$loading_enable = Buildplus::get_option('slz-loading-page');
			if( $loading_enable == '1'){
				do_action('buildplus_loading_page');
			}
			?>
			<div class="sidenav-overlay"></div>
			<!-- HEADER-->
			<div id="page" class="wrapper-content site <?php echo buildplus_get_page_class();?>">
				<?php do_action('buildplus_show_header');?>
				<!-- WRAPPER-->
				<div id="wrapper-content">
					<!-- PAGE WRAPPER-->
					<div id="page-wrapper">
						<!-- MAIN CONTENT-->
						<div class="main-content">
							<!-- CONTENT-->
							<div class="content">
								<?php do_action('buildplus_show_slider');?>
								<?php if( ! is_front_page()  && buildplus_has_header_page() ) :?>
								<?php do_action('buildplus_show_page_title');?>
								<?php endif;?>