<?php
/**
 * The template for displaying Search Results pages
 * 
 * @author Swlabs
 * @package BuildPlus
 * @since 1.0
 */
// css to show/hide sidebar.
$buildplus_container_css = buildplus_get_container_css();

if(get_post_type() == "page") {
	$buildplus_css = '
			#wrapper #content-wrapper {
				padding-top: 80px;
				padding-bottom: 80px;
			}';
	do_action( 'buildplus_add_inline_style', $buildplus_css);
}
get_header();
?>
<div class="section blog padding-top-100 padding-bottom-100 ">
	<div class="<?php echo esc_attr( $buildplus_container_css['container_css'] );?>">
		<div class="blog-wrapper row">
			<div id="page-content" class="blog-content <?php echo esc_attr( $buildplus_container_css['content_css'] ); ?>">
				<div class="search-page">
					<?php if ( have_posts() && strlen( trim(get_search_query()) ) != 0) : ?>
					<?php get_search_form();?>
					<div class="news-detail-wrapper">
						<!-- The loop -->
						<div class="list-block column-1">
						<?php while ( have_posts() ) : the_post(); ?>
							<?php get_template_part( 'inc/content-search' ); ?>
						<?php endwhile; ?>
						</div>
						<div class="clearfix"></div>
						<?php echo buildplus_paging_nav(); ?>
					</div>
					<?php else : ?>
						<?php get_template_part( 'inc/content', 'none' ); ?>
					<?php endif; ?>
				</div>
			</div>
			<?php if ( $buildplus_container_css['has_sidebar'] != 'none' ) :?>
				<div id='page-sidebar' class="sidebar <?php echo esc_attr( $buildplus_container_css['sidebar_css'] ); ?>">
					<?php buildplus_get_sidebar($buildplus_container_css['sidebar_id']);?>
				</div>
			<?php endif; ?>
		</div>
	</div>
</div>
<?php get_footer();?>