<?php
$style = array(
	esc_html__('Testimonial 1', 'slz-core') => '1',
	esc_html__('Testimonial 2', 'slz-core') => '2',
	esc_html__('Testimonial 3', 'slz-core') => '3',
);
$yes_no  = array(
	esc_html__('Yes', 'slz-core')				=> 'yes',
	esc_html__('No', 'slz-core')				=> 'no',
);
$sort_by = Buildplus_Core_Params::get('sort-other') ;
// get Testimonial categories
$taxonomy = 'buildplus_testi_cat';
$params_cat = array('empty'   => esc_html__( '-- All Testimonial Categories --', 'slz-core' ) );
$categories = Buildplus_Core_Com::get_tax_options2slug( $taxonomy, $params_cat );
$params = array(
	array(
		'type'           => 'dropdown',
		'heading'        => esc_html__( 'Style', 'slz-core' ),
		'param_name'     => 'style',
		'value'          => $style,
		'description'    => esc_html__( 'Choose style to display.', 'slz-core' ),
	),
	array(
		'type'        => 'param_group',
		'heading'     => esc_html__( 'Category', 'slz-core' ),
		'param_name'  => 'category_list',
		'params'     => array(
			array(
				'type'        => 'dropdown',
				'admin_label' => true,
				'heading'     => esc_html__( 'Add Category', 'slz-core' ),
				'param_name'  => 'category_slug',
				'value'       => $categories,
				'description' => esc_html__( 'Choose special category to filter', 'slz-core'  )
			),
		),
		'value'       => '',
		'callbacks'   => array(
			'after_add' => 'vcChartParamAfterAddCallback'
		),
		'description' => esc_html__( 'Choose testimonial category.', 'slz-core' ),
	),
	array(
		'type'        	=> 'dropdown',
		'heading'     	=> esc_html__( 'Show Signature ?', 'slz-core' ),
		'param_name'  	=> 'show_sign',
		'value'       	=> $yes_no,
		'std'      		=> 'yes',
		'dependency'     => array(
			'element'  => 'style',
			'value'    => array('2'),
		),
		'description' 	=> esc_html__( 'If choose Yes, signature will be show.', 'slz-core' ),
	),
	array(
		'type'            => 'textfield',
		'heading'         => esc_html__( 'Limit Posts', 'slz-core' ),
		'param_name'      => 'limit_post',
		'value'           => '',
		'description'     => esc_html__( 'Add limit posts per page. Set -1 or empty to show all.', 'slz-core' )
	),
	array(
		'type'            => 'textfield',
		'heading'         => esc_html__( 'Offset Posts', 'slz-core' ),
		'param_name'      => 'offset_post',
		'value'           => '0',
		'description'     => esc_html__( 'Enter offset to pass over posts. If you want to start on record 6, using offset 5', 'slz-core' )
	),
	array(
		'type'            => 'dropdown',
		'heading'         => esc_html__( 'Sort By', 'slz-core' ),
		'param_name'      => 'sort_by',
		'value'           => $sort_by,
		'description'     => esc_html__( 'Select order to display list properties.', 'slz-core' ),
	),
	array(
		'type'           => 'textfield',
		'heading'        => esc_html__( 'Extra Class', 'slz-core' ),
		'param_name'     => 'extra_class',
		'description'    => esc_html__( 'Enter extra class name.', 'slz-core' ),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Title Color', 'slz-core' ),
		'param_name'      => 'title_color',
		'description'     => esc_html__( 'Choose color for title.', 'slz-core' ),
		'group'           => esc_html__('Custom Options', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Title Hover Color', 'slz-core' ),
		'param_name'      => 'title_hover_color',
		'dependency'     => array(
			'element'  => 'style',
			'value'    => array('1'),
		),
		'description'     => esc_html__( 'Choose hover color for title.', 'slz-core' ),
		'group'           => esc_html__('Custom Options', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Icon Color', 'slz-core' ),
		'param_name'      => 'icon_color',
		'description'     => esc_html__( 'Choose color for icon.', 'slz-core' ),
		'group'           => esc_html__('Custom Options', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Description Color', 'slz-core' ),
		'param_name'      => 'description_color',
		'value'           => '',
		'description'     => esc_html__( 'Choose color for description.', 'slz-core' ),
		'group'           => esc_html__( 'Custom Options', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Position Color', 'slz-core' ),
		'param_name'      => 'position_color',
		'description'     => esc_html__( 'Choose color for position.', 'slz-core' ),
		'group'           => esc_html__('Custom Options', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Slick Dots Color', 'slz-core' ),
		'param_name'      => 'dot_color',
		'description'     => esc_html__( 'Choose color for slick dots.', 'slz-core' ),
		'group'           => esc_html__('Slick Options', 'slz-core'),
		'dependency'      => array(
			'element'     => 'style',
			'value'       => array('1')
		)
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Slick Dots Active Color', 'slz-core' ),
		'param_name'      => 'dot_active_color',
		'description'     => esc_html__( 'Choose color for slick dots when active.', 'slz-core' ),
		'group'           => esc_html__('Slick Options', 'slz-core'),
		'dependency'      => array(
			'element'     => 'style',
			'value'       => array('1')
		)
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Slick Arrow Color', 'slz-core' ),
		'param_name'      => 'arrow_color',
		'description'     => esc_html__( 'Choose color for slick arrow.', 'slz-core' ),
		'group'           => esc_html__('Slick Options', 'slz-core'),
		'dependency'      => array(
			'element'     => 'style',
			'value'       => array('2')
		)
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Slick Arrow Hover Color', 'slz-core' ),
		'param_name'      => 'arrow_hv_color',
		'description'     => esc_html__( 'Choose color for slick arrow when hover.', 'slz-core' ),
		'group'           => esc_html__('Slick Options', 'slz-core'),
		'dependency'      => array(
			'element'     => 'style',
			'value'       => array('2')
		)
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Slick Arrow Background Color', 'slz-core' ),
		'param_name'      => 'arrow_bg_color',
		'description'     => esc_html__( 'Choose color for slick arrow background.', 'slz-core' ),
		'group'           => esc_html__('Slick Options', 'slz-core'),
		'dependency'      => array(
			'element'     => 'style',
			'value'       => array('2')
		)
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Slick Arrow Background Hover Color', 'slz-core' ),
		'param_name'      => 'arrow_bg_hv_color',
		'description'     => esc_html__( 'Choose color for slick arrow background when hover.', 'slz-core' ),
		'group'           => esc_html__('Slick Options', 'slz-core'),
		'dependency'      => array(
			'element'     => 'style',
			'value'       => array('2')
		)
	)
);
vc_map(array(
	'name'        => esc_html__( 'SLZ Testimonial', 'slz-core' ),
	'base'        => 'slzcore_testimonial_sc',
	'class'       => 'slzcore-sc',
	'icon'        => 'icon-slzcore_testimonial_sc',
	'category'    => BUILDPLUS_CORE_SC_CATEGORY,
	'description' => esc_html__( 'List of testimonials.', 'slz-core' ),
	'params'      => $params
));