<?php
class Buildplus_Core_Project extends Buildplus_Core_Custom_Post_Model {

	private $post_type = 'buildplus_project';
	private $post_taxonomy = 'buildplus_project_cat';
	private $post_taxonomy_location = 'buildplus_project_location';
	private $html_format;

	public function __construct() {
		$this->meta_attributes();
		$this->set_meta_attributes();
		$this->post_meta_prefix = $this->post_type . '_';
		$this->taxonomy_cat = $this->post_taxonomy;
		$this->taxonomy_location = $this->post_taxonomy_location;
		$this->html_format = $this->set_default_options();
	}
	public function meta_attributes() {
		$meta_atts = array( 
			'description'         	=> esc_html__( 'Short Description', 'slz-core' ),
			'pro_description'     	=> esc_html__( 'Project Description', 'slz-core' ),
			'day_begin'				=> esc_html__( 'Day Begin', 'slz-core' ),
			'day_end'				=> esc_html__( 'Day End', 'slz-core' ),
			'process'				=> esc_html__( 'Process', 'slz-core' ),
			'attribute'        		=> esc_html__( 'Attributes', 'slz-core' ),
			'show_gallery'        	=> esc_html__( 'Show Gallery Images', 'slz-core' ),
			'gallery_images'      	=> esc_html__( 'Gallery Images', 'slz-core' ),
			'is_featured'         	=> esc_html__( 'Features', 'slz-core' ),
			'attachment_ids'      	=> '',
			'gallery_box_title'   	=> esc_html__( 'Gallery', 'slz-core' ),
			'gallery_stretch'     	=> '',
		);
		$this->post_meta_atts = $meta_atts;
	}
	public function set_meta_attributes() {
		$meta_arr = array();
		$meta_label_arr = array();
		foreach( $this->post_meta_atts as $att => $name ){
			$key = $att;
			$meta_arr[$key] = '';
			$meta_label_arr[$key] = $name;
		}
		$this->post_meta_def = $meta_arr;
		$this->post_meta = $meta_arr;
		$this->post_meta_label = $meta_label_arr;
	}
	public function init( $atts = array(), $query_args = array() ) {
		$meta_key_compare = array();
		$default_atts = array(
			'layout'      		=> 'project',
			'style'      		=> '',
			'column'      		=> '',
			'limit_post'   		=> '-1',
			'offset_post'  		=> '0',
			'sort_by'      		=> '',
			'post_id'      		=> '',
			'category'      	=> '',
			'list_post'      	=> '',
			'method'            => '',
			'extra_class'       => '',
			'show_desc'         => '',
			'category_slug'     => '',
			'location_slug'     => ''
		);
		$atts = array_merge( $default_atts, $atts );
		if( !empty($atts['method']) && $atts['method'] == 'project' ) {
			$atts['post_id'] = $this->parse_list_to_array( 'project', $atts['list_post'] );
		}
		if ( !empty($atts['is_featured']) && $atts['is_featured'] == 'yes' ) {
			$atts['meta_key'] = array(
				$this->post_meta_prefix. 'is_featured' => 1
			);
		}
		if ( !empty($atts['date_start']) ) {
			$meta_key_compare[] = array(
				'key'			=> $this->post_meta_prefix. 'day_begin',
				'value'			=> $atts['date_start'],
				'type'			=> 'DATE',
				'compare'		=> '>='
			);
		}
		if ( !empty($atts['date_end']) ) {
			$meta_key_compare[] = array(
				'key'			=> $this->post_meta_prefix. 'day_end',
				'value'			=> $atts['date_end'],
				'type'			=> 'DATE',
				'compare'		=> '<='
			);
		}
		$atts['meta_key_compare'] = $meta_key_compare;
		$this->attributes = $atts;

		// query
		$default_args = array(
			'post_type' => $this->post_type,
		);
		$query_args = array_merge( $default_args, $query_args );
		// setting
		$this->setting( $query_args);
	}
	public function setting( $query_args ){
		if( !isset( $this->attributes['uniq_id'] ) ) {
			$this->attributes['uniq_id'] = $this->post_type . '-' .Buildplus_Core::make_id();
		}
		// query
		$this->query = $this->get_query( $query_args, $this->attributes );
		$this->post_count = 0;
		if( $this->query->have_posts() ) {
			$this->post_count = $this->query->post_count;
		}

		$this->get_thumb_size();
		$this->set_responsive_class();

		$custom_css = $this->add_custom_css();
		if( $custom_css ) {
			do_action( BUILDPLUS_CORE_ADD_INLINE_CSS, $custom_css );
		}
	}
	public function reset(){
		wp_reset_postdata();
	}

	public function add_custom_css() {
		$custom_css = '';
		if( !empty($this->attributes['color_title']) ) {
			$custom_css .= sprintf('.%1$s .block-content .title { color: %2$s;}',
								$this->attributes['uniq_id'], $this->attributes['color_title']
							);
			/* carousel */
			$custom_css .= sprintf('.%1$s .project-wrapper .project-info .title-project { color: %2$s;}',
								$this->attributes['uniq_id'], $this->attributes['color_title']
							);
		}
		if( !empty($this->attributes['color_title_hv']) ) {
			$custom_css .= sprintf('.%1$s .block-content .title:hover { color: %2$s;}',
								$this->attributes['uniq_id'], $this->attributes['color_title_hv']
							);
			/* carousel */
			$custom_css .= sprintf('.%1$s .project-wrapper .project-info .title-project:hover { color: %2$s;}',
								$this->attributes['uniq_id'], $this->attributes['color_title']
							);
		}
		if( !empty($this->attributes['color_title_line']) ) {
			$custom_css .= sprintf('.%1$s .block-content .title:before { background-color: %2$s;}',
								$this->attributes['uniq_id'], $this->attributes['color_title_line']
							);
		}
		if( !empty($this->attributes['color_description']) ) {
			$custom_css .= sprintf('.%1$s .block-content .description { color: %2$s;}',
								$this->attributes['uniq_id'], $this->attributes['color_description']
							);
			/* carousel */
			$custom_css .= sprintf('.%1$s .project-wrapper .project-info .description { color: %2$s;}',
								$this->attributes['uniq_id'], $this->attributes['color_description']
							);
		}
		if( !empty($this->attributes['color_process_text']) ) {
			$custom_css .= sprintf('.%1$s .block-content .progress-bar-wrapper { color: %2$s;}',
								$this->attributes['uniq_id'], $this->attributes['color_process_text']
							);
		}
		if( !empty($this->attributes['color_process_bg']) ) {
			$custom_css .= sprintf('.%1$s .block-content .progress-bar-wrapper .progress { background-color: %2$s;}',
								$this->attributes['uniq_id'], $this->attributes['color_process_bg']
							);
		}
		if( !empty($this->attributes['color_process_at']) ) {
			$custom_css .= sprintf('.%1$s .block-content .progress-bar-wrapper .progress .progress-bar { background-color: %2$s;}',
								$this->attributes['uniq_id'], $this->attributes['color_process_at']
							);
		}
		if( !empty($this->attributes['color_item_bg']) ) {
			$custom_css .= sprintf('.%1$s .block-image:after { background-color: %2$s;}',
								$this->attributes['uniq_id'], $this->attributes['color_item_bg']
							);
		}
		if( !empty($this->attributes['color_item_border']) ) {
			$custom_css .= sprintf('.%1$s .block-content:before { background-color: %2$s;}',
								$this->attributes['uniq_id'], $this->attributes['color_item_border']
							);
		}
		if( !empty($this->attributes['color_item_button']) ) {
			$custom_css .= sprintf('.%1$s .block-content .readmore-icons { color: %2$s;}',
								$this->attributes['uniq_id'], $this->attributes['color_item_button']
							);
		}
		if( !empty($this->attributes['color_item_button_bg']) ) {
			$custom_css .= sprintf('.%1$s .block-content .readmore-icons { background-color: %2$s;}',
								$this->attributes['uniq_id'], $this->attributes['color_item_button_bg']
							);
		}

		/*casousel*/
		if( !empty($this->attributes['color_button']) ) {
			$custom_css .= sprintf('.%1$s .project-wrapper .project-info .btn { color: %2$s;}',
								$this->attributes['uniq_id'], $this->attributes['color_button']
							);
		}
		if( !empty($this->attributes['color_button_hv']) ) {
			$custom_css .= sprintf('.%1$s .project-wrapper .project-info .btn:hover { color: %2$s;}',
								$this->attributes['uniq_id'], $this->attributes['color_button_hv']
							);
		}
		if( !empty($this->attributes['color_button_bg']) ) {
			$custom_css .= sprintf('.%1$s .project-wrapper .project-info .btn { background-color: %2$s;}',
								$this->attributes['uniq_id'], $this->attributes['color_button_bg']
							);
		}
		if( !empty($this->attributes['color_button_bg_hv']) ) {
			$custom_css .= sprintf('.%1$s .project-wrapper .project-info .btn:hover { background-color: %2$s;}',
								$this->attributes['uniq_id'], $this->attributes['color_button_bg_hv']
							);
		}
		if( !empty($this->attributes['color_button_border']) ) {
			$custom_css .= sprintf('.%1$s .project-wrapper .project-info .btn { border-color: %2$s;}',
								$this->attributes['uniq_id'], $this->attributes['color_button_border']
							);
		}
		if( !empty($this->attributes['color_button_border_hv']) ) {
			$custom_css .= sprintf('.%1$s .project-wrapper .project-info .btn:hover { border-color: %2$s;}',
								$this->attributes['uniq_id'], $this->attributes['color_button_border_hv']
							);
		}
		if( !empty($this->attributes['color_slide_arrow']) ) {
			$custom_css .= sprintf('.%1$s .slick-arrow:before { color: %2$s !important;}',
								$this->attributes['uniq_id'], $this->attributes['color_slide_arrow']
							);
		}
		if( !empty($this->attributes['color_slide_arrow_hv']) ) {
			$custom_css .= sprintf('.%1$s .slick-arrow:hover:before { color: %2$s !important;}',
								$this->attributes['uniq_id'], $this->attributes['color_slide_arrow_hv']
							);
		}
		if( !empty($this->attributes['color_slide_arrow_bg']) ) {
			$custom_css .= sprintf('.%1$s .slick-arrow { background-color: %2$s !important;}',
								$this->attributes['uniq_id'], $this->attributes['color_slide_arrow_bg']
							);
		}
		if( !empty($this->attributes['color_slide_arrow_bg_hv']) ) {
			$custom_css .= sprintf('.%1$s .slick-arrow:hover { background-color: %2$s !important;}',
								$this->attributes['uniq_id'], $this->attributes['color_slide_arrow_bg_hv']
							);
		}
		if( !empty($this->attributes['color_slide_dots']) ) {
			$custom_css .= sprintf('.%1$s .slick-dots button:before { color: %2$s !important;}',
								$this->attributes['uniq_id'], $this->attributes['color_slide_dots']
							);
		}
		return $custom_css;		
	}

	public function set_responsive_class( $atts = array() ) {
		$class = '';
		$column = $this->attributes['column'];
		$def = array(
			'1' => 'col-md-12 project-col-1',
			'2' => 'col-lg-6 col-md-6 col-xs-12 project-col-2',
			'3' => 'col-lg-4 col-md-4 col-sm-6 col-xs-12 project-col-3',
			'4' => 'col-lg-3 col-md-4 col-sm-6 col-xs-12 project-col-4',
		);;
		
		if( $column && isset($def[$column])) {
			$this->attributes['responsive-class'] = $def[$column];
		} else {
			$this->attributes['responsive-class'] = $def['2'];
		}
	} 
	
	/*------------------- Post Infomations >> -------------------*/
	public function set_default_options( $html_options = array() ) {
		$defaults = array(
			'title_format'       	=> '%1$s',
		);
		$html_options = array_merge( $defaults, $html_options );
		return $html_options;
	}
	private function get_thumb_size() {
		$params = Buildplus_Core_Params::get( 'block_image_size', $this->attributes['layout'] );
		if( !empty($this->attributes['column']) && $this->attributes['column'] == 1 ) {
			$this->attributes['thumb-size'] = array(
				'large'          => 'post-thumbnail',
				'no-image-large' => 'thumb-800x600.gif',
			);
		}
		else {
			$this->attributes['thumb-size'] = Buildplus_Core_Util::get_thumb_size( $params, $this->attributes );
		}
	}

	/*-------------------- >> Render Html << -------------------------*/
	/**
	 * Render html by shortcode.
	 *
	 * @param array $html_options
	 * Format: 1$ - image, 2$ - title, 3$ - description, 4$ - permalink, 5$ - post_id, 6$ - process, 7$ - responsive class
	 */
	public function render_project_list_sc( $html_options = array() ) {
		$this->html_format = $this->set_default_options( $html_options );
		$row_count = 0;
		if( $this->query->have_posts() ) {
			while ( $this->query->have_posts() ) {
				$this->query->the_post();
				$this->loop_index();

				$html_options = $this->html_format;
				printf( $html_options['html_format'],
					$this->get_featured_image( $html_options, 'large' ),
					$this->get_title( $html_options ),
					$this->get_meta_description(),
					$this->permalink,
					$this->post_id,
					$this->get_meta_process(),
					$this->attributes['responsive-class']
				);
				$row_count++;
			}
			$this->reset();
			if( !empty($this->attributes['pagination']) && $this->attributes['pagination'] == 'yes' ) {
				echo BuildPlus_Core_Pagination::paging_nav( $this->query->max_num_pages, 2, $this->query);
			}
		}
	}

	/**
	 * Format: 1$ - image gallery, 2$ - title, 3$ - description, 4$ - permalink, 5$ - button, 6$ - post_id
	 */
	public function render_project_carousel_sc( $html_options = array() ) {
		$this->html_format = $this->set_default_options( $html_options );
		$row_count = 0;
		if( $this->query->have_posts() ) {
			while ( $this->query->have_posts() ) {
				$this->query->the_post();
				$this->loop_index();

				$html_options = $this->html_format;
				printf( $html_options['html_format'],
					$this->get_meta_gallery_image_slide( $html_options, 'large' ),
					$this->get_title( $html_options ),
					$this->get_meta_description(),
					$this->permalink,
					$this->get_button_readmore(),
					$this->post_id
				);
				$row_count++;
			}
			$this->reset();
		}
	}

	public function render_widget( $html_options = array() ) {
		$this->set_default_options( $html_options );
		while ( $this->query->have_posts() ) {
			$this->query->the_post();
			$this->loop_index();
			printf( $html_options['html_format'],
					$this->get_title(),
					$this->permalink
			);
		}
		$this->reset();
	}

	public function render_attr_widget( $html_options = array() ) {
		$this->set_default_options( $html_options );
		while ( $this->query->have_posts() ) {
			$this->query->the_post();
			$this->loop_index();
			if(!empty($this->post_meta['attribute'])){
				foreach ($this->post_meta['attribute'] as $value) {
					if( !empty($value) && !empty( $value['name'] ) && !empty( $value['value'] ) ){
						printf( $html_options['html_format'],
								$value['name'],
								$value['value'],
								$this->get_post_class()
						);
					}
				}
			}
		}
		$this->reset();
	}
	/*-------------------- >> General Functions << --------------------*/
	public function get_meta_process() {
		$custom_css = $out = '';
		if ( !empty($this->attributes['show_process']) && $this->attributes['show_process'] != 'yes' ) {
			return '';
		}
		$format = '
			<div class="progress-bar-wrapper">
				<div class="progress">
					<div role="progressbar" aria-valuenow="%2$s" aria-valuemin="0" aria-valuemax="100" class="progress-bar progress-bar-striped active"></div>
				</div>
				<div class="text-left">%3$s</div>
				<div class="text-right">%2$s%1$s</div>
			</div>
		';
		if ( isset($this->html_format['process_format']) ) {
			$format = $this->html_format['process_format'];
		}
		$process = $this->post_meta['process'];
		if( !empty( $process ) ) {
			$custom_css .= sprintf('.%1$s .project_%2$s .progress-bar-wrapper .progress .progress-bar { width: %3$s%4$s;}',
									$this->attributes['uniq_id'], $this->post_id, $process, esc_html('%')
								);
 			$out = sprintf($format, esc_html( '%' ), $process, esc_html__( 'Completion', 'slz-core' ) );
		}
		if( $custom_css ) {
			do_action( BUILDPLUS_CORE_ADD_INLINE_CSS, $custom_css );
		}
 		return $out;
	}

	public function get_button_readmore() {
		$out = '';
		$format = '<a href="%2$s" class="btn main-color">%1$s</a>';
		if ( isset($this->html_format['readmore_format']) ) {
			$format = $this->html_format['readmore_format'];
		}
		$button_text = esc_html__( 'Read more', 'slz-core' );
		if ( !empty($this->attributes['button_text']) ) {
			$button_text = $this->attributes['button_text'];
			$out = sprintf($format, $button_text, $this->permalink );
		}
		return $out;
	}

	public function get_meta_short_description() {
		$format = '%s';
		$show_desc = $this->attributes['show_desc'];
		if ( !empty($show_desc) && $show_desc == 'yes' ) {
			$description = $this->post_meta['description'];
			if ( empty($description) ) {
				$description = $this->post_meta['pro_description'];
			}
			if ( empty($description) ) {
				$description = $this->get_excerpt();
			}
		}
		if ( empty($description) ) {
			return '';
		}
		$out = sprintf($format, wp_kses_post(nl2br($description)) );
		return $out;
	}
	public function get_meta_proj_description() {
		$format = '%s';
		$show_desc = $this->attributes['show_desc'];
		if ( !empty($show_desc) && $show_desc == 'yes' ) {
			$description = $this->post_meta['pro_description'];
			if ( empty($description) ) {
				$description = $this->post_meta['description'];
			}
			if ( empty($description) ) {
				$description = $this->get_excerpt();
			}
		}
		if ( empty($description) ) {
			return '';
		}
		$out = sprintf($format, wp_kses_post(nl2br($description)) );
		return $out;
	}

	public function get_meta_description() {
		$out_desc = $output = '';
		$format = '%s';
		$show_desc = $this->attributes['show_desc'];
		if ( !empty($show_desc) && $show_desc == 'yes' ) {
			if ( $this->attributes['desc_type'] == 'desc_proj' ) {
				$out_desc = $this->get_meta_proj_description();
			} else {
				$out_desc = $this->get_meta_short_description();
			}
			if ( empty($out_desc) ) {
				$out_desc = $this->get_excerpt( $this->html_format );
			}
			$desc_lenght = (int) $this->attributes['desc_lenght'];
			if ( !empty($desc_lenght) ) {
				$out_desc = wp_trim_words( $out_desc, $desc_lenght, '...' );
			}
			if ( isset($this->html_format['excerpt_format']) ) {
				$format = $this->html_format['excerpt_format'];
			}
			$output = sprintf($format, wp_kses_post(nl2br($out_desc)) );
		}
		return $output;
	}

	public function get_meta_gallery_image_slide( $html_options = array(), $thumb_type = 'large', $echo = false ) {
		$output = $thumb_img = '';
		$format = '<div class="item"><a href="javascript:void(0)">%s</a></div>';
		$thumb_size = $this->attributes['thumb-size'][$thumb_type];
		$thumb_class = Buildplus_Core::get_value( $html_options, 'thumb_class', 'img-responsive' );
		$attrArr = array( 'class' => $thumb_class );

		if ( has_post_thumbnail( $this->post_id ) ) {
			$feature_thumb_id = get_post_thumbnail_id( $this->post_id );
			$get_attached_file = get_attached_file($feature_thumb_id);
			if ( file_exists($get_attached_file) ) {
				$thumb_img = wp_get_attachment_image( $feature_thumb_id, $thumb_size, false, $attrArr );
				$output .= sprintf( $format, $thumb_img );
			}			
		}

		$gallery = $this->post_meta['gallery_images'];
		$galleryArr = explode(',', $gallery);
		$galleryArr = array_filter($galleryArr);
		if( !empty($galleryArr) && is_array($galleryArr) ) {

			foreach ($galleryArr as $thumb_id) {
				$get_attached_file = get_attached_file($thumb_id);
				if ( !file_exists($get_attached_file) ) {
					continue;
				}
				$thumb_img = wp_get_attachment_image( $thumb_id, $thumb_size, false, $attrArr );
				$output .= sprintf( $format, $thumb_img );
			}
		}

		if( $echo ) {
			echo wp_kses_post( $output );
		} else {
			return $output;
		}
	}
	
	public function get_attachment_ids() {
		$attachment_ids = array();
		if( $this->query->have_posts() ) {
			while ( $this->query->have_posts() ) {
				$this->query->the_post();
				$this->loop_index();
				$ids = $this->post_meta['attachment_ids'];
				if( !empty( $ids ) ){
					$attachment_ids = array_merge( $attachment_ids, explode( ',', trim( $ids, ',' ) ) );
				}
			}
			$this->reset();
		}
		return $attachment_ids;
	}

}