<?php
$uniq_id = 'newsletter-'.esc_attr($id);

if ( !empty($input_name_placeholder) ) {
	$name_placeholder = $input_name_placeholder;
} else {
	$name_placeholder = esc_html__( 'FullName', 'slz-core' );
}

if ( !empty($input_email_placeholder) ) {
	$email_placeholder = $input_email_placeholder;
} else {
	$email_placeholder = esc_html__( 'Email Address', 'slz-core' );
}

if ( !empty($button_text) ) {
	$text_button = $button_text;
} else {
	$text_button = esc_html__( 'Get Notified', 'slz-core' );
}

$custom_css = '';
if ( !empty($color_input) ) {
	$custom_css .= sprintf( '.%1$s input.form-control { color: %2$s }', esc_attr($uniq_id), esc_attr($color_input) );
	$custom_css .= sprintf( '.%1$s input.form-control::-webkit-input-placeholder { color: %2$s }', esc_attr($uniq_id), esc_attr($color_input) );
	$custom_css .= sprintf( '.%1$s input.form-control::-moz-placeholder { color: %2$s }', esc_attr($uniq_id), esc_attr($color_input) );
	$custom_css .= sprintf( '.%1$s input.form-control:-ms-input-placeholder { color: %2$s }', esc_attr($uniq_id), esc_attr($color_input) );
	$custom_css .= sprintf( '.%1$s input.form-control:-moz-placeholder { color: %2$s }', esc_attr($uniq_id), esc_attr($color_input) );
}
if ( !empty($color_input_border) ) {
	$custom_css .= sprintf( '.%1$s input.form-control { border-color: %2$s !important; }', esc_attr($uniq_id), esc_attr($color_input_border) );
}
if ( !empty($color_input_border_fc) ) {
	$custom_css .= sprintf( '.%1$s input.form-control:focus { border-color: %2$s !important; }', esc_attr($uniq_id), esc_attr($color_input_border_fc) );
}
if ( !empty($color_button) ) {
	$custom_css .= sprintf( '.%1$s button.btn { color: %2$s !important; }', esc_attr($uniq_id), esc_attr($color_button) );
}
if ( !empty($color_button_hv) ) {
	$custom_css .= sprintf( '.%1$s button.btn:hover { color: %2$s !important; }', esc_attr($uniq_id), esc_attr($color_button_hv) );
}
if ( !empty($color_button_bg) ) {
	$custom_css .= sprintf( '.%1$s button.btn { background-color: %2$s !important; }', esc_attr($uniq_id), esc_attr($color_button_bg) );
}
if ( !empty($color_button_bg_hv) ) {
	$custom_css .= sprintf( '.%1$s button.btn:hover { background-color: %2$s !important; }', esc_attr($uniq_id), esc_attr($color_button_bg_hv) );
}
if ( !empty($color_button_border) ) {
	$custom_css .= sprintf( '.%1$s button.btn { border-color: %2$s !important; }', esc_attr($uniq_id), esc_attr($color_button_border) );
}
if ( !empty($color_button_border_hv) ) {
	$custom_css .= sprintf( '.%1$s button.btn:hover { border-color: %2$s !important; }', esc_attr($uniq_id), esc_attr($color_button_border_hv) );
}

if ( !empty($custom_css) ) {
	do_action( BUILDPLUS_CORE_ADD_INLINE_CSS, $custom_css );
} 
?>
<div class="slz-shortcode sc_newsletter_widget <?php echo $uniq_id; ?> <?php echo esc_attr($extra_class); ?>">
	<div class="widget send-mail-widget">
		<?php if( !empty($title)):?>
		<div class="title-widget"><?php echo esc_attr($title);?></div>
		<?php endif;?>
		<div class="send-mail-inner">
			<div class="input-wrapper">
				<?php if( !empty($description) ):?>
					<div class="text"><?php echo wp_kses_post($description);?></div>
				<?php endif;?>
				<?php
				$form = '';
				if( defined( 'NEWSLETTER_VERSION' ) && class_exists('NewsletterSubscription') ){
					$form = NewsletterSubscription::instance()->get_form_javascript();
				}
				$form .= '<form action="' . esc_url(home_url('/')) . '?na=s" onsubmit="return newsletter_check(this)" method="post">';
					if( !empty($show_name) && $show_name == 'yes' ){
						$form .= '<input class="form-control" type="text" required name="nn" placeholder="'.esc_attr($name_placeholder).'" onclick="if (this.defaultValue==this.value) this.value=\'\'" onblur="if (this.value==\'\') this.value=this.defaultValue"/>';
					}
					$form .= '<input type="hidden" name="nr" value="widget"/>';
					$form .= '<input class="form-control" type="email" required name="ne" placeholder="'.esc_attr( $email_placeholder ).'" onclick="if (this.defaultValue==this.value) this.value=\'\'" onblur="if (this.value==\'\') this.value=this.defaultValue"/>';
					$form .= '<button type="submit" class="btn main-color">'.esc_html( $text_button ).'</button>';
				$form .= '</form>';
				echo ($form);
				?>
			</div>
		</div>
	</div>
</div>