<?php
/**
 * Widget_Newsletter class.
 * 
 * @since 1.0
 */
if( !defined( 'NEWSLETTER_VERSION' ) ){
	exit;
}
class Buildplus_Core_Widget_Newsletter extends NewsletterWidget {
	public function __construct() {
		$widget_ops = array( 'classname' => '', 'description' => esc_html__( "Newsletter widget to add subscription forms.", 'buildplus') );
		parent::__construct( 'buildplus_newsletter', esc_html_x( 'Newsletter', 'Newsletter widget', 'buildplus' ), $widget_ops );
	}

	function form($instance) {
		$widget_default = array(
			'title'              => '',
			'description'        => '',
		);
		$instance = wp_parse_args( (array) $instance, $widget_default );
		printf('<p><label for="%s">%s
					<input type="text" class="widefat" id="%s" name="%s" value="%s" />
				</label></p>',
				esc_attr( $this->get_field_id('title') ),
				esc_html__( 'Title:', 'buildplus' ),
				esc_attr( $this->get_field_id('title') ),
				esc_attr( $this->get_field_name('title') ),
				esc_attr($instance['title'])
			);
		printf('<p><label for="%1$s">%2$s
					<textarea class="widefat" rows="3" id="%1$s" name="%3$s">%4$s</textarea>
				</label>%5$s</p>',
				esc_attr( $this->get_field_id('description') ),
				esc_html__( 'Description:', 'buildplus' ),
				esc_attr( $this->get_field_name('description') ),
				esc_textarea($instance['description']),
				esc_html__( 'Enter description to display on newsletter form.', 'buildplus' )
			);
	}
	
	function update($new_instance, $old_instance) {
		$instance                       = $old_instance;
		$instance['title']              = strip_tags($new_instance['title']);
		$instance['description']        = $new_instance['description'];
		return $instance;
	}
	
	function widget($args, $instance) {
		global $newsletter;
		extract($args);
		$default = array(
			'title'       => '',
			'description' => ''
		);
		$instance = wp_parse_args( (array) $instance, $default ); 
		$title       = apply_filters('widget_title', $instance['title']);
		$description = apply_filters('widget_text', $instance['description']);
		extract( $instance );
		echo wp_kses_post( $before_widget ); ?>
			<div class="widget send-mail-widget"><?php
				if (!empty($instance['title'])) {
					echo wp_kses_post( $before_title );
					echo esc_attr( $title );
					echo wp_kses_post( $after_title );
				}?>
				<div class="send-mail-inner"><?php
					if(!empty($description)){ ?>
						<div class="text"><?php echo wp_kses_post(nl2br($description)); ?></div><?php
					}
					$form = self::get_slz_widget_form();
					$form = $newsletter->replace($form);
					printf ('%s',$form);?>
				</div>
			</div><?php			
		echo wp_kses_post( $after_widget );
	}

	static function get_slz_widget_form() {
		$options_profile = get_option('newsletter_profile');
		$form = NewsletterSubscription::instance()->get_form_javascript();
		$form .= '<form action="' . esc_url(home_url('/')) . '?na=s" onsubmit="return newsletter_check(this)" method="post">';
			$form .= '<input class="form-control" type="text" required name="nn" placeholder="'.esc_html__('Full Name', 'buildplus').'" onclick="if (this.defaultValue==this.value) this.value=\'\'" onblur="if (this.value==\'\') this.value=this.defaultValue"/>';
			$form .= '<input type="hidden" name="nr" value="widget"/>';
			$form .= '<input class="form-control" type="email" required name="ne" placeholder="'.esc_html__('Email Address', 'buildplus').'" onclick="if (this.defaultValue==this.value) this.value=\'\'" onblur="if (this.value==\'\') this.value=this.defaultValue"/>';
			$form .= '<button type="submit" class="btn main-color">'.esc_html__('Submit', 'buildplus' ).'</button>';
		$form .= '</form>';
		return $form;
	}
}